/****************************************************************************/
/*!

  @file        SysView_RestartInformation.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "RestartInformation" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_RestartInformation.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_RestartInformation::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_RestartInformation::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_FIXED ,SV_BADINDEXCOUNT, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_PREVIOUSCONVERTERVERSION, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTSAVEPOINTID, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_LASTSAVEPOINTREASON, 20);
	m_Table->AppendCol (ITOCT_TIMESTAMP ,SV_LASTSAVEPOINTDATE, 0);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTSAVEPOINTSEQUENCE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTSAVEPOINTOFFSETONDEVICE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTSAVEPOINTOFFSETINPAGE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_OPENTRANSCOUNT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_OPENTRANSFILEROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_HISTORYDIRECTORYROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_FILEDIRECTORYROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LONGDIRECTORYROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_RESTARTIOSEQUENCE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_RESTARTOFFSETOFPAGEONDEVICE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_RESTARTOFFSETOFENTRYINPAGE, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_RESTARTENTRYTYPE,  20);
	m_Table->AppendCol (ITOCT_TIMESTAMP ,SV_RESTARTENTRYDATE, 0);
	m_Table->AppendCol (ITOCT_FIXED ,SV_CYCLERELATEDENDOFFSET, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTKNOWNSEQUENCE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_LASTKNOWNOFFSET, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_DATABASEIDENTIFIER, 100);
	m_Table->AppendCol (ITOCT_CHAR ,SV_LASTSAVEPOINTRELEASEVERSION, 40);
	m_Table->AppendCol (ITOCT_CHAR ,SV_INSTALLSERVERDBVERSION, 40);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_RestartInformation::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_RestartInformation::GetColCount", SysView_Trace, 5);

    return SV_CC_RESTARTINFORMATION;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_RestartInformation::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_RestartInformation::EstimateRows", SysView_Trace, 5);

    return SV_ER_RESTARTINFORMATION;
}

/*---------------------------------------------------------------------------*/

void SysView_RestartInformation::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_RestartInformation::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
