/*!
  @file           Catalog_ISessionCache.hpp
  @author         ThomasA
  @special area   Catalog
  @brief          interface of a Catalog Session Cache
  @see            example.html ...
  @first created  000-03-09  18:21

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/


#ifndef CATALOG_ISESSIONCACHE_HPP
#define CATALOG_ISESSIONCACHE_HPP

class SharedSQL_SQLCache;
class Catalog_DBProcObject;
class Catalog_DBProcFileObject;
class Catalog_DBProcInfoObject;
class SharedSQL_PrepareHandle;
class SQLMan_ParseId;
class SQLMan_Context;
class Catalog_MessBlockObject;

class Catalog_ISessionCache
{
public :
    /*!
    @brief returns the error code of the last operation
    */
    virtual SAPDB_Int2 GetLastError() const = 0;
    /*
    @brief loads the byte code of a stored procedure
    @param context the current sql manager context
    @param procId  the internal name of the procedure
    @return a pointer to the code or NULL if the code does not exist
    */
    virtual Catalog_MessBlockObject* LoadCode(const SQLMan_Surrogate& procId) = 0;
    /*!
    @brief loads the description of a db-procedure into the session cache
    */
    virtual Catalog_DBProcObject* LoadDBProcObject(const SQLMan_Surrogate& procId) = 0;
    /*!
    @brief loads the info description of a db-procedure into the session cache
    */
    virtual Catalog_DBProcInfoObject* LoadDBProcInfoObject(const SQLMan_Surrogate& procId) = 0;
    /*!
    @brief loads the file description of a db-procedure into the session cache
    */
    virtual Catalog_DBProcFileObject* LoadDBProcFileObject(const SQLMan_Surrogate& procId) = 0;
    /*!
    @brief  stores the current plan into the shared sql plan cache
    @return true if the plan could be stored successfully, otherwise false
    */
    virtual bool StorePlan(SharedSQL_SQLCache& sharedSQLManager, 
                   SharedSQL_PrepareHandle*    handle, 
                   SQLMan_ParseId&              parseId,
                   bool                         prepareFlag) = 0;
};

#endif