/*!
  @file           RTE_ConsoleCommon.cpp
  @author         StefanP
  @special area   Console (XCons) <-> Console Thread
  @brief          Common Routines
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/




/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include  "RunTime/RTE_ConsoleCommon.hpp"
#include  "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include  "SAPDBCommon/Tracing/SAPDBTrace_Usage.hpp"
#include  "RunTime/RTE_MessageList.hpp"
#include  "RunTime/RTE_Message.hpp"
#include  "RunTime/RTE_Console_Messages.hpp"



extern SAPDBTrace_Topic Console_Trace;

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  STRUCTURES, TYPES, UNIONS ...                                            *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/

/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void    RTE_ConvertEventToMessageList 
(
    SAPDBErr_MessageList            &   messageList,
    teo200_EventList        const   &   eventList
)
{
/*===========================================================================*
 *  Locals                                                                   *
 *===========================================================================*/
    SAPDBErr_MessageList::MessageType               messageType;
    SAPDB_UInt4                                     messageID; 
    teo200_EventList                    const   *   pTmpEventList = &eventList;

/*===========================================================================*
 *  Instructions                                                             *
 *===========================================================================*/
    SAPDBTRACE_ROUTINE_DEBUG("RTE_ConvertEventToMessageList", Console_Trace, 1);

    while (NULL != pTmpEventList)
    {
        messageID   = pTmpEventList->eo200_EventID ();

        switch (eventList.eo200_EventType ())
        {
            case teo200_EventList::Error_eeo200:
                messageType = SAPDBErr_MessageList::Error;
                break;
            
            case teo200_EventList::Warning_eeo200:
                messageType = SAPDBErr_MessageList::Warning;
                break;
            
            case teo200_EventList::Info_eeo200:
            default:
                messageType = SAPDBErr_MessageList::Info;
                break;
        }

        messageList = SAPDBErr_MessageList (pTmpEventList->eo200_EventLabel (), 
                                                          "", 
                                                          0, 
                                                          messageType, 
                                                          messageID, 
                                                          pTmpEventList->eo200_EventMsg (), 
                                                          0)
                      + messageList;

        pTmpEventList = pTmpEventList->eo200_NextEvent ();
    }

    return;
}

/*---------------------------------------------------------------------------*/

void      RTE_ConvertMessageToEventList 
(
    SAPDBErr_MessageList   const   &   messageList,
    teo200_EventList               &   eventList
)
{
/*===========================================================================*
 *  Locals                                                                   *
 *===========================================================================*/
    teo200_EventList::teo200_EventID                eventID;
    teo200_EventList::teo200_EventType              eventType;
    SAPDB_UInt4                                     msgCount;
    SAPDBErr_MessageList                const   *   pTmpMessageList;
//!!!Vorsicht: Beim eo200_Create muss das _tcscpy in _tcsncpy fr das Label gendert werden, sonst knnen
//berschreiber auftreten!!
    _TCHAR                                          eventLabel[MAX_EVENTLABEL_LEN_EO200 + 1];

/*===========================================================================*
 *  Instructions                                                             *
 *===========================================================================*/
    SAPDBTRACE_ROUTINE_DEBUG("RTE_ConvertMessageToEventList", Console_Trace, 1);
    
    for (msgCount = 0, pTmpMessageList = &messageList;
         NULL != pTmpMessageList; 
         ++msgCount, pTmpMessageList = pTmpMessageList->NextMessage ()) 
    {
        eventID         = pTmpMessageList->ID ();

        switch (pTmpMessageList->Type ())
        {
            case SAPDBErr_MessageList::Error:
                eventType = teo200_EventList::Error_eeo200;
                break;

            case SAPDBErr_MessageList::Warning:
                eventType = teo200_EventList::Warning_eeo200;
                break;

            case SAPDBErr_MessageList::Info:
            default:
                eventType = teo200_EventList::Info_eeo200;
                break;
        }

        memset (eventLabel, 0, MAX_EVENTLABEL_LEN_EO200 + 1);
        _tcsncpy (eventLabel, pTmpMessageList->Component (), MAX_EVENTLABEL_LEN_EO200);
        
        if (0 == msgCount)
        {
            eventList = teo200_EventList ("", 
                                          eventID, 
                                          eventType, 
                                          eventLabel, 
                                          pTmpMessageList->Message ());
        }
        else
        {
            eventList = teo200_EventList (eventList,
                                          "", 
                                          eventID, 
                                          eventType, 
                                          eventLabel, 
                                          pTmpMessageList->Message ());
        }
    }

    return;
}

/*---------------------------------------------------------------------------*/
#if !defined (_WIN32)

SAPDB_Char const *  RTE_ConsoleUNIXError
(
    int const     err
)
{
    SAPDB_Char *    errMsg;
    errMsg = strerror(err);
    if ( !errMsg )
    {
        return "Unknown error";
    }
    else
    {
        return errMsg;
    }
}

#endif