/*!**************************************************************************

    module      : Log_ActionUnloadFile.cpp
    -------------------------------------------------------------------------

    responsible : UweH

    special area: Logging
    description : defines a class to handle load begin

    last changed: 2002-08-09

    -------------------------------------------------------------------------

    copyright:    (c) 2000-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

/*===========================================================================*
*  INCLUDES                                                                  *
*============================================================================*/

#include "Logging/Log_ActionUnloadFile.hpp"
#include "Logging/Log_ActionFileHandling.hpp"
#include "ggg00.h"
#include "hbd01.h"

/*===========================================================================*
*  FUNCTIONS                                                                 *
*============================================================================*/

//---------------------------------------------------------------------------

void Log_ActionUnloadFile::ExecuteAction
            ( tgg00_TransContext &TransContext,
              tgg00_FileId       *pCommandFileId,
              tgg00_FileId       *pCommandAuxFileId) const
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionUnloadFile::ExecuteAction", LogAction_Trace, 5);
    
    if ( TransContext.trError_gg00 != e_ok )
        return; 
    
    tgg00_FileId  RedoFileId;
    tgg00_FileId *pExecuteFileId; 
    tgg00_FileId  RedoAuxFileId;
    tgg00_FileId *pExecuteAuxFileId; 

    pExecuteFileId    = Log_GetFileId (m_head.filename, RedoFileId, pCommandFileId);
    pExecuteAuxFileId = Log_GetFileId (m_head.auxfilename, RedoAuxFileId, pCommandAuxFileId);

    if ( tfnNil_egg00 == m_head.auxfilename[0] )
    {
        // undo of reload
        b01unload_file (TransContext, *pExecuteFileId);
        if ( e_file_not_found == TransContext.trError_gg00
             ||
             e_file_unloaded == TransContext.trError_gg00 )
        {
            TransContext.trError_gg00 = e_ok;
        }
    }
    else
    {
        // redo of unload
        b01fn_new_and_unload (TransContext, *pExecuteAuxFileId, *pExecuteFileId);
        if ( e_file_not_found == TransContext.trError_gg00
             ||
             e_file_unloaded == TransContext.trError_gg00
             ||
             e_duplicate_filename == TransContext.trError_gg00 )
        {
            TransContext.trError_gg00 = e_ok;
        }
    }
}

/*===========================================================================*
*  END OF CODE                                                               *
*============================================================================*/
