/*!
  @file           Log_ActionReloadFile.hpp
  @author         UweH
  @ingroup        Logging
  @brief          

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/



#ifndef LOG_ACTION_RELOAD_FILE_H
#define LOG_ACTION_RELOAD_FILE_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/SAPDB_Types.hpp"
#include "Logging/Log_Types.hpp"
#include "Logging/Log_ReadWriteActionImage.hpp"

#include "ggg00.h"

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

//===================================================================================
/*!
   @brief          defines a class to handle the after image of create file
   @copydoc        Log_ReadWriteActionImage
 */

class Log_ActionReloadFile : public Log_ReadWriteActionImage
{

private:
    
    /// header of this action
    struct Head
    {
        tgg00_Filename filename;      ///< the filename to be reloaded 

        /// constructor (empty filename)
        Head()
        {
            memset (filename, 0, sizeof(filename));
        }
        
        /// constructor (with given filename)
        Head( const tgg00_Filename &newfilename )
        {
            filename = newfilename;
        }
    };
    
    /// in memory representation of this action
    Head m_head;

public:
    
    /// This is used for reading persistent images.
    Log_ActionReloadFile()
    : Log_ReadWriteActionImage (Log_ReloadFile)
    {}
    
    /// This is used for begin table load
    Log_ActionReloadFile( const tgg00_Filename &filename )
    : Log_ReadWriteActionImage (Log_ReloadFile),
      m_head (filename)
    {}

    /// called command
    void ExecuteAction (tgg00_TransContext &TransContext,
                        tgg00_FileId       *pCommandFileId = NULL) const;

    virtual void Execute (tgg00_TransContext &TransContext) const
    {
        ExecuteAction (TransContext);
    }

    virtual SAPDB_UInt GetPersistentLength () const
    {
        return Log_AlignedImageLen(sizeof(m_head));
    }

    /// copy the image from the reader to the in-memory-representation
    void ReadImagePersistent (Log_ActionImageReader &reader,
                              bool                  &isOk)
    {
        reader.CopyImage( reinterpret_cast<SAPDB_Byte*>(&m_head),
                          sizeof(m_head),
                          isOk );
    }

    /// write the object to the writer (i.e. make it persistent)
    void WriteImagePersistent (Log_ActionImageWriter &writer,
                               bool                  &isOk) const
    {
        writer.PersistentWrite (&m_head, sizeof (m_head), isOk);
    }
    
};


/*==========================================================================*
*  DEFINITION OF INLINE METHODS                                             *
*==========================================================================*/

#endif  /* LOG_ACTION_RELOAD_FILE_H */
