/*!
  @file           IFRConversion_DateConverter.cpp
  @author         D039759
  @ingroup        IFR_DataConv
  @brief          Conversion from/to Date values
  @see

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/
#include "Interfaces/Runtime/IFR_Common.h"
#include "Interfaces/Runtime/IFR_ErrorCode.h"
#include "Interfaces/Runtime/Conversion/IFRConversion_DateUCS2Converter.h"

#define DBUG_CLINK_METHOD_ENTER(x,y) DBUG_CONTEXT_METHOD_ENTER(x, y, &clink)

//----------------------------------------------------------------------
IFRConversion_DateUCS2Converter::IFRConversion_DateUCS2Converter(IFR_ShortInfo& shortinfo,
                                                                 SAPDBMem_IRawAllocator& allocator,
                                                                 IFR_Connection& connection)
:IFRConversion_UCS2CharDataConverter(shortinfo, allocator, false, false)
{
    m_flags.binary_as_encoded = connection.translateBinaryAsEncoded() ? 1 : 0;
}

//----------------------------------------------------------------------
IFRConversion_DateUCS2Converter::~IFRConversion_DateUCS2Converter()
{}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_DateUCS2Converter::appendBinaryInput(IFRPacket_DataPart& datapart,
                                                    char               *data,
                                                    IFR_Length            datalength,
                                                    IFR_Length*           lengthindicator,
                                                    IFR_ConnectionItem & clink,
                                                    IFR_Length         &offset,
                                                    IFRConversion_Putval *putval)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, appendBinaryInput);
    if(m_flags.binary_as_encoded) {
        DBUG_RETURN(IFRConversion_UCS2CharDataConverter::appendBinaryInput(datapart, data, datalength, lengthindicator, clink, offset, putval));
    } else {
        clink.error().setRuntimeError(IFR_ERR_BINARY_TO_ENCODED_UNSUPPORTED_I, (IFR_Int4)getIndex());
        DBUG_RETURN(IFR_NOT_OK);
    }
}

//----------------------------------------------------------------------
IFR_Retcode 
IFRConversion_DateUCS2Converter::appendBinaryOutput(IFRPacket_DataPart&   datapart,
                                                char                 *data,
                                                IFR_Length            datalength,
                                                IFR_Length*           lengthindicator,
                                                IFR_ConnectionItem   &clink,
                                                IFR_Length&           dataoffset,
                                                IFR_Length&           offset,
                                                IFRConversion_Getval *getval)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, appendBinaryOutput);
    if(m_flags.binary_as_encoded) {
        DBUG_RETURN(IFRConversion_UCS2CharDataConverter::appendBinaryOutput(datapart, 
                                                                            data,
                                                                            datalength,
                                                                            lengthindicator,
                                                                            clink,
                                                                            dataoffset,
                                                                            offset,
                                                                            getval));
    } else {
        clink.error().setRuntimeError(IFR_ERR_BINARY_TO_ENCODED_UNSUPPORTED_I, (IFR_Int4)getIndex());
        DBUG_RETURN(IFR_NOT_OK);
    }
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_DateUCS2Converter::translateInput(IFRPacket_DataPart& part,
                                            SQL_TIME_STRUCT& data,
                                            IFR_Length *lengthindicator,
                                            IFR_ConnectionItem& clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, translateInput);
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex());
    DBUG_RETURN(IFR_NOT_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_DateUCS2Converter::translateInput(IFRPacket_DataPart& part,
                                            SQL_TIMESTAMP_STRUCT& data,
                                            IFR_Length *lengthindicator,
                                            IFR_ConnectionItem& clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, translateInput);
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex());
    DBUG_RETURN(IFR_NOT_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_DateUCS2Converter::translateOutput(IFRPacket_DataPart& part,
                                             SQL_TIME_STRUCT& data,
                                             IFR_Length *lengthindicator,
                                             IFR_ConnectionItem& clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, translateInput);
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex());
    DBUG_RETURN(IFR_NOT_OK);
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_DateUCS2Converter::translateOutput(IFRPacket_DataPart& part,
                                             SQL_TIMESTAMP_STRUCT& data,
                                             IFR_Length *lengthindicator,
                                             IFR_ConnectionItem& clink)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_DateUCS2Converter, translateInput);
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex());
    DBUG_RETURN(IFR_NOT_OK);
}

#define TRANSLATE_METHOD_IMPL(xxtype)                                   \
IFR_Retcode                                                             \
IFRConversion_DateUCS2Converter::translateInput(IFRPacket_DataPart& part, \
                                            xxtype& data,               \
                                            IFR_Length *lengthindicator, \
                                            IFR_ConnectionItem& clink)  \
{                                                                       \
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex()); \
    return IFR_NOT_OK;                                                  \
}                                                                       \
IFR_Retcode                                                             \
IFRConversion_DateUCS2Converter::translateOutput(IFRPacket_DataPart& part, \
                                            xxtype& data,               \
                                            IFR_Length *lengthindicator, \
                                            IFR_ConnectionItem& clink)  \
{                                                                       \
    clink.error().setRuntimeError(IFR_ERR_CONVERSION_NOT_SUPPORTED_I, (IFR_Int4)getIndex()); \
    return IFR_NOT_OK;                                                  \
}

TRANSLATE_METHOD_IMPL(IFR_Int1)
TRANSLATE_METHOD_IMPL(IFR_Int2)
TRANSLATE_METHOD_IMPL(IFR_Int4)
TRANSLATE_METHOD_IMPL(IFR_Int8)
TRANSLATE_METHOD_IMPL(IFR_UInt1)
TRANSLATE_METHOD_IMPL(IFR_UInt2)
TRANSLATE_METHOD_IMPL(IFR_UInt4)
TRANSLATE_METHOD_IMPL(IFR_UInt8)
TRANSLATE_METHOD_IMPL(double)
TRANSLATE_METHOD_IMPL(float)
TRANSLATE_METHOD_IMPL(SQL_NUMERIC_STRUCT)
TRANSLATE_METHOD_IMPL(GUID)

