/****************************************************************************

  module      : Data_Wrapper.cpp

  -------------------------------------------------------------------------

  responsible : TorstenS

  special area: Data_Wrapper
  description : 


  last changed: 2001-02-06  12:36
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 2001-2004 SAP AG

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"

#include "DataAccess/Data_PrimTreeStatistic.hpp"
#include "KernelCommon/Kernel_TableStatistic.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/


/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

externC
void bd999CalculateColumnStatistic(
    tgg00_TransContext          &trans,
    tbd_current_tree            &current,
    tbd_current_tree            &tempCurrent,
    tsp00_Int2                  columnCount,
    tsp00_Int2                  columnFirstPosition,
    tsp00_Int2                  columnLastPosition,
    tgg00_StEntryAddr           pColumnDescription,
    tsp00_Int4                  &numberOfLeaves,
    tsp00_Int4                  &numberOfRecords,
    tgg00_ColumnDistinctValues  &distinctValues )
{
    Data_PageCount  auxLeaves;
    Data_PageCount  auxRecords;

    Data_PrimTreeStatistic  primTreeStatistic( current );

    primTreeStatistic.CalculateColumnStatistic( tempCurrent,
            columnCount, columnFirstPosition, columnLastPosition,
            pColumnDescription, auxLeaves, auxRecords,
            distinctValues );

    numberOfLeaves = auxLeaves;
    numberOfRecords = auxRecords;
};

/*---------------------------------------------------------------------------*/

externC
void bd999SampleColumnStatistic(
    tgg00_TransContext          &trans,
    tbd_current_tree            &current,
    tbd_current_tree            &tempCurrent,
    tsp00_Int4                  numberOfSampleLeaves,
    tsp00_Int4                  maxNumberOfLeaves,
    tsp00_Int2                  columnCount,
    tsp00_Int2                  columnFirstPosition,
    tsp00_Int2                  columnLastPosition,
    tgg00_StEntryAddr           pColumnDescription,
    tsp00_Int4                  &numberOfLeaves,
    tsp00_Int4                  &numberOfRecords,
    tgg00_ColumnDistinctValues  &distinctValues )
{
    Data_PageCount  auxLeaves;
    Data_PageCount  auxRecords;

    const SAPDB_UInt stepWidth = numberOfSampleLeaves / maxNumberOfLeaves;

    Data_PrimTreeStatistic  primTreeStatistic( current );

    primTreeStatistic.SampleColumnStatistic( tempCurrent, stepWidth,
            columnCount, columnFirstPosition, columnLastPosition,
            pColumnDescription, auxLeaves, auxRecords,
            distinctValues );

    numberOfLeaves = auxLeaves;
    numberOfRecords = auxRecords;
};

/*---------------------------------------------------------------------------*/

externC
void bd999SampleNewColumnStatistic(
    tgg00_TransContext          &trans,
    tbd_current_tree            &current,
    tbd_current_tree            &tempCurrent,
    tsp00_Int4                  numberOfSampleLeaves,
    tsp00_Int2                  columnCount,
    tsp00_Int2                  columnFirstPosition,
    tsp00_Int2                  columnLastPosition,
    tgg00_StEntryAddr           pColumnDescription,
    tsp00_Int4                  &numberOfLeaves,
    tsp00_Int4                  &numberOfRecords,
    tgg00_ColumnDistinctValues  &distinctValues )
{
    Data_PageCount  auxLeaves;
    Data_PageCount  auxRecords;

    Data_PrimTreeStatistic  primTreeStatistic( current );

    primTreeStatistic.SampleNewColumnStatistic( tempCurrent, numberOfSampleLeaves,
            columnCount, columnFirstPosition, columnLastPosition,
            pColumnDescription, auxLeaves, auxRecords,
            distinctValues );

    numberOfLeaves = auxLeaves;
    numberOfRecords = auxRecords;
};


/*---------------------------------------------------------------------------*/

externC
void bd999CalculateRecordsAndLeaves(
    tgg00_TransContext  &trans,
    tbd_current_tree    &current,
    tsp00_Int4          &numberOfLeaves,
    tsp00_Int4          &numberOfRecords )
{
    Data_PageCount  auxLeaves;
    Data_PageCount  auxRecords;

    Data_PrimTreeStatistic  primTreeStatistic( current );

    primTreeStatistic.CalculateRecordsAndLeaves( auxLeaves, auxRecords );

    numberOfLeaves  = auxLeaves;
    numberOfRecords = auxRecords;
};


/*---------------------------------------------------------------------------*/

externC
void bd999SampleRecordsAndLeaves(
    tgg00_TransContext  &trans,
    tbd_current_tree    &current,
    tsp00_Int4          numberOfSampleLeaves,
    tsp00_Int4          &numberOfLeaves,
    tsp00_Int4          &numberOfRecords )
{
    Data_PageCount  auxLeaves;
    Data_PageCount  auxRecords;

    Data_PrimTreeStatistic  primTreeStatistic( current );

    primTreeStatistic.SampleRecordsAndLeaves(
        numberOfSampleLeaves, auxLeaves, auxRecords );

    numberOfLeaves  = auxLeaves;
    numberOfRecords = auxRecords;
};

/*---------------------------------------------------------------------------*/

externC
void bd999CalculateTableStatistic(
    tgg00_TransContext  &trans,
    tbd_current_tree    &current,
    tbd_current_tree    &shortCurrent,
    tsp00_Bool          bShortColumnFileExist,
    tsp00_Int4          numberOfLongColumns,
    tgg00_TableStatInfo &statisticStruct )
{

    if( 0 < numberOfLongColumns )
    {
        Kernel_TableStatistic   tableStatistic( statisticStruct );
        Data_PrimTreeStatistic  primTreeStatistic( current );

        if( bShortColumnFileExist )
        {
            tgg00_TableStatInfo     shortStruct;
            Kernel_TableStatistic   shortStatistic( shortStruct );
            Data_PrimTreeStatistic  shortTreeStatistic( shortCurrent );

            shortTreeStatistic.CalculateTableStatistic( 0, shortStatistic );

            if( e_ok != trans.trError_gg00 )
                return;

            tableStatistic.IntegrateShortColumnStatistic( shortStatistic );
        }

        primTreeStatistic.CalculateTableStatistic( numberOfLongColumns, tableStatistic );
    }
    else
    {
        Data_PrimTreeStatistic  primTreeStatistic( current );
        Kernel_TableStatistic   tableStatistic( statisticStruct );

        primTreeStatistic.CalculateTableStatistic( numberOfLongColumns, tableStatistic );
    }
};

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
