/*!
  @file     Data_IndexScanTreeAccess.hpp
  @author   TorstenS
  @ingroup  DataAccess
  @brief    Primary tree iterator
  @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/


#ifndef DATA_INDEX_SCAN_TREE_ACCESS_HPP
#define DATA_INDEX_SCAN_TREE_ACCESS_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "gbd00.h"

#include "DataAccess/Data_Types.hpp"
#include "DataAccess/Data_PageAccessManager.hpp"
#include "DataAccess/Data_PrimPage.hpp"
#include "KernelCommon/Kernel_Common.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/



/*!*****************************************************************************

   class: Data_IndexScanTreeAccess

   description: This class is used to 
   
              
*******************************************************************************/

class Data_IndexScanTreeAccess
{
public:

    /* -----------------------------------------------------------------------*/
    /*! chapter: Constructors and initialization                              */
    /* -----------------------------------------------------------------------*/

    /*!
        @brief  Constructs an iterator to a primary tree which provides the
                leaves.
        @param  current [in|out] identifier for the file to be handled
        @param  stepWidth [in] step width for the leaves to be used
    */

    Data_IndexScanTreeAccess(
        tbd_current_tree    &current,
        const SAPDB_UInt    stepWidth );

    /*!
        @brief  The destructor resumes the consumed resources, specifically
                the requested pages and locks.
    */

    ~Data_IndexScanTreeAccess();

    /* -----------------------------------------------------------------------*/
    /*! endchapter: constructors and initialization                           */
    /* -----------------------------------------------------------------------*/

    /* -----------------------------------------------------------------------*/
    /*! chapter: Leaf Node Access                                             */
    /* -----------------------------------------------------------------------*/

    /*!
        @brief  Returns a leaf page which is 'stepWidth' pages away from the
                last returned leaf page. It's guaranteed that no leaf is returned
                twice.
        @return Data_PrimPage&
    */          

    Data_PrimPage& GetLeafNode();

    /*!
        @brief  Returns the estimated number of leaf nodes.
        @return leaf node count
    */          

    SAPDB_Real8 GetNumberOfEstimatedLeafNodes() const;

    /* -----------------------------------------------------------------------*/
    /*! endchapter:  Leaf Node Access                                         */
    /* -----------------------------------------------------------------------*/

private:

    // Copy and assignment operator are not supported

    Data_IndexScanTreeAccess& operator=( const Data_IndexScanTreeAccess &ista );

    Data_IndexScanTreeAccess( const Data_IndexScanTreeAccess &ista );

protected:

    SAPDB_Bool GetLeftMostLeafNode();

    SAPDB_Bool GetNextLeafNode();

protected:

    // old known current
    tbd_current_tree    &m_Current;

    // base error
    tgg00_BasisError    &m_TrError;

    // Manager for the page access
    Data_PageAccessManager  m_PageAccessManager;

    // stepWidth used to go from one leaf to another
    const SAPDB_UInt  m_StepWidth;

    // record index on current index level one page
    SAPDB_UInt  m_CurrRecIndex;

    // current number of leaves
    SAPDB_UInt m_CurrNumberOfLeaves;

    // current index level one page
    Data_PrimPage   m_IndexPage;

    // current leaf page
    Data_PrimPage   m_LeafPage;
};

/*!*****************************************************************************

   endclass: Data_IndexScanTreeAccess

*******************************************************************************/

#endif  /* DATA_INDEX_SCAN_TREE_ACCESS_HPP */

