/*!
    \file    DBMSrvKnlSrv_ConnectInfo.hpp
    \author  TiloH
    \ingroup access to service db
    \brief   a class holding information about the service db connction

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

*/

#ifndef DBMSRVKNLSRV_CONNECTINFO_HPP
#define DBMSRVKNLSRV_CONNECTINFO_HPP

#include "gcn00.h"
/*! \brief class for storing cennection info of the service db */
class DBMSrvKnlSrv_ConnectInfo
{
  public:
    /*! constructor */
    DBMSrvKnlSrv_ConnectInfo(
        const tsp00_DbNamec   & dbName,
        const tcn00_UserNamec & userName,
        const tsp00_Namec     & userPassword);

    /*! \brief get function for dbname
        \return name of the service db as constant zero terminated string */
    const char * getDBName();

    /*! \brief get function for user name
        \return user name stored in the object as constant zero terminated string */
    const char * getUserName();

    /*! \brief get function for user name
        \return user password stored in the object as constant zero terminated string */
    const char * getUserPassword();

  private:
    tsp00_DbNamec   m_DBName;
    tcn00_UserNamec m_UserName;
    tsp00_Namec     m_UserPassword;
};

#endif
