/*!
  \file    DBMSrvCmd_DbmExecuteServerProcess.cpp
  \author  MarcW
  \ingroup DBMServer commands
  \brief   command dbm_execute_serverprocess

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#include "hni33.h"

#include "DBM/Srv/Commands/DBMSrvCmd_DbmExecuteServerprocess.hpp"
#include "ToolsCommon/Tools_PipeCall.hpp"

#ifdef _WIN32 
  #define DEVICE_NULL  "nul"
#else
  #define DEVICE_NULL  "/dev/null"
#endif


DBMSrvCmd_DbmExecuteServerprocess::DBMSrvCmd_DbmExecuteServerprocess()
    : DBMSrv_Command( DBMSrv_Command::KeyDbmExecuteServerprocess, false ) {
} // end DBMSrvCmd_DbmExecuteServerprocess::DBMSrvCmd_DbmExecuteServerprocess

//-----------------------------------------------------------------------------
// public static member function DBMSrvCmd_DbmExecuteServerprocess::runCommand
//-----------------------------------------------------------------------------
tcn00_Error DBMSrvCmd_DbmExecuteServerprocess::runCommand
    ( VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax)
{
  DBMSrv_Reply oReply(replyData, replyLen, replyLenMax);
  DBMSrvCmd_DbmExecuteServerprocess oCommand;

  return oCommand.run(vcontrol, command, oReply);
} // end DBMSrvCmd_DbmExecuteServerprocess::run

tcn00_Error DBMSrvCmd_DbmExecuteServerprocess::run(
    VControlDataT* vcontrol,
    CommandT* command,
    DBMSrv_Reply& theReply) {
    
    theReply.startWithOK();

    SAPDBErr_MessageList executionMessages;
    executionMessages.ClearMessageList();

    runInProcess(command->args, executionMessages);

    if( executionMessages.IsEmpty() )
        return OK_CN00;
    else {
        return theReply.startWithMessageList(executionMessages);
    }
} // end DBMSrvCmd_DbmExecuteServerprocess::run

void DBMSrvCmd_DbmExecuteServerprocess::runInProcess(const char* aCommandLine,
        SAPDBErr_MessageList& aMessageList) {

    // commandline converter
    DBMSrvProc_ServerProcessCommandLineConverter theConverter(aCommandLine);
    if( !theConverter.isValid() ) {
        // fill some error into message list
        SAPDBErr_MessageList noProcessRunning(
            DBMSrv_DBMError(INSERVERPROCESSSTARTER), 1, aCommandLine);
        aMessageList = aMessageList + noProcessRunning;
        return;
    }

    bool errorFound(false);
    if( theConverter.isPipeCall() ) {
      errorFound = ( 0 != Tools_PipeCall::CallProgram(
                              theConverter.getConvertedCommandLineReference(),
                              Tools_PipeCall::CallAsynchron,
                              DEVICE_NULL,
                              DEVICE_NULL) );
    }
    else {
        SAPDBErr_MessageList noProcessRunning(
            DBMSrv_DBMError(NOTIMPL), 1, theConverter.getConvertedCommandLineReference());
        aMessageList = aMessageList + noProcessRunning;
    }
    if( errorFound ) {
        SAPDBErr_MessageList noProcessRunning(
            DBMSrv_DBMError(INSERVERPROCESSSTARTER), 1, theConverter.getConvertedCommandLineReference());
        aMessageList = aMessageList + noProcessRunning;
    }
} // end DBMSrvCmd_DbmExecuteServerprocess::runInProcess
