/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionItem;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.MemoryResultSetSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.UpdatableResultSetSapDB;
import com.sap.dbtech.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.InvalidArgumentValue;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class StatementSapDB
extends ConnectionItem
implements Statement {
    protected ResultSet currentResultSet;
    protected int rowsAffected = -1;
    protected String cursorName;
    protected String defaultCursorName;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 1;
    protected int fetchDirection = 1000;
    protected int fetchSize;
    protected Vector batchItems;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int queryTimeout = 0;
    protected boolean setWithInfo = false;
    protected boolean hasRowCount = false;
    protected boolean canceled = false;
    protected boolean packetEncodingUnicode = false;
    protected int cursorUsage;
    static final int Cursor_not_used = 0;
    static final int Cursor_in_use = 1;
    static final int Cursor_show = 2;
    static final int Cursor_memory_resultset = 3;
    static final int Cursor_Resurrected = 4;
    static final int Cursor_forward_only = 5;
    protected int statementType;
    static final int Statement_User = 0;
    static final int Statement_Internal = 1;
    static final int Statement_UpdatableResultSet = 2;
    protected static final int defaultConcurrency_C = 1007;
    protected static final int defaultHoldability_C = 1;
    public static final int BATCH_SUCCESS_NO_INFO_C = -2;
    public static final int BATCH_EXECUTE_FAILED_C = -3;

    StatementSapDB(ConnectionSapDB connectionSapDB) throws SQLException {
        this(connectionSapDB, 1003, 1007, connectionSapDB.getHoldability());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSapDB(ConnectionSapDB connectionSapDB, int n, int n2, int n3) throws SQLException {
        super(connectionSapDB);
        this.defaultCursorName = this.cursorName = connectionSapDB.nextCursorName();
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
            }
        }
        switch (n2) {
            case 1007: {
                break;
            }
            case 1008: {
                if (n != 1003) break;
                n = 1005;
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetConcurrency", "CONCUR_READ_ONLY, CONCUR_UPDATABLE");
            }
        }
        switch (n3) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT");
            }
        }
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.statementType = 0;
        if (this.resultSetHoldability == 2) {
            ArrayList arrayList = connectionSapDB.statementContainer;
            synchronized (arrayList) {
                connectionSapDB.statementContainer.add(new WeakReference<StatementSapDB>(this));
            }
        }
    }

    public void addBatch(String string) throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(string);
    }

    public void cancel() throws SQLException {
        this.assertOpen();
        this.canceled = true;
        if (this.currentResultSet != null) {
            ((ResultSetSapDB)this.currentResultSet).cancel();
        }
        this.connection.cancel(this);
    }

    public void clearBatch() throws SQLException {
        this.batchItems = null;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.closeResultSet(false);
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet(boolean bl) throws SQLException {
        ConnectionSapDB connectionSapDB = this.connection;
        synchronized (connectionSapDB) {
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
            }
            if (this.cursorUsage == 2) {
                this.cursorName = this.defaultCursorName;
            }
            if (bl) {
                this.cursorUsage = this.connection.restoreCursor(this.cursorName) ? 4 : 0;
                this.currentResultSet = null;
            } else {
                this.cursorUsage = 0;
                this.currentResultSet = null;
            }
        }
    }

    public boolean execute(String string) throws SQLException {
        boolean bl = false;
        this.setWithInfo = true;
        return this.execute(string, bl, this.resultSetType, this.resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(String string, boolean bl, int n, int n2) throws SQLException {
        try {
            boolean bl2;
            this.canceled = false;
            this.clearWarnings();
            this.assertOpen();
            boolean bl3 = this.connection.isInTransaction();
            if (string == null) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.null"), "42000");
            }
            try {
                this.closeResultSet(true);
                if (this.connection.dbsCache != null) {
                    this.connection.dbsCache.use(string);
                }
                ReplyPacket replyPacket = this.sendSQL(string, n, n2, false);
                bl2 = this.parseResult(replyPacket, string, null, null);
            }
            catch (TimeoutException timeoutException) {
                if (bl3) {
                    throw timeoutException;
                }
                bl2 = this.execute(string, bl, n, n2);
            }
            boolean bl4 = bl2;
            return bl4;
        }
        finally {
            this.canceled = false;
        }
    }

    protected String getUpdTablename(String string) throws SQLException {
        String string2 = null;
        byte[] byArray = null;
        RequestPacket requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
        requestPacket.initParseCommand(string + " FOR UPDATE OF ", true, false);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 1);
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            switch (partEnumeration.partKind()) {
                case 10: {
                    int n = replyPacket.getPartDataPos();
                    byArray = replyPacket.getBytes(n, 12);
                    break;
                }
                case 19: {
                    string2 = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                }
            }
        }
        this.connection.dropParseid(byArray);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.batchItems == null) {
            return new int[0];
        }
        this.setWithInfo = false;
        boolean bl = this.connection.isInTransaction();
        int n = this.batchItems.size();
        int[] nArray = new int[n];
        Vector vector = this.batchItems;
        this.batchItems = null;
        try {
            Object object;
            this.canceled = false;
            int n2 = 0;
            int n3 = 0;
            this.packetEncodingUnicode = false;
            while (n2 < n) {
                object = this.connection.getRequestPacket(this.packetEncodingUnicode);
                try {
                    ((RequestPacket)object).initDbsCommand(this.connection.autocommit, (String)vector.elementAt(n2), 1003);
                }
                catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                    this.connection.freeRequestPacket((RequestPacket)object);
                    object = this.connection.getRequestPacket(true);
                    this.packetEncodingUnicode = true;
                    ((RequestPacket)object).initDbsCommand(this.connection.autocommit, (String)vector.elementAt(n2), 1003);
                }
                ((RequestPacket)object).setMaxSegment((short)Short.MAX_VALUE);
                ++n2;
                try {
                    while (n2 < n && ((RequestPacket)object).initDbsCommand((String)vector.elementAt(n2), false, this.connection.autocommit, 1003)) {
                        ++n2;
                    }
                }
                catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                    ((RequestPacket)object).dropSegment();
                    this.packetEncodingUnicode = true;
                }
                ReplyPacket replyPacket = this.connection.execute((RequestPacket)object, true, false, this, 2);
                while (n3 < n2) {
                    if (replyPacket.weakReturnCode() != 0) {
                        int[] nArray2 = new int[n3];
                        System.arraycopy(nArray, 0, nArray2, 0, n3);
                        throw new BatchUpdateExceptionSapDB(nArray2, replyPacket.createException());
                    }
                    int n4 = replyPacket.functionCode();
                    if (n4 == 4 || n4 == 216 || n4 == 27) {
                        int[] nArray3 = new int[n3];
                        System.arraycopy(nArray, 0, nArray3, 0, n3);
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", Integer.toString(n3 + 1)), "2A000", nArray3);
                    }
                    nArray[n3] = replyPacket.resultCount(false);
                    if (nArray[n3] == -1) {
                        nArray[n3] = -2;
                    }
                    replyPacket.nextSegment();
                    ++n3;
                }
            }
            object = nArray;
            return object;
        }
        catch (TimeoutException timeoutException) {
            if (bl) {
                throw timeoutException;
            }
            this.batchItems = vector;
            int[] nArray4 = this.executeBatch();
            return nArray4;
        }
        finally {
            this.canceled = false;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (!this.cmdIsQuery(string)) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.rowcount"));
        }
        this.setWithInfo = true;
        this.execute(string, true, this.resultSetType, this.resultSetConcurrency);
        return this.currentResultSet;
    }

    public ResultSetSapDB executeQuerySap(String string) throws SQLException {
        return (ResultSetSapDB)this.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        this.setWithInfo = false;
        boolean bl = this.execute(string, false, 1003, 1007);
        if (bl) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.resultset"));
        }
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        this.assertOpen();
        this.rowsAffected = -1;
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        this.assertOpen();
        return this.currentResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        this.assertOpen();
        return this.rowsAffected;
    }

    protected boolean isQuerySQL(String string) {
        String string2 = string.substring(0, Math.min(30, string.length())).trim().toLowerCase();
        return string2.startsWith("select");
    }

    protected boolean parseResult(ReplyPacket replyPacket, String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        int n;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.rowsAffected = -1;
        this.hasRowCount = false;
        int n2 = replyPacket.functionCode();
        if (n2 == 4 || n2 == 216 || n2 == 248 || n2 == 27) {
            bl = true;
        }
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        block17: while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            n = partEnumeration.partKind();
            switch (n) {
                case 2: {
                    if (stringArray != null) continue block17;
                    stringArray = replyPacket.parseColumnNames();
                    continue block17;
                }
                case 14: {
                    if (dBTechTranslatorArray != null) continue block17;
                    dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, false);
                    continue block17;
                }
                case 32: {
                    if (dBTechTranslatorArray != null) continue block17;
                    dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, true);
                    continue block17;
                }
                case 12: {
                    if (bl) continue block17;
                    this.rowsAffected = replyPacket.resultCount(true);
                    this.hasRowCount = true;
                    continue block17;
                }
                case 13: {
                    String string3 = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                    if (string3.length() <= 0) continue block17;
                    this.cursorName = string3;
                    continue block17;
                }
                case 5: {
                    bl3 = true;
                    continue block17;
                }
                case 6: {
                    if (replyPacket.returnCode() != 100) continue block17;
                    this.rowsAffected = -1;
                    bl2 = true;
                    if (bl) continue block17;
                    this.rowsAffected = 0;
                    continue block17;
                }
                case 19: {
                    string2 = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                    continue block17;
                }
                case 11: {
                    continue block17;
                }
            }
        }
        if (bl) {
            if (n2 == 27 && this.cursorName.equals("SHOW")) {
                this.cursorUsage = 2;
            } else {
                int n3 = this.cursorUsage = this.resultSetType == 1003 && this.connection.isKernelFeaturesupported(5) && n2 != 248 ? 5 : 1;
            }
            if (replyPacket.nextSegment() != -1 && replyPacket.functionCode() == 224) {
                n = 1;
                partEnumeration = replyPacket.partEnumeration();
                block18: while (partEnumeration.hasMoreElements()) {
                    partEnumeration.nextElement();
                    int n4 = partEnumeration.partKind();
                    switch (n4) {
                        case 2: {
                            if (stringArray != null) continue block18;
                            stringArray = replyPacket.parseColumnNames();
                            continue block18;
                        }
                        case 14: {
                            if (dBTechTranslatorArray != null) continue block18;
                            dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, false);
                            continue block18;
                        }
                        case 32: {
                            if (dBTechTranslatorArray != null) continue block18;
                            dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, true);
                            continue block18;
                        }
                        case 6: {
                            n = 0;
                            continue block18;
                        }
                    }
                }
                if (n != 0) {
                    this.updateFetchInfo(dBTechTranslatorArray, stringArray);
                }
            }
            if (bl3) {
                this.createResultSet(string, string2, this.cursorName, dBTechTranslatorArray, stringArray, bl2, replyPacket);
            } else {
                this.createResultSet(string, string2, this.cursorName, dBTechTranslatorArray, stringArray, bl2, null);
            }
        } else if (this.cursorUsage == 4) {
            this.connection.dropCursor(this.cursorName);
            this.cursorUsage = 0;
        }
        return bl;
    }

    protected void createResultSet(String string, String string2, String string3, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray, boolean bl, ReplyPacket replyPacket) throws SQLException {
        try {
            FetchInfo fetchInfo = this.getFetchInfo(string3, dBTechTranslatorArray, stringArray);
            if (this.resultSetConcurrency == 1008) {
                if (string2 == null) {
                    string2 = this.getUpdTablename(string);
                }
                this.currentResultSet = new UpdatableResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, string2, this.cursorUsage, replyPacket);
            } else {
                this.currentResultSet = new ResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, this.cursorUsage, replyPacket);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -4000) {
                this.currentResultSet = new MemoryResultSetSapDB(new String[]{"ROW NOT FOUND"}, new Object[0][]);
                this.cursorUsage = 3;
            }
            throw sQLException;
        }
        if (this.fetchDirection == 1001) {
            this.currentResultSet.setFetchDirection(this.fetchDirection);
        }
        if (bl && this.currentResultSet instanceof ResultSetSapDB) {
            ((ResultSetSapDB)this.currentResultSet).setEmpty(true);
        }
    }

    protected FetchInfo getFetchInfo(String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        FetchInfo fetchInfo = new FetchInfo(this.connection, string, dBTechTranslatorArray, stringArray, this.packetEncodingUnicode);
        return fetchInfo;
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String string, int n, boolean bl) throws SQLException {
        requestPacket.initDbsCommand(this.connection.autocommit, string, this.resultSetType);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        requestPacket.addCursorPart(this.cursorName);
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, n);
        return replyPacket;
    }

    protected ReplyPacket sendSQL(String string, int n, int n2, boolean bl) throws SQLException {
        ReplyPacket replyPacket;
        block11: {
            String string2 = string;
            boolean bl2 = false;
            if (n2 == 1008) {
                string2 = string2 + " FOR UPDATE OF ";
                bl2 = true;
            }
            if (n == 1004) {
                string2 = string2 + " FOR REUSE";
                bl2 = true;
            }
            try {
                if (bl2) {
                    RequestPacket requestPacket = this.connection.getRequestPacket(false);
                    this.packetEncodingUnicode = false;
                    try {
                        try {
                            replyPacket = this.sendCommand(requestPacket, string2, 1, bl);
                            this.packetEncodingUnicode = false;
                            break block11;
                        }
                        catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                            this.connection.freeRequestPacket(requestPacket);
                            requestPacket = this.connection.getRequestPacket(true);
                            this.packetEncodingUnicode = true;
                            replyPacket = this.sendCommand(requestPacket, string2, 1, bl);
                        }
                    }
                    catch (SQLException sQLException) {
                        requestPacket = this.connection.getRequestPacket(this.packetEncodingUnicode);
                        replyPacket = this.sendCommand(requestPacket, string, 1, bl);
                    }
                    break block11;
                }
                RequestPacket requestPacket = this.connection.getRequestPacket(false);
                try {
                    replyPacket = this.sendCommand(requestPacket, string, 1, bl);
                    this.packetEncodingUnicode = false;
                }
                catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                    this.connection.freeRequestPacket(requestPacket);
                    requestPacket = this.connection.getRequestPacket(true);
                    this.packetEncodingUnicode = true;
                    replyPacket = this.sendCommand(requestPacket, string, 1, bl);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.toolong"), "42000");
            }
        }
        return replyPacket;
    }

    public void setCursorName(String string) throws SQLException {
        this.assertOpen();
        if (string != null && string.length() > 0) {
            this.defaultCursorName = this.cursorName = string;
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.assertOpen();
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
            }
        }
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.fetchsize", Integer.toString(n)), "22003");
        }
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.maxfieldsize", Integer.toString(n)), "22003");
        }
        this.assertOpen();
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.maxrows", Integer.toString(n)), "22003");
        }
        this.assertOpen();
        this.maxRows = n > 0 ? n : Integer.MAX_VALUE;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.querytimeout", Integer.toString(n)), "22003");
        }
        this.assertOpen();
        this.queryTimeout = n;
    }

    private boolean cmdIsQuery(String string) {
        String[] stringArray = new String[]{"SELECT", "CALL", "DECLARE", "SHOW", "EXPLAIN"};
        int n = 0;
        if (string == null) {
            return false;
        }
        char c = string.charAt(n);
        while (c == '(' || Character.isWhitespace(c)) {
            c = string.charAt(++n);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.regionMatches(true, n, stringArray[i], 0, stringArray[i].length())) continue;
            return true;
        }
        return false;
    }

    protected void updateFetchInfo(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        return null;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 1) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray.length != 0) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 0) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.executeUpdate(string);
    }

    public boolean execute(String string, int n) throws SQLException {
        if (n == 1) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray.length != 0) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.execute(string);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 0) {
            this.throwNotSupported(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
        }
        return this.execute(string);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public boolean isPacketEncodingUnicode() {
        return this.packetEncodingUnicode;
    }
}

