#!/usr/bin/perl
# mfcinc        *** internal script (called by vmake !)
#
# @(#)mfcinc		1997-11-18
#
# module frame to c include file
#
# TOOL          directory for tools
# KEEPFLG       optional keep intermediate files flag
#
#
# includes currently unused but syntactically allowed
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

package mfcinc;
use Env;
use File::Copy;
use File::Basename;
use Carp;
use ToolLib;

do "$TOOLVARS";
if ( $@ ) { print "$@"; exit }
ToolTrace("mfcinc called with @ARGV\n");

$USAGE = "usage: mfcinc [-<symbol>=<value>] [-k] source [includes]\n";

do "$TOOL/bin/mf_opts$TOOLEXT";
if ( $@ ) { print "$@"; exit }

if ( @ARGV < 1 ) { print $USAGE; exit 1 }

$SOURCE = shift;
($BASE, $SOURCEPATH, $EXT) = fileparse($SOURCE, '\..*');
$EXT=".h" unless $EXT;
undef $EXT if ($NOEXTENSION == 1 );


my(@INCLUDES) = @ARGV;

@CONCOMOPTS;

if ( $unpack ne "no" )
{
	system("$TOOL/pgm/mfspl $SOURCE $NULL $NULL $BASE.cod") == 0
	   or croak "Error while executing \"$TOOL/pgm/mfspl $SOURCE $NULL $NULL $BASE.cod\"\n".
	   "message: $!\n";
}
else
{
    ToolLib::SrcCopy($SOURCE, "$BASE.cod") || die "Can't copy $SOURCE to $BASE.cod: $!\n" # CTS 1108093
}


if ( $concom eq "yes" )
{
    system("$TOOL/pgm/mfconcom", "-n", @CONCOMOPTS, "$BASE.cod", "$BASE$EXT", $MACH, $KIND, $TRACE, $COMP, $OS, $OSSPEC) == 0
        or croak "Error while executing \"$TOOL/pgm/mfconcom -n @CONCOMOPTS $BASE.cod $BASE$EXT $MACH $KIND $TRACE $COMP $OS $OSSPEC\"\n".
        "message: $!\n";
}
else
{
    unlink "$BASE$EXT";
    rename "$BASE.cod", "$BASE$EXT" ;
}

if ( $unpack eq "no" && $checkinc ne "no")
{
    ToolLib::CheckIncludes(\@INCLUDES, "$BASE$EXT", $LAYER);
}

if ($SETBUILDINFO)
{
	require Buildinfo;
	import Buildinfo;
	Buildinfo::setbuildinfo("$BASE$EXT");
}


if ($SCRIPT ne "")
{
	@ARGV = ("$BASE$EXT");
	do "$SCRIPT";
	if ( $@ ) { die "$@";   }
}

if ($COMPILECHECK)
{
	print "Start compile check of a header file ...\n";
	my $check_filename = "${BASE}${EXT}";
	$check_filename =~ tr/\./_/;
	$check_filename .= "_compile_check.c";
	open ( COMPFILE, ">$check_filename") or die "Can't create check file $check_filename \n";
	{
		print COMPFILE "#include \"${BASE}${EXT}\"\n";
	}
	close (COMPFILE);
	@ARGV = (@KEEPFLG, "-nowhatstring", "$check_filename");
    do "$TOOL/bin/compc$TOOLEXT";
    if ( $@ )
    {  	die "Compile errors for dependency check:\n $@\n";   }
    elsif ( @KEEPFLG == 0 )
    { unlink "$check_filename" }
}


if ( @KEEPFLG == 0 ) { unlink "$BASE.cod" }

