#!/usr/bin/perl
#
# @(#) idistrib   6.2.8   1998-06-03
#
use Env;
use File::Copy;
use ICopy;

if ( @ARGV != 2 ) {
   print "\nUSAGE  : idistrib <component or macro> <hostdirectory>\n";
   print "EXAMPLE: idistrib         cpc             m:\\adabas\n";
   print "EXAMPLE: idistrib        kernel           n:\\develop\n";
   print "\nComponents:\n";
   print "\n";
   print "CPC         audit       call        cobpc       control     cpc    \n";
   print "demo        distrib     easy        r3          kernel      load   \n";
   print "man         query       server      sqlfilter   sqlpl       utility\n";
   print "\n";
   print "Macros:\n";
   print "\n";
   print "alldia    = sqlpl easy load query control \n";
   print "allprecom = cpc fpc cobpc CPC \n";
   print "complete  = kernel server call allprecom alldia audit demo man\n";
   print "total     = complete distrib r3\n";
   die "\n";
}

if ( ! -d "$DBROOT/etc" ) {
	mkdir("$DBROOT/etc", 0);
	}

ICopy::icp("usr/etc/distlist", "$DBROOT/etc/distlist", 1, 0, 0)
	|| die "Can't icp usr/etc/distlist";

if ( -f "$DBROOT/etc/instlist" ) {
	unlink "$DBROOT/etc/instlist.SAVE";
	rename "$DBROOT/etc/instlist", "$DBROOT/etc/instlist.SAVE";
}
chdir($DBROOT) || die "Can't change to directory $DBROOT: $!\n";

# erweitern um sort -u und instlist wird jetzt bei -u ueberschrieben!

#system("$TOOL/pgm/vdistrib -b -r $DBROOT -s nt_intel -i -c $ARGV[0] > $$.vdist");
#open(FILE_IN, "$$.vdist") || die "Can't open $$.vdist (input): $!\n";
system("$TOOL/pgm/vdistrib -b -r $DBROOT -s nt_intel -i -c $ARGV[0]");
open(FILE_IN, "$DBROOT/etc/instlist") || die "Can't open instlist (input): $!\n";
open(FILE_OUT, ">$DBROOT/etc/instlist.tmp") || die "Can't open etc/instlist.tmp (output): $!\n";
while(<FILE_IN>) {
	s/^WARNING:.*'(.*)' /$1/;
	next if m!etc/instlist|Selected components|no manual|^\s*$!;
	print FILE_OUT;
}
close(FILE_IN);
close(FILE_OUT);
#unlink "$$.vdist";
system("$TOOL/Posix/sort -u -o etc/instlist etc/instlist.tmp");
#unlink "etc/instlist.tmp";
$HOSTDIR = $ARGV[1];
open(FILE_IN, "$DBROOT/etc/instlist") || die "Can't open etc/instlist (input): $!\n";
while(<FILE_IN>) {
	chomp;
	next if m!^\s*$!;
	print "$HOSTDIR/usr/$_ $DBROOT/$_\n";
	copy("$HOSTDIR/usr/$_", "$DBROOT/$_") || warn "Can't copy $HOSTDIR/usr/$_ to $DBROOT/$_";
}
close(FILE_IN);

if ( -f "$DBROOT/etc/instlist.SAVE" ) {
   unlink "$DBROOT/etc/instlist"; rename "$DBROOT/etc/instlist.SAVE", "$DBROOT/etc/instlist";
}

__END__

