#!/usr/bin/perl
#
# calls the c++ 'codechecker' and
# writes a protocol with the name $fname.cchk in $TMP,
# where "$fname" is "`basename parameter`".
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#


use Env;
use Getopt::Std;
use File::Basename;
use ICopy;

if ( !getopts('hv') or $opt_h or (@ARGV == 0) ) {

  print <DATA>;
  exit 1;

}

if (defined $TMP)
{
	$WORK=$TMP;
}
else
{
	$WORK=$OWN/tmp;
}

chdir ($WORK);

$CheckExt = ".cchk";

foreach $ModulName ( @ARGV )
{
	# &gar (PTS 1102529) filename without path
	# fileparse not posible (':layer/...)
	$ModulName =~ s/.*\/(.*)$/$1/;
    #ICopy::icp("$ModulName", "$WORK", 0, 0, 1);
    #
	#if ( ! -e "$WORK/$ModulName" ) {
    #        print "error: modul $WORK/$ModulName not found\n";
    #        next;
    #    }
    $resultfiles = [];
    $rc = ICopy::iview ([$ModulName], 0, 0, 0, 1, $resultfiles);
    if ($rc != 1) {
        print "error: modul $ModulName not found\n";
        next;
    }

	$ModulBase = basename($ModulName, "\.cpp");

	# print "codecheck $ModulName\n";
    unlink("$ModulBase$CheckExt");

    #system ("$TOOL/pgm/occ.exe -E -FI$TOOL/incl/chkopts.h  $WORK/$ModulName > $ModulBase$CheckExt");
    system ("$TOOL/pgm/occ.exe -E -FI$TOOL/incl/chkopts.h  @{$resultfiles} > $ModulBase$CheckExt");

    unlink ("$ModulName.occ");
    unlink ("$ModulBase.i");

    if ( ! $opt_v )
	{
       open(FILE_OUT, "<$ModulBase$CheckExt");
       print <FILE_OUT>;
       close(FILE_OUT);
    }

    # unlink ("$WORK/$ModulName");
}


__DATA__


  USAGE: codecheck [-hp]  <modul> ...

  options:

        -h   :   this help information
        -v   :   verbose mode

  The working directory is "$TMP".
  If $TMP is not set, then "$OWN/tmp" is used.
