/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdiag;

import com.sap.dbtech.jdiag.ByteUtil;
import com.sap.dbtech.jdiag.JDiagGUI;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.FileWriter;
import java.io.IOException;

public class LongDescViewer {
    public static final int swapnormal = 1;
    public static final int swapfull = 2;
    LongDesc lDesc = new LongDesc(this);
    public String comment = null;

    public LongDescViewer(byte[] lddesc, int swapkind, String acomment) {
        this(lddesc, swapkind);
        this.comment = acomment;
    }

    public LongDescViewer(byte[] lddesc, int swapkind) {
        this.lDesc.wholeDescriptor = lddesc;
        StructuredMem sm = null;
        switch (swapkind) {
            case 1: {
                sm = new StructuredBytes(lddesc);
                break;
            }
            case 2: {
                sm = new FullswapMem(lddesc);
            }
        }
        if (sm.size() >= 41) {
            this.lDesc.UndefSignal = sm.getInt1(0);
            this.lDesc.Descriptor = sm.getBytes(1, 8);
            this.lDesc.Tabid = sm.getBytes(9, 8);
            this.lDesc.MaxLen = sm.getInt4(17);
            this.lDesc.InternPos = sm.getInt4(21);
            this.lDesc.Infoset = sm.getInt1(25);
            this.lDesc.Valmode = sm.getInt1(28);
            this.lDesc.Valind = sm.getInt2(29);
            this.lDesc.Valpos = sm.getInt4(33);
            this.lDesc.Vallen = sm.getInt4(37);
        }
    }

    void dumpToStream(FileWriter fw) throws IOException {
        fw.write(String.valueOf(String.valueOf(this.comment)).concat("\n"));
        for (int i = 0; i < this.comment.length(); ++i) {
            fw.write("=");
        }
        fw.write("\nUndefSignal: ".concat(String.valueOf(String.valueOf(this.lDesc.getUndefSignal()))));
        fw.write("\nDescriptor:  ".concat(String.valueOf(String.valueOf(this.lDesc.getDescriptor()))));
        fw.write("\nTabid:       ".concat(String.valueOf(String.valueOf(this.lDesc.getTabid()))));
        fw.write("\nMaxLen:      ".concat(String.valueOf(String.valueOf(Integer.toString(this.lDesc.MaxLen)))));
        fw.write("\nInternPos:   ".concat(String.valueOf(String.valueOf(Integer.toString(this.lDesc.InternPos)))));
        fw.write("\nInfoset:     ".concat(String.valueOf(String.valueOf(this.lDesc.getInfoSet()))));
        fw.write("\nValmode:     ".concat(String.valueOf(String.valueOf(this.lDesc.getValmode()))));
        fw.write("\nValind:      ".concat(String.valueOf(String.valueOf(Integer.toString(this.lDesc.Valind)))));
        fw.write("\nValpos:      ".concat(String.valueOf(String.valueOf(Integer.toString(this.lDesc.Valpos)))));
        fw.write("\nVallen:      ".concat(String.valueOf(String.valueOf(Integer.toString(this.lDesc.Vallen)))));
        fw.write("\nHexDump:\n");
        fw.write(ByteUtil.printasHexPattern(this.lDesc.wholeDescriptor, '|'));
        fw.write("\n");
    }

    public static void main(String[] args) {
        String input = "00000000 0000002B 69000000 00000020 AC0004B0 0000007A 4002007E  00020000 00000000 2A00003D 37787878 78787878 78787878 78787878";
        LongDescViewer ldw = new LongDescViewer(ByteUtil.parseBytes(input, 42), 1);
        System.out.println(ldw.lDesc);
    }

    public String toString() {
        if (this.comment != null) {
            return this.comment;
        }
        return super.toString();
    }

    static {
        swapnormal = 1;
        swapfull = 2;
    }

    public class LongDesc {
        final String[] valmodeMap = new String[]{"vm_datapart", "vm_alldata", "vm_lastdata", "vm_nodata", "vm_no_more_data", "vm_last_putval", "vm_data_trunc", "vm_close", "vm_error", "vm_startpos_invalid"};
        public byte UndefSignal;
        public byte[] Descriptor;
        public byte[] Tabid;
        public int MaxLen;
        public int InternPos;
        public byte Infoset;
        public int Valmode;
        public int Valind;
        public int Valpos;
        public int Vallen;
        public byte[] wholeDescriptor;

        public LongDesc(LongDescViewer this$0) {
        }

        public String bytes2String(byte[] arr) {
            StringBuffer sb = new StringBuffer(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Integer.toHexString(arr[i]));
            }
            return sb.toString();
        }

        public String getInfoSet() {
            StringBuffer sb = new StringBuffer(15);
            if (this.Infoset == 0) {
                sb.append("0xFFFFFFFF");
            } else {
                sb.append("0x");
                sb.append((this.Infoset & 0x80) != 0 ? "B" : "F");
                sb.append((this.Infoset & 0x40) != 0 ? "B" : "F");
                sb.append((this.Infoset & 0x20) != 0 ? "B" : "F");
                sb.append((this.Infoset & 0x10) != 0 ? "B" : "F");
                sb.append((this.Infoset & 8) != 0 ? "B" : "F");
                sb.append((this.Infoset & 4) != 0 ? "B" : "F");
                sb.append((this.Infoset & 2) != 0 ? "B" : "F");
                sb.append((this.Infoset & 1) != 0 ? "B\n" : "F");
            }
            return sb.toString();
        }

        public String getDescriptor() {
            return this.bytes2String(this.Descriptor);
        }

        public String getTabid() {
            return this.bytes2String(this.Tabid);
        }

        public String getValmode() {
            try {
                String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.Valmode))).append(" [").append(this.valmodeMap[this.Valmode]).append("]")));
                return string;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                JDiagGUI.logError(String.valueOf(String.valueOf(new StringBuffer("unknown valmode [").append(this.Valmode).append("]"))));
                String string = String.valueOf(String.valueOf(new StringBuffer("unknown valmode [").append(this.Valmode).append("]")));
                return string;
            }
        }

        public String getUndefSignal() {
            return Byte.toString(this.UndefSignal);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(250);
            sb.append(String.valueOf(String.valueOf(new StringBuffer("UndefSignal: ").append(this.UndefSignal).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Descriptor : ").append(this.getDescriptor()).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Tabid      : ").append(this.getTabid()).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("MaxLen     : ").append(this.MaxLen).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("InternPos  : ").append(this.InternPos).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Infoset    : ").append(this.getInfoSet()).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Valmode    : ").append(this.getValmode()).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Valind     : ").append(this.Valind).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Valpos     : ").append(this.Valpos).append("\n"))));
            sb.append(String.valueOf(String.valueOf(new StringBuffer("Vallen     : ").append(this.Vallen).append("\n"))));
            return sb.toString();
        }
    }
}

