@echo off
rem #################################################################
rem #
rem #create example database TST with:
rem # - 20 MB data volume and 8 MB log volume
rem # - demo database user test (with password test)
rem ##################################################################



rem # IND -> independent program path  
rem # DEP -> dependent path
rem # values will be set by installer, if it isn't set correctly - doit yourself right (replace with "$")


set PATH=$IND\bin;$IND\pgm;%PATH%
set INSTPATH="$DEP"


rem name of the database
set SID=TST

rem directory root for volumes (data,log)
set DATA=%SystemDrive%\data

rem start remote communication server
x_server stop
x_server start 

rem stop and drop probably existing demo database
dbmcli -d %SID% -u dbm,dbm db_offline > NUL  
dbmcli -d %SID% -u dbm,dbm db_drop > NUL

rem create new demo database
dbmcli -R %INSTPATH% db_create %SID% dbm,dbm

rem create directory where to put the database files
md %DATA% > NUL
md %DATA%\%SID% > NUL

rem setup database parameters
echo param_startsession > param.tmp
echo param_init OLTP >> param.tmp
echo param_put CAT_CACHE_SUPPLY 300 >> param.tmp
echo param_put CACHE_SIZE 3000 >> param.tmp
echo param_put MAXDATAVOLUMES 5 >> param.tmp
echo param_put RESTART_SHUTDOWN AUTO >> param.tmp
echo param_checkall >> param.tmp
echo param_commitsession >> param.tmp
echo param_addvolume 1 DATA %DATA%\%SID%\DISKD0001 F 2560 >> param.tmp
echo param_addvolume 1 LOG  %DATA%\%SID%\DISKL001  F 1024 >> param.tmp
type param.tmp | dbmcli -d %SID% -u dbm,dbm 

rem startup database
dbmcli -d %SID% -u dbm,dbm db_start

rem initialize database files
echo util_connect dbm,dbm > param.tmp
echo db_activate dba,dba >> param.tmp
type param.tmp | dbmcli -d %SID% -u dbm,dbm 

rem load database system tables
dbmcli -d %SID% -u dbm,dbm load_systab -u dba,dba -ud domain

rem create database demo user
echo sql_connect dba,dba > param.tmp
echo sql_execute CREATE USER test PASSWORD test DBA NOT EXCLUSIVE >> param.tmp
type param.tmp | dbmcli -d %SID% -u dbm,dbm 

echo medium_put data %DATA%\%SID%\datasave FILE DATA 0 8 YES > param.tmp
echo medium_put auto %DATA%\%SID%\autosave FILE AUTO >> param.tmp
echo util_connect dbm,dbm >> param.tmp
echo backup_save data >> param.tmp
echo autosave_on >> param.tmp
type param.tmp | dbmcli -d %SID% -u dbm,dbm 

del param.tmp 
