#
# =====================================================
# @(#) ORADDSYN                  7.2        1999-07-29
# =====================================================
# Changes in  7.2:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from string import upper
from installib import *

def createSynonym (session, synonym, base):
    stopIfSqlNotErr (session, -4004, 'drop view ' + synonym)
    stopIfSqlNotErr (session, -4007, 'drop public synonym ' + synonym)
    stopIfSqlNotOK (session, 'create public synonym ' + synonym
        + ' for ' + base + ' internal')

def createSynonym2 (session, synonym):
    synonym = upper (synonym)
    rc = sqlRC (session, """
            SELECT tablename FROM sysdd.synonyms
            WHERE synonymowner = USER
            AND synonymname  = '%s'""" % synonym)
#   print rc, synonym
    if rc == 100:
        stopIfSqlNotOK (session, 'create public synonym "%s" for sys."%s"'
            % (synonym, synonym))

def install (session,options):
    """Installing synonyms for oracle system tables
    """

    loaderCmd (session, 'SQLMODE INTERNAL')

    loaderCmd (session, 'USE USER sys sys')

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    createSynonym (session, 'cat', 'sys.user_catalog')
    createSynonym (session, 'clu', 'sys.user_clusters')
    createSynonym (session, 'cols', 'sys.user_tab_columns')
    createSynonym (session, 'dict', 'sys.dictionary')
    createSynonym (session, 'ind', 'sys.user_indexes')
    createSynonym (session, 'obj', 'sys.user_objects')
    createSynonym (session, 'seq', 'sys.user_sequences')
    createSynonym (session, 'syn', 'sys.user_synonyms')
    createSynonym (session, 'tabs', 'sys.user_tables')

    loaderCmd (session, 'COMMIT')

    # ------------------------------------------------------------------------
    # In the dd-view all_synonyms should be a list of all the dd-views itselfs
    # from sys to public.


    loaderCmd (session, 'SQLMODE ORACLE')

    loaderCmd (session, 'USE USER sys sys')

    loaderCmd (session, 'INSTALLATION ON')

    createSynonym2 (session, 'all_catalog')
    createSynonym2 (session, 'all_col_comments')
    createSynonym2 (session, 'all_col_privs')
    createSynonym2 (session, 'all_col_privs_made')
    createSynonym2 (session, 'all_col_privs_recd')
    createSynonym2 (session, 'all_constraints')
    createSynonym2 (session, 'all_cons_columns')
    createSynonym2 (session, 'all_db_links')
    createSynonym2 (session, 'all_def_audit_opts')
    createSynonym2 (session, 'all_dependencies')
    createSynonym2 (session, 'all_errors')
    createSynonym2 (session, 'all_indexes')
    createSynonym2 (session, 'all_ind_columns')
    createSynonym2 (session, 'all_objects')
    createSynonym2 (session, 'all_sequences')
    createSynonym2 (session, 'all_snapshots')
    createSynonym2 (session, 'all_source')
    createSynonym2 (session, 'all_synonyms')
    createSynonym2 (session, 'all_tables')
    createSynonym2 (session, 'all_tab_columns')
    createSynonym2 (session, 'all_tab_comments')
    createSynonym2 (session, 'all_tab_privs')
    createSynonym2 (session, 'all_tab_privs_made')
    createSynonym2 (session, 'all_tab_privs_recd')
    createSynonym2 (session, 'all_triggers')
    createSynonym2 (session, 'all_trigger_cols')
    createSynonym2 (session, 'all_users')
    createSynonym2 (session, 'all_views')
    # only for Oracle-6-compatibility, not necessary any more
    # createSynonym2 (session, 'column_privileges')
    createSynonym2 (session, 'dictionary')
    createSynonym2 (session, 'dict_columns')
    createSynonym2 (session, 'exceptions')
    createSynonym2 (session, 'global_name')
    createSynonym2 (session, 'public_dependency')
    createSynonym2 (session, 'resource_cost')
    createSynonym2 (session, 'role_role_privs')
    createSynonym2 (session, 'role_sys_privs')
    createSynonym2 (session, 'role_tab_privs')
    createSynonym2 (session, 'session_privs')
    createSynonym2 (session, 'session_roles')
    # only for Oracle-6-compatibility, not necessary any more
    # createSynonym2 (session, 'table_privileges')
    createSynonym2 (session, 'user_audit_object')
    createSynonym2 (session, 'user_audit_session')
    createSynonym2 (session, 'user_audit_statement')
    createSynonym2 (session, 'user_audit_trail')
    createSynonym2 (session, 'user_catalog')
    createSynonym2 (session, 'user_clusters')
    createSynonym2 (session, 'user_clu_columns')
    createSynonym2 (session, 'user_col_comments')
    createSynonym2 (session, 'user_col_privs')
    createSynonym2 (session, 'user_col_privs_made')
    createSynonym2 (session, 'user_col_privs_recd')
    createSynonym2 (session, 'user_constraints')
    createSynonym2 (session, 'user_cons_columns')
    createSynonym2 (session, 'user_db_links')
    createSynonym2 (session, 'user_dependencies')
    createSynonym2 (session, 'user_errors')
    createSynonym2 (session, 'user_extents')
    createSynonym2 (session, 'user_free_space')
    createSynonym2 (session, 'user_indexes')
    createSynonym2 (session, 'user_ind_columns')
    createSynonym2 (session, 'user_objects')
    createSynonym2 (session, 'user_object_size')
    createSynonym2 (session, 'user_obj_audit_opts')
    createSynonym2 (session, 'user_resource_limits')
    createSynonym2 (session, 'user_role_privs')
    createSynonym2 (session, 'user_segments')
    createSynonym2 (session, 'user_sequences')
    createSynonym2 (session, 'user_snapshots')
    createSynonym2 (session, 'user_snapshot_logs')
    createSynonym2 (session, 'user_source')
    createSynonym2 (session, 'user_synonyms')
    createSynonym2 (session, 'user_sys_privs')
    createSynonym2 (session, 'user_tables')
    createSynonym2 (session, 'user_tablespaces')
    createSynonym2 (session, 'user_tab_columns')
    createSynonym2 (session, 'user_tab_comments')
    createSynonym2 (session, 'user_tab_privs')
    createSynonym2 (session, 'user_tab_privs_made')
    createSynonym2 (session, 'user_tab_privs_recd')
    createSynonym2 (session, 'user_triggers')
    createSynonym2 (session, 'user_trigger_cols')
    createSynonym2 (session, 'user_ts_quotas')
    createSynonym2 (session, 'user_users')
    createSynonym2 (session, 'user_views')
    createSynonym2 (session, 'audit_actions')
    createSynonym2 (session, 'stmt_audit_option_map')
    createSynonym2 (session, 'table_privilege_map')
    createSynonym2 (session, 'dba_2pc_neighbors')
    createSynonym2 (session, 'dba_2pc_pending')
    createSynonym2 (session, 'dba_audit_exists')
    createSynonym2 (session, 'dba_audit_object')
    createSynonym2 (session, 'dba_audit_session')
    createSynonym2 (session, 'dba_audit_statement')
    createSynonym2 (session, 'dba_audit_trail')
    createSynonym2 (session, 'dba_blockers')
    createSynonym2 (session, 'dba_catalog')
    createSynonym2 (session, 'dba_clusters')
    createSynonym2 (session, 'dba_clu_columns')
    createSynonym2 (session, 'dba_col_comments')
    createSynonym2 (session, 'dba_col_privs')
    createSynonym2 (session, 'dba_constraints')
    createSynonym2 (session, 'dba_cons_columns')
    createSynonym2 (session, 'dba_data_files')
    createSynonym2 (session, 'dba_db_links')
    createSynonym2 (session, 'dba_ddl_locks')
    createSynonym2 (session, 'dba_dependencies')
    createSynonym2 (session, 'dba_dml_locks')
    createSynonym2 (session, 'dba_errors')
    createSynonym2 (session, 'dba_exp_files')
    createSynonym2 (session, 'dba_exp_objects')
    createSynonym2 (session, 'dba_exp_version')
    createSynonym2 (session, 'dba_extents')
    createSynonym2 (session, 'dba_free_space')
    createSynonym2 (session, 'dba_indexes')
    createSynonym2 (session, 'dba_ind_columns')
    createSynonym2 (session, 'dba_locks')
    createSynonym2 (session, 'dba_objects')
    createSynonym2 (session, 'dba_object_size')
    createSynonym2 (session, 'dba_obj_audit_opts')
    createSynonym2 (session, 'dba_priv_audit_opts')
    createSynonym2 (session, 'dba_profiles')
    createSynonym2 (session, 'dba_roles')
    createSynonym2 (session, 'dba_role_privs')
    createSynonym2 (session, 'dba_rollback_segs')
    createSynonym2 (session, 'dba_segments')
    createSynonym2 (session, 'dba_sequences')
    createSynonym2 (session, 'dba_snapshots')
    createSynonym2 (session, 'dba_snapshot_logs')
    createSynonym2 (session, 'dba_source')
    createSynonym2 (session, 'dba_stmt_audit_opts')
    createSynonym2 (session, 'dba_synonyms')
    createSynonym2 (session, 'dba_sys_privs')
    createSynonym2 (session, 'dba_tables')
    createSynonym2 (session, 'dba_tablespaces')
    createSynonym2 (session, 'dba_tab_columns')
    createSynonym2 (session, 'dba_tab_comments')
    createSynonym2 (session, 'dba_tab_privs')
    createSynonym2 (session, 'dba_triggers')
    createSynonym2 (session, 'dba_trigger_cols')
    createSynonym2 (session, 'dba_ts_quotas')
    createSynonym2 (session, 'dba_users')
    createSynonym2 (session, 'dba_views')
    createSynonym2 (session, 'dba_waiters')
    createSynonym2 (session, 'V$NLS_PARAMETERS')

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'SQLMODE INTERNAL')

    switchToDefaultUser (session, options)

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


