#
# =====================================================
# @(#) ORADD                     7.2        1999-07-29
# =====================================================
# Changes in  7.2:
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing system tables for ORACLE (V7) mode
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    if not sqlOK (session, """
            SELECT username FROM sysdd.users
             WHERE username = UPPER('sys')"""):
        stopIfSqlNotOK (session, 'CREATE USER sys PASSWORD sys DBA NOT EXCLUSIVE')
    else:
        stopIfSqlNotOK (session, 'ALTER PASSWORD sys sys')
    loaderCmd (session, 'COMMIT')

    if sqlOK (session, """SELECT username FROM sysdd.users
             WHERE username = 'PUBLIC'"""):
        stopIfSqlNotOK (session, 'DROP USER "PUBLIC" CASCADE')

    loaderCmd (session, 'SQLMODE INTERNAL')

    switchToDefaultUser (session, options)

    # The creation of the Oracle system tables, the synonyms for them
    # and the comments on it

    include (session, options,
        "ORADDV",
        "ORADDSYN",
        "ORADDCOM"
        )


    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


