#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/StdIO.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::StdIO;


$VERSION=1.01;

sub BEGIN {
		@ISA = ('SAPDB::Install::Exporter');
        @EXPORT = ('timeStamp','print2stderr', 'print2stdout','readstdin','diesoft');
		my $repo = SAPDB::Install::Repository::GetCurrent ();
        my @neededPackages=(
			'Term::ReadKey',
			'Trace'
		);
		foreach my $package (@neededPackages){
	  		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
			SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
		}
}



# set autoflush on
$| = 1;



#sub generates formated time stamp
sub timeStamp{
	my $hour=(localtime)[2];
	my $minute = (localtime)[1];
	my $second= (localtime)[0];
	my $day= (localtime)[3];
	$hour = "0$hour" if(length($hour)==1);
	$minute = "0$minute" if(length($minute)==1); 
    $second = "0$second" if(length($second)==1);
	$day = "0$day" if(length($day)==1);
	my $returnvalue=(Su,Mo,Tu,We,Th,Fr,Sa)[(localtime)[6]].", ". 
	(Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[(localtime)[4]].
	    " $day, ".((localtime)[5]+1900).
		" at $hour:$minute:$second";
	return $returnvalue;
}

#sub print message to STDERR and into logfile
sub print2stderr{
    local $message=(@_)[0];
    $SAPDB::Install::DEBUG or print STDERR $message;
    TraceMsg("ERR: $message",1,\$DEBUG,2);
	defined  $SAPDB::Install::Values::log && $SAPDB::Install::Values::log->SetMsg("STDERR: $message");
}


#sub print message to STDOUT and into logfile
sub print2stdout{
    my $message=(@_)[0];
    $SAPDB::Install::DEBUG or print $message;
	TraceMsg("OUT: $message",1,\$DEBUG,2);
    defined  $SAPDB::Install::Values::log && $SAPDB::Install::Values::log->SetMsg("STDOUT: $message");
}


#sub read stdin
sub readstdin{
    my ($psswrd_mode)=@_;# if true terminal echo will be disabled
    my $returnvalue;
    if($psswrd_mode){
		#import SAPDB::Install::Term::ReadKey;
		my $rc = SAPDB::Install::Term::ReadKey::ReadMode('noecho');
		defined $rc or print2stderr("cannot set term mode to echo off: $rc\n") and diesoft($SAPDB::Install::Values::diemsg);	
		chomp($returnvalue = SAPDB::Install::Term::ReadKey::ReadLine());	
		TraceMsg("IN: <secret>",1,\$DEBUG,2);
		print2stdout("\n");
		defined  $SAPDB::Install::Values::log && $SAPDB::Install::Values::log->SetMsg("\nSTDIN: \n");
		$rc = SAPDB::Install::Term::ReadKey::ReadMode('restore');
		defined $rc or print2stderr("cannot restore term mode\n") and diesoft($SAPDB::Install::Values::diemsg); 
   
	}
    else{
		chomp($returnvalue=<STDIN>);
		TraceMsg("IN: $returnvalue",1,\$DEBUG,2);
    	defined  $SAPDB::Install::Values::log && $SAPDB::Install::Values::log->SetMsg("\nSTDIN: $returnvalue\n");
    }
    return $returnvalue;
}

#sub print message into logfile and exite installer 
sub diesoft{
    my $message=(@_)[0];
    $message="$message at ".timeStamp()."\n";
    TraceMsg("DIE: $message",1,\$DEBUG,2);
    print2stderr($message);
	WriteTrace();
	if($SAPDB::Install::Config{'HasOwnConsole'} and !$SAPDB::Install::StartInstall::opt_b){
		print2stdout("\npress any key...");
		SAPDB::Install::Term::ReadKey::ReadMode('raw');
		SAPDB::Install::Term::ReadKey::ReadKey();
	}
	exit 1;
}

1;