#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/SigHandler.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::SigHandler;


$VERSION = 1.01;

sub BEGIN {
        
       @ISA = ('SAPDB::Install::Exporter');
	 @EXPORT = ('setSigHandler');

	  my $repo = SAPDB::Install::Repository::GetCurrent ();
        my @neededPackages=(
	  	'Exporter',
		'StdIO',
		'Trace'
	   );
	  foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


sub setSigHandler{
	
	$SIG{'INT'} = sub {
					print2stderr("\nCtrl + c pressed!\n");
					defined $SAPDB::Install::StartInstall::cleaner and $SAPDB::Install::StartInstall::cleaner->DESTROY and $SAPDB::Install::StartInstall::cleaner=undef;
					defined $SAPDB::Install::Uninstall::Start::cleaner and $SAPDB::Install::Uninstall::Start::cleaner->DESTROY and $SAPDB::Install::Uninstall::Start::cleaner=undef;
					diesoft('aborted');
				 };
	
	foreach my $errsig ('ABRT','BUS','EMT','FPE','ILL','QUIT','SEGV','SYS','TRAP'){
		
		$SIG{$errsig} = sub {
						print2stderr("SIGNAL: got signal $errsig\n");
						WriteTrace();
						defined $SAPDB::Install::StartInstall::cleaner and $SAPDB::Install::StartInstall::cleaner->DESTROY and $SAPDB::Install::StartInstall::cleaner=undef;
						defined $SAPDB::Install::Uninstall::Start::cleaner and $SAPDB::Install::Uninstall::Start::cleaner->DESTROY and $SAPDB::Install::Uninstall::Start::cleaner=undef;
						diesoft('fatal error');
	
					};
	}
	
}

1;