#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Misc.pm#4 $
# $DateTime: 2004/01/15 09:17:16 $
# $Change: 61975 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::Misc;

$VERSION = 1.01;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('printVersion','selectInstallation','newinstall','update',
	           'delete','patch','getPath','checkOwner','checkGroup',
	           'checkNode','expandPath','askGroup','setServerRootPermissions');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Values',
		'InstInfo',
		'Getopt::Long',
		'Tools',
		'System',
		'System::Unix',
		'System::Unix::Dir',
		'Trace'
	);

	push @neededPackages, 'Term::ReadKey' if $SAPDB::Install::Config{'HasOwnConsole'};

	push @neededPackages,'Registry','System::Unix' unless $^O =~ /mswin/i;
	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	} 
}





sub printVersion{
	local (*ARGV)=@_;
	%opt_ctrl=(
		'v' => \$opt_v,
		'version' => \$opt_version
	);
	SAPDB::Install::Getopt::Long::Configure('pass_through');
	SAPDB::Install::Getopt::Long::Configure('noauto_abbrev');
	GetOptions(%opt_ctrl);
	if(defined $opt_version || defined $opt_v){
		print "\n\n\nPERL MODULE ARCHIVE VERSION: $SAPDB::Install::Version::Version (changelist id: $SAPDB::Install::Version::Change)\n";
		print "\n\n\nSDBRUN VERSION: ".$SAPDB::Install::Config{'BinaryInstVersion'}." (changelist id: ".$SAPDB::Install::Config{'BinaryChangeList'}.")\n";
		if($SAPDB::Install::Config{'HasOwnConsole'}){
		print2stdout("\npress any key...");
		SAPDB::Install::Term::ReadKey::ReadMode('raw');
		SAPDB::Install::Term::ReadKey::ReadKey();
	}
		die ("\n\n\n");
	}
	1;
}





#sub get installation path in interaction with user
sub getDir{
    my $default=$_[0];
	my $path=readstdin();
    $path=~s/\\/\//g;
	unless($path){
		$path=$default;
	}
    if(-d $path){	
		return $path;
   }
    else{
		print2stdout("directory \"$path\" does not exist, create? (y/n) ");
		$_=readstdin();
		if(/^[yY].*/){
			return $path;
		}
		else{
			print2stdout("abort installation? (y/n) ");
			$_=readstdin();
			if(/^[yY].*/){
				diesoft("installation of $SAPDB::Install::Values::product aborted "); 
			}
		}	
	}
	return "";
}


	
#sub expand relativ path names to absolute
sub expandPath{
	my ($tmp)=@_;
	defined $tmp or return;
	$tmp=~/^\s*$/ and return;
	$tmp=~s/^\s*//g;
	if($^O =~ /mswin/i){
		unless($tmp =~ /^[a-zA-Z]:[\/\\].*/){
			$tmp=$SAPDB::Install::Values::curDir."/$tmp";
		}
	}
	else{
		unless($tmp =~ /^[\/\\].*/){
			$tmp=$SAPDB::Install::Values::curDir."/$tmp";
		}
	}
	return $tmp;
}


sub getPath{
	my ($name,$default,$opt,$batch)=@_;
	my $returnvalue;
	if($opt){
		$returnvalue=expandPath($opt);
		$returnvalue =~ s/\\/\//g;
		return $returnvalue; 
	}

	$batch and
	print2stderr("run in batch mode - \"$name\" unknown\n") and
	diesoft($SAPDB::Install::Values::diemsg);

	while(! $returnvalue){
		print2stdout("please enter $name [$default]: ");
		$returnvalue = getDir($default);
	}
	return expandPath($returnvalue);		
}



sub checkAccount{
	return 1 if $^O =~ /mswin/i;
	my ($user,$pgid) =  @_;

	my ($username,$spwd,$is_locked) = SAPDB::Install::System::Unix::getspnam($user);
	unless (defined $is_locked){
		print2stderr("cannot check account \"$user\"\n");
		print2stderr("make sure that account exists and restart installation\n");
		return 0;
	}

	if ($is_locked == 0){
		print2stderr("account \"$user\" is not locked, this is a security leak\n");
		print2stderr("lock account and restart installation\n");
		return 0;
	}
	
	if (defined $pgid and (getpwnam($user))[3] != $pgid){
		print2stderr ("primary group of sdb owner \"$user\" must be administrators group \"".(getgrgid($pgid))."\"\n");
		print2stderr ("make sure that administrators group is primary group of sdb owner and restart installation\n");
		return 0;
	}

	return 1;
}


sub setPassword{
	return if $^O =~ /mswin/i;
	my ($owner) = @_ if($> == 0);
	if($batch){
		print2stderr("WRN: run in batchmode - please set password for os user $owner with command \"passwd $owner\" after installation\n");
	}
	else{
		my $outtext=`passwd $owner`;
		# match: linux, hp, sun - success |  tru64 - updated | aix - ^$
		$outtext=~/success|updated|^$/gi and
		$SAPDB::Install::Values::log->SetMsg("MSG: change os user password successfully\n") or
		print2stdout("cannot set os user password\n");
	}
}

sub initAdminGroup {
	($^O=~/MSWin.*/i) and return 1;

	sub ismemberof {
		my ($a, @list) = @_;

		foreach my $b (@list) {
			return 1 if ($a == $b);
		}

		return 0;
	}

	# get gid and name of admin group
	my ($gid) = @_;
	my $group = getgrgid ($gid);

	# get owner of all databases and
	# check if there are member of admin group
	# get a list of all dbowners to be added

	# new installation, no installation info available
	my $info = SAPDB::Install::InstInfo::new ();
	(defined $info) or return 1;

	# first Database Server installation, no database can be found
	my $dbs = $info->{'database'};
	(defined $dbs) or return 1;

	my @users = ();
	foreach my $key (sort (keys (%$dbs))) {
		my $dbname = $dbs->{$key}->{'dbname'};
		my $dbowner = $dbs->{$key}->{'dbowner'};

		my ($uid, @gids) = ugetids ($dbowner);
		next if (ismemberof ($gid, @gids));
		push @users, $dbowner;
	}

	return 1 if ($#users == -1);

	# unify list of users
	@users = sort (@users);
	for (my $i = 0; $i < $#users;) {
		if ($users[$i] eq $users[$i + 1]) {
			splice (@users, $i, 1);
		} else {
			$i++;
		}
	}

	# read /etc/group and find admin group
	# add dbowner if admin group exists in /etc/group

	my $infile = '/etc/group';
	my $outfile = $infile.'.'.$$;

	unless (open (IN, $infile)) {
		print2stderr ("cannot open $infile\n");
		return 0;
	}

	my $groupfound = 0;

	my @lines = ();
	while (my $line = <IN>) {
		chomp $line;

		my ($grgroup) =	($line =~ /^([^:]*):/);
		unless (defined $grgroup && $grgroup eq $group) {
			push @lines, $line;
			next;
		}

		$groupfound++;

		foreach my $user (@users) {
			if ($line =~ /:$/) {
				$line .= $user;
			} else {
				$line .= ','.$user;
			}
		}
		push @lines, $line;
	}

	close (IN);

	unless ($groupfound != 0) {
		print2stderr ("admin group $group not found in $infile\n");
		print2stderr ("may be groups are managed by NIS\n");
		print2stderr ("add database owner ".join (' ', @users)." to group $group\n");
		print2stderr ("and restart installation\n");
		return 0;
	}

	# write modified /etc/groups
	my $rc;
	unlink ($outfile);
	unless (open (OUT, "> $outfile")) {
		print2stderr ("cannot open $outfile\n");
		return 0;
	}
	
	foreach my $line (@lines) {
		$rc = print OUT $line."\n";
		last unless ($rc);
	}

	close (OUT);

	unless ($rc) {
		print2stderr ("cannot write $outfile\n");
		return 0;
	}

	my @sb = stat ($infile);
	$rc = chown ($sb[4], $sb[5], $outfile);
	unless ($rc == 1) {
		print2stderr ("cannot chown $outfile\n");
		return 0;
	}

	unless (chmod ($sb[2] & 07777, $outfile) == 1) {
		print2stderr ("cannot chmod $outfile\n");
		return 0;
	}

	unless (unlink ($infile) == 1) {
		print2stderr ("cannot unlink $infile\n");
		return 0;
	}

	unless (rename ($outfile, $infile)) {
		print2stderr ("cannot rename $outfile $infile\n");
		return 0;
	}

	$SAPDB::Install::Values::log->SetMsg
	("added database owner ".join (' ', @users)." to admin group\n") or

	return 1;
}

sub setServerRootPermissions {
	($^O=~/MSWin.*/i) and return 1;

	# get owner
	my ($owner) = @_;

	# new installation, no inst info can be found
	my $info = SAPDB::Install::InstInfo::new ();
	(defined $info) or return 1;

	# first server installation, no database can be found
	my $dbs = $info->{'database'};
	(defined $dbs) or return 1;

	my @dirs = ();
	foreach my $key (sort (keys (%$dbs))) {
		push @dirs, scalar ($dbs->{$key}->{'dbswdir'});
	}

	foreach my $dir (@dirs) {
		next unless (-d $dir);

		$SAPDB::Install::Values::log->SetMsg ("checking permissions on $dir\n");

		unless (uaccess ($owner, $dir) == 0) {
			$SAPDB::Install::StartInstall::log->SetMsg ("user $owner cannot access directory $dir\n");
			$SAPDB::Install::StartInstall::log->SetMsg ("set permissions on $dir\n");

			my ($dev, $ino, $mode) = stat ($dir);
			$SAPDB::Install::StartInstall::log->SetMsg ("mode of $dir is ".sprintmode ($mode)."\n");
			unless (($mode & 0111) == 0111) {
				$SAPDB::Install::StartInstall::log->SetMsg ("chmod $dir ugo+x\n");
				chmod (($mode & 07777) | 00111, $dir);
			}
		}

		unless (uaccess ($owner, $dir) == 0) {
			$SAPDB::Install::StartInstall::log->SetMsg ("user $owner cannot access directory $dir\n");
			$SAPDB::Install::StartInstall::log->SetMsg ("modify permissions of parent directories\n");

			my @ancestors =	SAPDB::Install::System::Unix::Dir::getancestors ($dir);
			foreach my $dir (@ancestors) {
				next if (-l $dir);

				my ($dev, $ino, $mode) = stat ($dir);
				$SAPDB::Install::StartInstall::log->SetMsg ("mode of $dir is ".sprintmode ($mode)."\n");
				next if (($mode & 0111) == 0111);

				$SAPDB::Install::StartInstall::log->SetMsg ("chmod $dir ugo+x\n");
				chmod (($mode & 07777) | 00111, $dir);
			}
		}

		uaccess ($owner, $dir) == 0 or
		print2stderr ("user $owner cannot access directory $dir\n") and
		print2stderr ("please check permissions of $dir and any parent directory\n") and
		print2stderr ("and restart installation\n") and
		return 0;

		# make lserver and dbmsrv accessable from vserver
		my $pgm = $dir.'/pgm';
		unless (uaccess ($owner, $pgm) == 0) {
			$SAPDB::Install::StartInstall::log->SetMsg ("user $owner cannot access directory $pgm\n");

			my ($dev, $ino, $mode) = stat ($pgm);
			$SAPDB::Install::StartInstall::log->SetMsg ("mode of $pgm is ".sprintmode ($mode)."\n");
			unless (($mode & 0111) == 0111) {
				$SAPDB::Install::StartInstall::log->SetMsg ("chmod $pgm ugo+x\n");
				chmod (($mode & 07777) | 00111, $pgm);
			}
		}

		uaccess ($owner, $pgm) == 0 or
		print2stderr ("user $owner cannot access directory $pgm\n") and
		print2stderr ("please check permissions of $dir and any parent directory\n") and
		print2stderr ("and restart installation\n") and
		return 0;

		foreach my $item ('dbmsrv', 'lserver') {
			$file = $pgm.'/'.$item;

			my ($dev, $ino, $mode, $nlink, $uid, $gid) = stat ($file); 
			# only modify x bit of setuid root dbmsrv and lserver (<= 7.4.03)
			next unless ($uid == 0);
			next unless (($mode & 04000) == 04000);

			$SAPDB::Install::StartInstall::log->SetMsg
			("$file is setuid root mode ".sprintmode ($mode)."\n");

			next if (($mode & 0111) == 0111);

			$SAPDB::Install::StartInstall::log->SetMsg ("chmod $file ugo+x\n");
			chmod (($mode & 07777) | 00111, $file) == 1 or
			print2stderr ("cannot modify permissions of $file\n") and
			print2stderr ("set mode $file to ".sprintmode ($mode)." and owner root\n") and
			print2stderr ("and restart installation\n") and
			return 0;
		}
	}

	return 1;
}

sub checkOwner{
	($^O=~/MSWin.*/i) and return 0;
	
	my ($default,$packobj,$opt,$batch)=@_;	

	my $glob = readGlobals();
	my $owner;

	if($glob->{'SdbOwner'} =~ /\S/){
		$owner =  $glob->{'SdbOwner'};
		if($opt =~ /\S/ and $opt ne $owner){
			print2stderr("WRN: changing sdb user \"$owner\" to \"$opt\" not permitted\n");
		}
	}
	elsif($opt =~ /\S/){
		$owner = $opt;
	}
	else{
		$batch and
		print2stderr("run in batch mode - \"owner\" unknown\n") and
		diesoft($SAPDB::Install::Values::diemsg);

		print2stdout("please enter owner name for database programs [$default]: ");
		$owner=readstdin();
		$owner=$default unless ($owner);
	}

	my $uid = (getpwnam($owner))[2];
	unless($uid ne ''){
		unless($batch){
			print2stdout("unknown user -  create \"$owner\" on local machine? (y/n) ");
			$_=readstdin();
			unless(/^[yY].*/){
				diesoft("installation of $SAPDB::Install::Values::product aborted ");
			}
		}
		#create new user
		if($^O=~/aix/i){
			callsystem('mkuser pgrp='.$packobj->Group." rlogin=false login=false account_locked=true $owner");
		}
		else{
			callsystem("useradd -s /bin/false -c \"MaxDB user\" -g ".$packobj->Group." -m $owner");#2> /dev/null > /den/null";
		}
		$uid=(getpwnam($owner))[2];
		unless($uid ne ''){
			print2stderr("cannot create user \"$owner\" \n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
	}

	checkAccount($owner,$packobj->GID) or diesoft($diemsg);
	initAdminGroup ($packobj->GID) or diesoft($diemsg);
	
	$packobj->User($owner);
	$packobj->UID($uid);

	return 1;
}



sub checkGroup{
	($^O=~/MSWin.*/i) and return 0;
	my ($default,$packobj,$opt,$batch)=@_;
	if($< == 0){
		#
		# non user mode installation
		#
		my $glob = readGlobals();
		if($glob->{'SdbGroup'} =~ /\S/){
			my $group =  $glob->{'SdbGroup'};
			if($opt =~ /\S/ and $opt ne $group){
				print2stderr("WRN: changing sdb adminstators group \"$group\" to \"$opt\" not permitted\n");
				#diesoft($SAPDB::Install::Values::diemsg);
			}
			$gid = (getgrnam($group))[2];
			if($gid eq ''){	
				print2stderr("sdb administrators group \"$group\" doesn\`t exist\n");
				diesoft($SAPDB::Install::Values::diemsg);
			}

			$packobj->Group($group);
			$packobj->GID($gid);
			return 1;
		}
	}



	if($opt){
		#group as command line argument
		my $group=$opt;
		my $gid=(getgrnam($group))[2];
		if($gid eq ''){
			#group does not exist - try to create new one
			if($^O=~/aix/i){
				callsystem("mkgroup $group");
			}
			else{
				callsystem("groupadd $group");
			}
			$gid=(getgrnam($group))[2];
			if($gid eq ''){
				#cant create group
				print2stderr("cannot create group\n");
				diesoft($SAPDB::Install::Values::diemsg);
			}
		}
		$packobj->Group($group);
		$packobj->GID($gid);
	}
	else{
		$batch and print2stderr("run in batch mode - \"group\" unknown\n") and diesoft($SAPDB::Install::Values::diemsg);
		while(1){
			print2stdout("please enter group name for database programs [$default]: ");
			my $group=readstdin();
			unless($group){
				$group=$default;
			}
			my $gid=(getgrnam($group))[2];
			if($gid ne ''){
				$packobj->Group($group);
				$packobj->GID($gid);
				last;
			}
			print2stdout("unknown group - create \"$group\" on local machine? (y/n) ");
			$_=readstdin();
			if(/^[yY].*/){
				#create new group
				if($^O=~/aix/i){
					callsystem("mkgroup $group");
				}
				else{
					callsystem("groupadd $group");
				}
				$gid=(getgrnam($group))[2];
				if($gid ne ''){
					$packobj->Group($group);
					$packobj->GID($gid);
					last;
				}
				else{
					print2stderr("cannot create group \"$group\" \n");
					diesoft($SAPDB::Install::Values::diemsg);
				}
			}
	
			print2stdout("abort installation? (y/n) ");
			$_=readstdin();
			/^[yY].*/ and diesoft("installation of $SAPDB::Install::Values::product aborted ");
		}
	}
}

sub askGroup{
	my ($name,$opt,$default,$batch) = @_;
	my ($group,$gid);
	
	if($opt){
		#group as command line argument
		$group=$opt;
		$gid=(getgrnam($group))[2];
		if($gid eq ''){
			#group does not exist - try to create new one
			if($^O=~/aix/i){
				callsystem("mkgroup $group");
			}
			else{
				callsystem("groupadd $group");
			}
			$gid=(getgrnam($group))[2];
			if($gid eq ''){
				#cant create group
				print2stderr("cannot create group\n");
				diesoft($SAPDB::Install::Values::diemsg);
			}
		}
	}
	else{
		$batch and print2stderr("run in batch mode - \"$name\" unknown\n") and diesoft($SAPDB::Install::Values::diemsg);
		while(1){
			print2stdout("please enter $name [$default]: ");
			$group=readstdin();
			unless($group){
				$group=$default;
			}
			$gid=(getgrnam($group))[2];
			if($gid ne ''){
				last;
			}
			print2stdout("unknown group - create \"$group\" on local machine? (y/n) ");
			$_=readstdin();
			if(/^[yY].*/){
				#create new group
				if($^O=~/aix/i){
					callsystem("mkgroup $group");
				}
				else{
					callsystem("groupadd $group");
				}
				$gid=(getgrnam($group))[2];
				if($gid ne ''){
					last;
				}
				else{
					print2stderr("cannot create group \"$group\" \n");
					diesoft($SAPDB::Install::Values::diemsg);
				}
			}
	
			print2stdout("abort installation? (y/n) ");
			$_=readstdin();
			/^[yY].*/ and diesoft("installation of $SAPDB::Install::Values::product aborted ");
		}
	}
	return ($group,$gid);
}



sub newinstall {
	my ($packobj)=@_;
	my $regpackobj = $packobj->RegData;
	my @filelist = keys(%{$packobj->FileList}); 
	$#filelist != -1 and unpackTGZ($packobj,${%{$packobj->MainPath}}{'value'},0,@filelist);
	if(defined $packobj->preunpack){
		eval{
			&{$packobj->preunpack};
		}; $@ and print2stderr("WRN: error in preunpack(): $@\n");
	}	
	checkUnpackedArchive(${%{$packobj->MainPath}}{'value'},$packobj->FileList);
	$regpackobj->FileList($packobj->FileList);
	$regpackobj->Script($packobj->Script);
	#changeOwner($packobj->User,$packobj->Group,${%{$packobj->MainPath}}{'value'},keys(%{$packobj->FileList}));
}	


sub delete{
	print2stderr("delete function not implemented yet\n");
	diesoft($SAPDB::Install::Values::diemsg);
}					


sub update{
	my ($packobj)=@_;
	my @subnames = ();
	my @subobjs = ();
	$SAPDB::Install::StartInstall::cleaner->SetRef(\@subobjs);
	foreach my $subpackobj (@{$packobj->SubPackObjs}){
		${$$subpackobj->Skip} and next;
		$$subpackobj->Update or next;
		push @subnames,$$subpackobj->Name;
		$$subpackobj->RegData->evalScript();
		if(defined $$subpackobj->RegData->unregister){
			$$subpackobj->RegData->setValid(0);
			$$subpackobj->RegData->Registry->Log->SetMsg("unregister subpackage ".$$subpackobj->DispName."\n");
			eval{
				&{$$subpackobj->RegData->unregister};
			}; $@ and print2stderr("WRN: error in unregister() of subpackage \"".$$subpackobj->DispName."\": $@\n");
		}
	}
	my @all_other_subs;
	foreach $subpack_id (@{$packobj->RegData->SubPackages}){
		my $found = 0;
		foreach my $name (@subnames){
			$subpack_id->[0] eq $name and $found=1 and last;
		}
		unless($found){
			push @all_other_subs,$subpack_id;
		}
	}


	my $regpackobj=$packobj->RegData;
	foreach my $subpack_id (@all_other_subs){
		my $subregpackobj = $regpackobj->Registry->getPackage(@$subpack_id,0,1);
		defined $subregpackobj or next;
		$subregpackobj->evalScript();
		if(defined $subregpackobj->unregister){
			$subregpackobj->setValid(0);
			$subregpackobj->Registry->Log->SetMsg("unregister subpackage ".$subregpackobj->DispName."\n");
			eval{
				&{$subregpackobj->unregister};
			}; $@ and print2stderr("WRN: error in unregister() of subpackage \"".$subregpackobj->DispName."\": $@\n");
		}
		push @subobjs,\$subregpackobj;	
		
	}


	$regpackobj->evalScript();
	if(defined $regpackobj->unregister && (!$packobj->IsSubPackage || $packobj->IsSubPackage && !$packobj->WithParent)){
		eval{
			&{$regpackobj->unregister};
		}; $@ and print2stderr("WRN: error in unregister(): $@\n");
		if($^O=~/aix/i){
			#on aix shared libs may stay in memory after ending related processes
			#slibclean remove all unused shared objects 
			sub ignore_all_errors{
				my ($text)=@_;
				$SAPDB::Install::StartInstall::log->SetMsg("MSG: SYS: slibclean: $text\n");
				return 1;
			}
			callsystem('slibclean',\&ignore_all_errors,1);
		}
	}
	my %newmd5sums = %{$packobj->FileList}; # md5sums of files in tgz archive
	my @newlist=keys(%newmd5sums);
	my %regmd5sums = %{$regpackobj->FileList};
	if(%regmd5sums){# md5sums from registered filelist; original status
		my %curmd5sums=getcurmd5sums($regpackobj->Path,keys(%regmd5sums)); # md5sums of current installed files
		my @reglist=keys(%regmd5sums);
		my @nonew=minus(\@reglist,\@newlist);
		my @modified;
		my @missed;
		foreach my $file (@reglist){
			unless(-f $regpackobj->Path.'/'.$file){ 
				TraceMsg("file \"$file\" not found\n",3,\$DEBUG);
				push @missed,$file;
				next;
			}
			if($regmd5sums{$file} ne $curmd5sums{$file}){
				TraceMsg("file \"$file\" modified\n",3,\$DEBUG);
				push(@modified,$file); # all files of current installation, which was modified
			}
		}
		my @delete = minus(\@nonew,\@modified); # files to delete
		@delete = minus(\@delete,\@missed); # a missed file can't be deleted
		deleteFiles($regpackobj->Path,@delete);
		my @rename = intersect(\@newlist,\@modified); # files to rename
		my @renamed = renameModFiles($regpackobj->Path,@rename);
	}

	if(defined $packobj->preunpack){
		eval{
			&{$packobj->preunpack};
		}; $@ and print2stderr("WRN: error in preunpack(): $@\n");
	}
	
	$#newlist != -1 and unpackTGZ($packobj,$regpackobj->Path,0,@newlist);
	checkUnpackedArchive($regpackobj->Path,$packobj->FileList);
	$regpackobj->FileList(\%newmd5sums);
	$regpackobj->Script($packobj->Script);
	#changeOwner($packobj->User,$packobj->Group,${%{$packobj->MainPath}}{'value'},keys(%{$packobj->FileList}));
	return $#subobjs > -1 ? \@subobjs : undef; 
}

			
sub patch{
	my ($packobj)=@_;
	my $regpackobj=$packobj->RegData;
	my %newmd5sums = %{$packobj->FileList}; # md5sums of files in tgz archive
	my %regmd5sums = %{$regpackobj->FileList};
	my %curmd5sums=getcurmd5sums(${%{$packobj->MainPath}}{'value'},keys(%newmd5sums)); # md5sums of current installed files
	my @modified;
	foreach my $file (keys(%newmd5sums)){
		if($regmd5sums{$file} ne $curmd5sums{$file}){
			TraceMsg("file \"$file\" modified\n",4,\$DEBUG);
			push(@modified,$file); # all files of current installation, which was modified
		}
	}
	my @rename = intersect(\@newlist,\@modified); # files to rename
	my @renamed = renameModFiles(${%{$packobj->MainPath}}{'value'},@rename);
	$#newlist != -1 and unpackTGZ($packobj,${%{$packobj->MainPath}}{'value'},0,@newlist);
	checkUnpackedArchive(${%{$packobj->MainPath}}{'value'},$packobj->FileList);
	$regpackobj->mergeList(%newmd5sums);
	#changeOwner($packobj->User,$packobj->Group,${%{$packobj->MainPath}}{'value'},keys(%{$packobj->FileList}));
}
	
sub listUpdatables{
			my ($hrRegisteredPackages,$packobj,$batch)=@_;
			my $text;
			$packobj->Type eq 'PATCH' and $text = 'patch' or $text='update';
			my %registeredPackages = %$hrRegisteredPackages;
			my @show_patchable;
			my @patchable_pathes;
			foreach my $path (keys(%registeredPackages)){
					my $version=$registeredPackages{$path};
					#print "TEST: $version - ".$packobj->Version.." - ".$packobj->MinVersion."\n";
					if(release2num($version) <= release2num($packobj->Version) and release2num($version) >= release2num($packobj->MinVersion)){
						push(@patchable_pathes,$path);
						push(@show_patchable,[$path,$registeredPackages{$path}]);

					}
					else{
						push (@nonpatchable,$path);
					}
			}
			
			$#nonpatchable > -1 and print2stdout("cannot $text following installation(s):\n");
			foreach my $path (@nonpatchable){
				printTable([[$path,$registeredPackages{$path}]],' ');
			}
			print2stdout("\n\n");
			$text =~ s/e$//g; #remove e from update
			$#patchable_pathes == -1 and print2stdout("no ${text}able installation of package \"".$packobj->DispName."\" found\n") and return 0;
			
			#print2stdout("\n\n\nfound  ${text}able installation(s): \n");
			#my $count=0;
			#foreach my $path (@patchable_pathes){
			#	print2stdout($count++.": $path - $registeredPackages{$path}\n");
			#}
			#my $selection;
			#if($count == 0){
			#	return;
			#}
			#elsif($batch){
			#	print2stderr("cannot select ${text}able installation - run in batch mode\n");
			#	diesoft($SAPDB::Install::Values::diemsg);
			#}
			#else{
			#	$selection=ask4update($count);
			#}
			
			$selection=ask4any(\@show_patchable,$text.'able installation','select',$batch);
			$selection == -1 and return;
			return $patchable_pathes[$selection];
}

sub selectInstallation{
	my ($instRegistry_ref,$packobj,$batch)=@_;
	my $instRegistry = $$instRegistry_ref;
    my %registeredPackages;
    if(defined $instRegistry){
		%registeredPackages=$instRegistry->getInstallPathes($packobj->Name);
    }
	my $selectedPath=listUpdatables(\%registeredPackages,$packobj,$batch);
	unless($selectedPath){
		$packobj->Update(0);
		return 1;
	}
	$packobj->Update(1);
	local *mainpath=$packobj->MainPath;
	$mainpath{'value'}=$selectedPath;
	return 1;
}

1;
