#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/BuildInfo.pm#3 $
# $DateTime: 2002/04/12 13:41:44 $
# $Change: 19381 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::BuildInfo;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::BuildInfo;
}

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('GetBuild', 'GetBuildInfo');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		import ("SAPDB::Install::$package"); 
	}
}

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::BuildInfo;
}

sub GetBuild {
	my  $BUILDINFO = GetBuildInfo (shift);
	return () unless defined ($BUILDINFO->{'Build'});
	return @{$BUILDINFO->{'Build'}};
}

#
# main
#
sub main {
	return (SAPDB::Install::BuildInfo::Test::main (@_));
}

package SAPDB::Install::BuildInfo::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my ($filename) = @_;

	unless (defined $filename) {
	print "BuildInfo <filename>\n";
	return 0;
}

	my $buildinfo = SAPDB::Install::BuildInfo::GetBuildInfo ($filename);
	print $filename.":\n";
	while (my ($key, $val) = each (%$buildinfo)) {
		if (ref ($val) eq 'ARRAY') {
			print "  ".$key.": ".join ('.', @$val)."\n";
		} elsif (ref ($val) eq 'HASH') {
			while (my ($subkey, $subval) = each %$val) {
				print "  ".$key.".".$subkey.": ".$subval."\n";
			}
		} else {
			print "  ".$key.": ".$val."\n";
		}
	}

	return 0;
}

1;

