#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/SysInfo.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::SysInfo;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::SysInfo;
}

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('GetSystemInfo','IsRunnable');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter', 'PipeExec'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		import ("SAPDB::Install::$package"); 
	}
}

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::SysInfo;
}

#
# main
#
sub main {
	return (SAPDB::Install::SysInfo::Test::main (@_));
}

package SAPDB::Install::SysInfo::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my $sysinfo = SAPDB::Install::SysInfo::GetSystemInfo ();

	if (exists $sysinfo->{'system'}) {
		print "System        : ".$sysinfo->{'system'}."\n";
	}

	if (exists $sysinfo->{'architecture'}) {
		print "Architecture  : ".$sysinfo->{'architecture'}."\n";
	}

	if (exists $sysinfo->{'version'}) {
		print "Version       : ".$sysinfo->{'version'}."\n";
	}

	if (exists $sysinfo->{'subversion'}) {
		print "Subversion    : ".$sysinfo->{'subversion'}."\n";
	}

	if (exists $sysinfo->{'c_runtime'}) {
		print "C Runtime     : ".$sysinfo->{'c_runtime'}."\n";
	}

	if (exists $sysinfo->{'cpp_runtime'}) {
		print "C++ Runtime   : ".$sysinfo->{'cpp_runtime'}."\n";
	}

	if (exists $sysinfo->{'cpp_runtime64'}) {
		print "C++ Runtime 64: ".$sysinfo->{'cpp_runtime64'}."\n";
	}

	return 0;
}

1;

