#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/MD5Sum.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::MD5Sum;


sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::MD5Sum;
}


sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('MD5Sum', 'MD5Str');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages= (
		'Exporter'
	);

	foreach my $package (@neededPackages) {
		unless (defined
		$repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		import ("SAPDB::Install::$package"); 
	}
}


sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ "bootstrap");

	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::MD5Sum;
}

#
# main
#
sub main {
        return (SAPDB::Install::MD5Sum::Test::main (@_));
}

package SAPDB::Install::MD5Sum::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my ($filename) = @_;

	unless (defined $filename) {
		print "MD5Sum <filename>\n";
		return 0;
	}

	my $md5sum = SAPDB::Install::MD5Sum::MD5Sum ($filename);
	print $filename.": ".$md5sum."\n";

	return 0;
}

1;

