#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Exporter.pm#4 $
# $DateTime: 2004/01/15 13:25:19 $
# $Change: 62008 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::Exporter;

sub BEGIN {
        $ExportLevel = 0;
		my $repo = SAPDB::Install::Repository::GetCurrent ();
		my @neededPackages=(
			'Trace'
		);
		foreach my $package (@neededPackages){
                  if ( defined $repo){
                    unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                      print join ("\n", $repo->GetErr)."\n";
                      die;
                    }
                    SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
                  }#if
                  else {
                    eval "require SAPDB::Install::$package"; 
                    eval "SAPDB::Install::Exporter::import (\"SAPDB::Install::$package\")"; 
                  }#else
		}#foreach
}



sub import {
    my $pkg = shift;
    my $callpkg = caller ($ExportLevel);
    my ($cPack,$cScript,$cLine)=caller;
    TraceMsg("start importing symbols from $pkg into $cPack\n",4,\$DEBUG,2);			
    local @exports = @{"${pkg}::EXPORT"};
    foreach (@exports) {
		s/^(\W)// and $type = $1 or $type='&';
		TraceMsg("import symbol $type$_\n",5,\$DEBUG,2);
	    *{"${callpkg}::$_"} = 
        $type eq '&' ? \&{"${pkg}::$_"} :
        $type eq '$' ? \${"${pkg}::$_"} :
        $type eq '@' ? \@{"${pkg}::$_"} :
        $type eq '%' ? \%{"${pkg}::$_"} :
        $type eq '*' ? \*{"${pkg}::$_"} :
        undef;
    }
}

1;
