#!/usr/bin/perl
#
# $Header: //sapdb/I0000/develop/sys/src/install/perl/SAPDB/Install/BackupPipe.pm#2 $
# $DateTime: 2003/10/27 17:16:31 $
# $Change: 55304 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::BackupPipe;

my $bootstrapped=0;
sub import {
#because SDBINST
  local $SAPDB::Install::Exporter::ExportLevel = 1;
  SAPDB::Install::Exporter::import (@_);
  bootstrap SAPDB::Install::BackupPipe;
#endbecause
  #ifdef SCRIPTING
#  unless (defined $bootstrapped and $bootstrapped == 1){
#    require DynaLoader;
#    push @ISA, 'DynaLoader';
#    bootstrap SAPDB::Install::BackupPipe;
#    $bootstrapped=1;
#  }
  #endif
}
#import

sub BEGIN {
#because SDBINST
  @ISA = ('SAPDB::Install::Exporter');
  @EXPORT = ();
  my $repo = SAPDB::Install::Repository::GetCurrent ();
  my @neededPackages=(
                      'Exporter'
                     );
  foreach my $package (@neededPackages) {
    unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
      print join ("\n", $repo->GetErr)."\n";
      die;
    }
    import ("SAPDB::Install::$package"); 
  }
#endbecause
}
#BEGIN

#because SDBINST
sub AUTOLOAD {
  #print "$AUTOLOAD\n";
  die unless ($AUTOLOAD =~ "bootstrap");
  require DynaLoader;
  push @ISA, 'DynaLoader';
  bootstrap SAPDB::Install::BackupPipe;
}
#AUTOLOAD
#endbecause

1;
