#
# =====================================================
# @(#) SYSDBACOM                  7.4        2003-05-12
# =====================================================
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from installib import *

def install (session,options):
    """Installing comments for SYSDBA tables
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')


    # Table sysdba.allocatorstatistic

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.ALLOCATORSTATISTIC IS 'Old information, please use SYSINFO.MEMORYALLOCATORSTATISTICS'""")

    # Table sysdba.configuration

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.CONFIGURATION IS 'Old information, please use SYSINFO.ACTIVECONFIGURATION'""")

    # Table sysdba.datavolumes

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.DATAVOLUMES IS 'Old information, please use SYSINFO.DATAVOLUMES'""")

    # Table sysdba.dbparameters

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.DBPARAMETERS IS 'Parameters that were defined for the database instance by using the Database Manager tool'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBPARAMETERS.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBPARAMETERS.VALUE IS 'Value'""")

    # Table sysdba.dbtimes

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.DBTIMES IS 'Date and time of the last restart for the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBTIMES.RESTART_DATE IS 'Date of the last restart'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBTIMES.RESTART_TIME IS 'Time of the last restart'""")

    # Table sysdba.dual

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.DUAL IS 'Table with exactly one row and one column to allow easy queries for special values like: SELECT user FROM dual'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DUAL.DUMMY IS 'Dummy column'""")

    # Table sysdba.indexpages

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.INDEXPAGES IS 'Information about the needed number of leaf pages for indexes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.INDEXNAME IS 'Name of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.DESCRIPTION IS 'Always: Leaf  pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.CHAR_VALUE IS 'Always NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXPAGES.NUMERIC_VALUE IS 'Number of leaf pages in this index'""")

    # Table sysdba.indexstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.INDEXSTATISTICS IS 'Information about the structure and size of indexes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.INDEXNAME IS 'Name of index (NULL for unknown indexes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.COLUMNNAME IS 'Name of an inverted column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.DESCRIPTION IS 'Description of how to interpret following columns'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.CHAR_VALUE IS 'Alphanumeric value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.NUMERIC_VALUE IS 'Numeric value'""")

    # Table sysdba.lockliststatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.LOCKLISTSTATISTICS IS 'Information about the used space in the lock list'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.LOCKLISTSTATISTICS.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.LOCKLISTSTATISTICS.VALUE IS 'Value'""")

    # Table sysdba.lockstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.LOCKSTATISTICS IS 'Please see DOMAIN.LOCKS/LOCK_HOLDER/LOCK_REQUESTOR/LOCK_WAITS'""")

    # Table sysdba.messages

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MESSAGES IS 'Error messages used in the server and their message texts'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MESSAGES.MSGNO IS 'Error message'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MESSAGES.LANGUAGE IS 'Always ENG'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MESSAGES.MSGTEXT IS 'Text of the error message'""")

    # Table sysdba.monitor

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR IS 'Information about the number of used calls/used resources in the server'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR.TYPE IS 'Description of the type of the resource'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR.VALUE IS 'Value'""")

    # Table sysdba.monitor_caches

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_CACHES IS 'Information about the number of used calls/used resources in caches'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_CACHES.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_CACHES.VALUE IS 'Value'""")

    # Table sysdba.monitor_load

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_LOAD IS 'Information about the number of used calls in the server'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOAD.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOAD.VALUE IS 'Value'""")

    # Table sysdba.monitor_lock

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_LOCK IS 'Information about the number of special events in the lock list'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOCK.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOCK.VALUE IS 'Value'""")

    # Table sysdba.monitor_log

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_LOG IS 'Information about the number of special events in the log'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOG.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LOG.VALUE IS 'Value'""")

    # Table sysdba.monitor_long

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_LONG IS 'Information about the number of reads and writes for columns of datatype LONG'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LONG.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_LONG.VALUE IS 'Value'""")

    # Table sysdba.monitor_pages

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_PAGES IS 'Information about the number of physical and virtual I/Os'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_PAGES.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_PAGES.VALUE IS 'Value'""")

    # Table sysdba.monitor_row

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_ROW IS 'Information about the number of used calls in the lowest layer of the server'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_ROW.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_ROW.VALUE IS 'Value'""")

    # Table sysdba.monitor_trans

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.MONITOR_TRANS IS 'Information about the number of used SQL statements and main internal calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_TRANS.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.MONITOR_TRANS.VALUE IS 'Value'""")

    # Table sysdba.optimizerstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.OPTIMIZERSTATISTICS IS 'Stored statistics in the database catalog'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.OWNER IS 'Owner of a table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.TABLENAME IS 'Name of a table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.INDEXNAME IS 'Name of an index for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.COLUMNNAME IS 'Name of a column for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.DISTINCTVALUES IS 'Number of different values if the current row describes a column or an index with one column; otherwise the number of rows in a table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.PAGECOUNT IS 'Number of pages used by an index if the current row describes an index; number of pages of a base table if the current row describes a table; otherwise NULL'""")

    # Table sysdba.pages

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.PAGES IS 'Number of leaf pages used in a table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.DESCRIPTION IS 'Always: Leaf  pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.CHAR_VALUE IS 'Always NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.NUMERIC_VALUE IS 'Number of leaf pages used in the tree for primary data'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.PAGES.SHORT_COLUMN_PAGES IS 'Number of leaf pages used for storing short values of datatype LONG for this table'""")

    # Table sysdba.roots

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.ROOTS IS 'Information about the root page number belonging to a table, index, ...'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.TABLEID IS 'Internal identification of the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.INDEXNAME IS 'Name of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.TYPE IS 'Type of tree: table, index, ...'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.ROOT IS 'Root page number'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.ROOTS.FILE_ID IS 'ID of the database file'""")

    # Table sysdba.running_commands

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.RUNNING_COMMANDS IS 'Information about currently running statements if diagnose monitor parseid is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_COMMANDS.TASKID IS 'Identification of server task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_COMMANDS.JOB IS 'Optional information about application which uses this statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_COMMANDS.LINE IS 'Optional information about code line in application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_COMMANDS.PARSEID IS 'Internal identification of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_COMMANDS.SQL_STATEMENT IS 'Statement text of the prepared statement'""")

    # Table sysdba.running_parseids

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.RUNNING_PARSEIDS IS 'Information about currently running statements if diagnose monitor parseid is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_PARSEIDS.TASKID IS 'Identification of server task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.RUNNING_PARSEIDS.PARSEID IS 'Internal identification of prepared statement'""")

    # Table sysdba.serverdbstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SERVERDBSTATISTICS IS 'Information about the used space in the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SERVERDBSIZE IS 'Size of the database instance in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXDATAPAGENO IS 'Highest page number of the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXPERM IS 'Number of pages of the database instance that can be used for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXUSEDPAGES IS 'Maximum number of used pages for a synchronization point (restart or savepoint)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDPERM IS 'Number of pages of the database instance that are used for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDPERM IS 'Percentage of pages for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDTMP IS 'Number of pages of the database instance that are used for temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDTMP IS 'Percentage of pages for temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.UNUSED IS 'Number of unused pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUNUSED IS 'Percentage of unused pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.UPDATEDPERM IS 'Number of changed pages for permanent objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SERVERDBFULL IS '(YES|NO) Maximum fill level of the datase instance has been reached'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDBLOCKS IS 'Number of blocks on data volumes that are used by pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSIZE IS 'Size of the log range in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDLOG IS 'Number of used log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDLOG IS 'Percentage of used log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGNOTSAVED IS 'Number of unsaved log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTLOGNOTSAVED IS 'Percentage of unsaved log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSINCEBACKUP IS 'Number of written log pages since the last complete or incremental data backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSEGMENTSIZE IS 'Size of a log segment in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SAVEPOINTS IS 'Number of executed savepoints'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.CHECKPOINTS IS 'Number of executed checkpoints'""")

    # Table sysdba.spinlocks

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SPINLOCKS IS 'Old information, please use SYSINFO.SPINLOCKSTATISTICS'""")

    # Table sysdba.syscmd_analyze

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSCMD_ANALYZE IS 'Information about all prepared statements if diagnose analyze is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.JOB IS 'Optional information about application which uses this statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.LINE IS 'Optional information about code line in application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.CMDID IS 'Identification of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.LINKAGE IS 'Linkage between table rows if statement text needs more than one row'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.SQL_STATEMENT IS 'Statement text of the prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.CMDHASH IS 'Hash value of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSCMD_ANALYZE.HASHLISTPOS IS 'Position of prepared statement in hash list'""")

    # Table sysdba.sysdata_analyze

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSDATA_ANALYZE IS 'Accumulated information about resource consumption of statements if diagnose analyze collect data is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.CMDID IS 'Identification of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.SESSION IS 'ID of the database session which uses this statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.CALL_COUNT IS 'Number of executes of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.ROWS_READ IS 'Number of rows read for this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.ROWS_QUAL IS 'Number of rows qualified for this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.VIRTUAL_READS IS 'Number of virtual reads for this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.RUNTIME IS 'Average runtime of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.MIN_RUNTIME IS 'Minimum runtime of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.MAX_RUNTIME IS 'Maximum runtime of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.VWAITS IS 'Number of SQL lock waits during execution of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.VSUSPENDS IS 'Number of suspends during execution of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.PHYSICAL_IO IS 'Number of physical I/O operations'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.ROWS_FETCHED IS 'Number of rows fetched during execution of this statement in this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSDATA_ANALYZE.USERNAME IS 'Name of user connected'""")

    # Table sysdba.sysmondata

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSMONDATA IS 'Information about execution parameter of prepared statements if diagnose monitor data is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONDATA.SYSK IS 'Linkage between SYSMONITOR and SYSMONDATA table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONDATA.PARAMNO IS 'Number of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONDATA.DATA_TYPE IS 'Data type of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONDATA.DATA IS 'Parameter data'""")

    # Table sysdba.sysmonitor

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSMONITOR IS 'Information about resource consumption of statements if diagnose monitor is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.SYSK IS 'Linkage between SYSMONITOR and SYSMONDATA table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.LINKAGE IS 'Always 1'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR."PARSEID" IS 'Internal identification of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROWS_READ IS 'Number of rows read'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROWS_QUAL IS 'Number of rows qualified'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.VIRTUAL_READS IS 'Number of virtual reads'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.SUBREQUESTS IS 'Number of subrequests'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.STRATEGY IS 'Strategy or strategies used for execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.RUNTIME IS 'Runtime'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.VWAITS IS 'Number of SQL lock waits'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.VSUSPENDS IS 'Number of suspends'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.PHYSICAL_IO IS 'Number of physical I/O operations'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROWS_FETCHED IS 'Number of rows fetched'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.FETCH_CALLS IS 'Number of fetch statements'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT1 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT2 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT3 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT4 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT5 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.ROOT6 IS 'Index or base table root touched during execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.RESULT_COPIED IS 'Result table was copied physically'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.DATETIME IS 'Date and time of execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.TERMID IS 'Identification of the terminal used by the connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.USERNAME IS 'Name of user connected'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.APPL_PROCESS IS 'Identification of the connected application in the OS'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSMONITOR.APPL_NODE IS 'Hostname of the remote connected application'""")

    # Table sysdba.sysparseid

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSPARSEID IS 'Information about all prepared statements if diagnose monitor parseid is enabled'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID."PARSEID" IS 'Internal identification of prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.LINKAGE IS 'Linkage between table rows if statement text needs more than one row'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.SELECT_PARSEID IS 'ParseID of the select statement belonging to this prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.OWNER IS 'User who prepared this statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.SQL_STATEMENT IS 'Statement text of the prepared statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.JOB IS 'Optional information about application which uses this statement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSPARSEID.LINE IS 'Optional information about code line in application'""")

    # Table sysdba.sysstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSSTATISTICS IS 'Table for load and unload statistics operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.OWNER IS 'Name of owner of table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.TABLENAME IS 'Name of table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.COLUMNNAME IS 'Name of a column for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.INDEXNAME IS 'Name of index for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.PAGES IS 'Number of pages used by an index if the current row describes an index; number of pages of a base table if the current row describes a table; otherwise NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.DISTINCT_VALUES IS 'Number of different values if the current row describes a column or an index with one column; otherwise the number of rows in a table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSSTATISTICS.AVG_LIST_LEN IS 'Not used any more'""")

    # Table sysdba.sysupdstatlog

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSUPDSTATLOG IS 'Information about last running update or load statistics statements'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.TABLEID IS 'Internal identification of the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.COLUMNNAME IS 'Name of a column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.INDEXNAME IS 'Name of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.EXECUTED_AT IS 'Timestamp of start of execution of the statement doing several statistic updates'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.LOADED IS 'YES if statistic information is loaded by load statistics command otherwise NO'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.SAMPLE_PCT IS 'Percentage of the table that is read when updating statistics'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.SAMPLE_ROW IS 'Number of rows in the table that are read when updating statistics'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.EXECUTION_START IS 'Timestamp at start of execution of this statistic update'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.EXECUTION_END IS 'Timestamp at end of execution of this statistic update'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.SESSION IS 'ID of the database session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.TERMID IS 'Identification of the terminal used by the connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.PAGES_KNOWN IS 'Always NULL, not used any more'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.PAGES_FOUND IS 'Always NULL, not used any more'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATLOG.SEQNO IS 'Not used any more'""")

    # Table sysdba.sysupdstatwanted

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SYSUPDSTATWANTED IS 'Information about tables with outdated optimizer statistics'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATWANTED.OWNER IS 'Name of owner of table for which statistics is outdated'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATWANTED.TABLENAME IS 'Name of table for which statistics is outdated'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SYSUPDSTATWANTED.COLUMNNAME IS 'Name of a column for which statistics is outdated'""")

    # Table sysdba.tablestatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.TABLESTATISTICS IS 'Information about the structure and sizes of base tables'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.DESCRIPTION IS 'Description of how to interpret following columns'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.CHAR_VALUE IS 'Alphanumeric value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.NUMERIC_VALUE IS 'Numeric value'""")

    # Table sysdba.transactions

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.TRANSACTIONS IS 'Information about active transactions of of a database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.SESSION IS 'ID of the database session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.TRANSCOUNT IS 'Transaction ID'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.SUB_TRANS IS 'Number of the current subtransaction'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.WRITE_TRANS IS 'ID of the current write transaction if the transaction has made changes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.PROCESS IS 'ID of the user process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONNECTDATE IS 'Date when the session started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONNECTTIME IS 'Time when the session started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.TERMID IS 'Terminal ID'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQTIMEOUT IS 'Remaining time until REQUEST_TIMEOUT in seconds'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LASTWRITE IS 'Time elapsed since the last write request in timeout intervals'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LOCKMODE IS 'Type of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LOCKSTATE IS 'Status of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQMODE IS 'Type of lock request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQSTATE IS 'Status of lock request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONSISTENTVIEW IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.APPLPROCESS IS 'ID of the application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.APPLNODEID IS 'ID of the client host of the application process'""")

    # Table sysdba.treelocks

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.TREELOCKS IS 'Currently always results in error 100 row not found'""")

    # Table sysdba.userstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.USERSTATISTICS IS 'Information about the resource consumption of users'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.USERMODE IS 'User class'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.PERMCOUNT IS 'Pages currently used for permanent objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.TEMPCOUNT IS 'Pages currently used for temporary objects'""")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)

