/* SCCSID("@(#)verbose.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: //tools/src/freeware/gsstest/verbose.h#1 $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/


#ifndef _XX_VERBOSE_H_
#  define  _XX_VERBOSE_H_

#include <stdarg.h>

extern int    verbose_level;
extern int    there_was_output;
extern int    show_error_location;
extern int    duplicate_to_stdout;
extern int    sap_constraints_count;


typedef enum veb_class_e {
      VEB_CLASS_ERR	= (1<<0),
      VEB_CLASS_RESULT	= (1<<1),
      VEB_CLASS_OK	= (1<<2),
      VEB_CLASS_INFO	= (1<<3),
      VEB_CLASS_TEST	= (1<<4),
      VEB_CLASS_STRING	= (1<<5),
      VEB_CLASS_STATUS  = (1<<6),
      VEB_CLASS_BUG	= (1<<7),
      VEB_CLASS_TRIN    = (1<<8),
      VEB_CLASS_TROUT   = (1<<9),
      VEB_CLASS_TIMING  = (1<<10),
      VEB_CLASS_SECTION = (1<<11),
      VEB_CLASS_SAPERR  = (1<<12)
} veb_class_et;


extern void verbose_init( int enable, FILE * fp, char * filename, int quiet );
extern void set_verbose_level( int level );
extern void verbose_print( veb_class_et p_class, int p_min_level, ... );
extern void set_enter_leave_messages( char * enter_msg, char * leave_msg );
extern void checkin_message( void );
extern void checkout_message( void );


#define VERBOSE_INIT()	   verbose_init( 1, stdout, NULL, TRUE );

#define VERBOSE_BEGIN(x)	   char  * this_Call = # x ;


#undef XVEB
#define XVEB(x)  verbose_print x ;
#define V_ERR    VEB_CLASS_ERR,  2, this_File, (Uint) (__LI ## NE__)
#define V_TEST	 VEB_CLASS_TEST, 2
#define V_STATUS VEB_CLASS_STATUS, 2
#define V_RESULT VEB_CLASS_RESULT
#define V_INFO   VEB_CLASS_INFO
#define V_STRING VEB_CLASS_STRING
#define V_OK     VEB_CLASS_OK
#define V_SHOW	 VEB_CLASS_OK, 2
#define V_HIDE	 VEB_CLASS_OK, verbose_level
#define V_BUG	 VEB_CLASS_BUG, 2
#define V_TRIN   VEB_CLASS_TRIN, 2
#define V_TROUT  VEB_CLASS_TROUT, 2
#define V_TIME	 VEB_CLASS_TIMING, 2
#define V_SEC    VEB_CLASS_SECTION
#define V_SAP    VEB_CLASS_SAPERR, (int)(options.sap_constraints!=0)


#define VERBOSE_DUPMEM( srcptr, srclen, dstptr, dstlen ) \
	 dstptr = verbose_dupmem( __FI ## LE__, __LI ## NE__, (srcptr), (srclen), &(dstlen) );

void * verbose_dupmem( char * module_name, Uint line_of_code,
		       void * orig_ptr, size_t orig_len,  size_t * new_len );

void verbose_freemem( void ** ptr, size_t * len );

#endif /* _XX_VERBOSE_H_ */
