/* SCCSID("@(#)platform.h  %E%   SAP   %I%") */

/************************************************************************/
/* $Id: //tools/src/freeware/gsstest/platform.h#5 $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/



#ifndef _XX_PLATFORM_H_
#  define _XX_PLATFORM_H_


#ifndef USHRT_MAX
#  include <limits.h>
#endif


#if USHRT_MAX >= 0x10000ul
#  define XX_SIZEOF_USHORT    4
#  error cannot handle   unsigned short > 2 bytes 
#else
#  define XX_SIZEOF_USHORT    2
#endif

#if UINT_MAX >= 0x10000ul
#  define XX_SIZEOF_UINT      4
#else
#  define XX_SIZEOF_UINT      2
#endif

#if ULONG_MAX > 0xFFFFFFFFul
#  define XX_SIZEOF_ULONG     8
#else
#  define XX_SIZEOF_ULONG     4
#endif


#if    (XX_SIZEOF_UINT   == 4)

  typedef unsigned int    Uint32;
  typedef int             Sint32;

#elif  (XX_SIZEOF_ULONG  == 4)

  typedef unsigned long   Uint32;
  typedef          long   Sint32;

#elif  (XX_SIZEOF_USHORT == 4)

  typedef unsigned short  Uint32;
  typedef          short  Sint32;

#endif



struct sys_platform_s {
   char    os_name[64];
   char    os_release[64];
   char    os_hardware[64];
   char    hostname[64];
   char    user[32];
   int     speed_indicator;
};


/* try to recognize platforms ... */

#if defined(_WINDOWS) || defined(_WIN32)

#  define LRTIMER_WIN_FTIME	 1
#  define HRTIMER_WIN32_QueryPerformanceCounter  1
#  define RTLINK_WINDOWS_LOADLIBRARY
#  define SHLIB_PREFIX           ""
#  define SHLIB_EXTENSION        ".dll"
#  define SHLIB_SEARCHPATH       "PATH"
#  define SHLIB_TERM             "DLL"
#  define SHLIB_LOADCALL         "LoadLibrary"
#  define HAVE_DOSWIN_SYSTEM     1

#  define SYS_GET_OSNAME(x)	 win_osname(x)
#  define SYS_GET_OSRELEASE(x)	 win_osrelease(x)
#  define SYS_GET_OSHARDWARE(x)	 win_hardware(x)
#  define SYS_GET_USERNAME(x)	 win_username(x)
#  define SYS_GET_HOSTNAME(x)	 win_computername(x)

#  if defined(_M_IX86)
#    define OS_CPU               "Intel x86/IA32"
#  elif defined(_M_MRX000)
#    define OS_CPU               "MIPS"
#  elif defined(_M_ALPHA)
#    define OS_CPU               "Alpha"
#  elif defined(_M_PPC)
#    define OS_CPU               "Motorola PPC"
#  elif defined(_M_IA64)
#    define OS_CPU               "Itanium/IA64"
#  elif defined(_M_AMD64)
#    define OS_CPU		 "AMD64/x86_64/x64"
#  else
#    define OS_CPU               "??"
#  endif
#  if defined(_WIN64)
#    define OS_PLATFORM          "Microsoft Win64 (XP-64/W2K3) " OS_CPU
#  else
#    define OS_PLATFORM          "Microsoft Win32 (9x->W2K3) " OS_CPU
#  endif


#elif defined(_AIX)

   /* AIX 3.2.x, 4.x.x and 5.x.x  32-bit and 64-bit */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1

   /* we need _POSIX_SOURCE and _ALL_SOURCE on AIX 3.2.5 ... */
#  include <sys/types.h>

   /* would somebody please shoot them for making the return value */
   /* from load() different from the input to unload() !           */
#  include <sys/ldr.h>

   /* would you believe it, they have implemented dlopen() in AIX 4.2 */
#  ifdef L_LOADMEMBER
#    define RTLINK_UNIX_DLOPEN	 1
#    define DLOPEN_FLAGS	 (RTLD_NOW|RTLD_MEMBER)
#    define SHLIB_TERM		 "shared library"
#  else
#    define RTLINK_AIX_LOAD	 1
#    define SHLIB_TERM		 "shared object"
#  endif

#  define SHLIB_PREFIX           "lib"
#  define SHLIB_EXTENSION        ".o"
#  define SHLIB_SEARCHPATH       "LIBPATH"

#  define SYS_GET_OSRELEASE(x)   sys_popen( "/usr/bin/oslevel", (x)->os_release,  sizeof((x)->os_release)  )
#  define SYS_GET_OSHARDWARE(x)  sys_popen( "./aix-model",      (x)->os_hardware, sizeof((x)->os_hardware) )

#  ifdef __64BIT__
#    define OS_PLATFORM         "IBM AIX  64-bit"
#  else
#    define OS_PLATFORM         "IBM AIX  32-bit"
#  endif


#elif defined(__osf__) && defined(__alpha)

   /* Digital UNIX (aka DEC OSF/1) on Alpha */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_OSFALPHA_PCC   1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_LAZY)
#  define SHLIB_PREFIX           "lib"
#  define SHLIB_EXTENSION        ".so"
#  define SHLIB_SEARCHPATH       "LD_LIBRARY_PATH"
#  define SHLIB_TERM             "shared library"
#  define SHLIB_LOADCALL         "dlopen"

#  define OS_PLATFORM            "Digital Unix / Compaq Tru64"

extern int alpha_cpu_speed;

#  define SYS_GET_OSHARDWARE(x)  sprintf( (x)->os_hardware, "Alpha (%d Mhz)", alpha_cpu_speed );


#elif defined(__sun) && defined(__unix) && defined(__SVR4)

   /* SUN Solaris 2.x */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS           (RTLD_LAZY)
#  define SHLIB_PREFIX           "lib"
#  define SHLIB_EXTENSION        ".so"
#  define SHLIB_SEARCHPATH       "LD_LIBRARY_PATH"
#  define SHLIB_TERM             "shared library"
#  define SHLIB_LOADCALL         "dlopen"
#  define SOLARIS_HARDWARE_QUERY 1

   int sys_solaris_oshardware( struct sys_platform_s * p_pls );

#  define SYS_GET_OSHARDWARE(x)  sys_solaris_oshardware(x)

#  ifdef __sparc
#    ifdef _LP64
#      define OS_CPU		"Sparc  64-bit"
#    else
#      define OS_CPU		"Sparc  32-bit"
#    endif
#  elif defined(__x86_64)
#      define OS_CPU		"x86_64/x64  64-bit"
#  elif defined(__i386)
#      define OS_CPU		"x86  32-bit"
#  else
#      error Unknown Solaris/SunOS  OS_CPU
#  endif
#  define OS_PLATFORM         "Sun Solaris/SunOS  " OS_CPU


#elif defined(linux)

   /* Linux  any.any */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_LAZY)
#  define SHLIB_PREFIX           "lib"
#  define SHLIB_EXTENSION        ".so"
#  define SHLIB_SEARCHPATH       "LD_LIBRARY_PATH"
#  define SHLIB_TERM             "shared library"
#  define SHLIB_LOADCALL         "dlopen"

#  if defined(__i386__)
#    define OS_CPU               "Intel x86  32-bit"
#  elif defined(__s390x__)
#    define OS_CPU               "S/390  64-bit"
#  elif defined(__s390__)
#    define OS_CPU               "S/390  32-bit"
#  elif defined(__ia64__)
#    define OS_CPU               "Itanium/IA64  64-bit"
#  elif defined(__PPC64__)
#    define OS_CPU		 "PowerPC 64-bit"
#  elif defined(__PPC__)
#    define OS_CPU		 "PowerPC 32-bit"
#  elif defined(__x86_64__)
#    define OS_CPU		 "x86_64/x64 64-bit"
#  else
#    define OS_CPU               "??"
#  endif
#  define OS_PLATFORM            "Linux on " OS_CPU


#elif (defined(unix) || defined(__SNI_TARG_UNIX)) && defined(sinix)

   /* Siemens-Nixdorf SVR4  5.43 */
   /* Fujitsu-Siemens Reliant Unix 5.44, 5.45 */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_SINIX_COUNTER  1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_LAZY)
#  define SHLIB_PREFIX           "lib"
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_SEARCHPATH       "LD_LIBRARY_PATH"
#  define SHLIB_TERM             "shared library"
#  define SHLIB_LOADCALL         "dlopen"

#  ifdef _LP64
#    define OS_PLATFORM          "Fujitsu-Siemens SINIX/Reliant Unix  64-bit"
#  else
#    define OS_PLATFORM          "Fujitsu-Siemens SINIX/Reliant Unix  32-bit"
#  endif


#elif defined(__hpux) || defined(hpux)

  /* HP-UX 9.x, 10.x, 11.x 32-bit and 11.x 64-bit               */      
  /* should work for PA-Risc   9000/700 and 9000/800  machines  */
  /* HP-UX 11 on ia64 (Itanium) uses shared lib extension ".so" */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  ifdef __LP64__
#    define RTLINK_UNIX_DLOPEN   1
#    define DLOPEN_FLAGS         (RTLD_LAZY)
#    define SHLIB_SEARCHPATH     "LD_LIBRARY_PATH"
#    define SHLIB_LOADCALL       "dlopen"
#    if defined(__hppa)
#      define OS_PLATFORM        "HP HP-UX  PA-RISC  64-bit"
#      define SHLIB_EXTENSION	 ".sl"
#    elif defined(__ia64)
#      define OS_PLATFORM        "HP HP-UX  IA64  64-bit"
#      define SHLIB_EXTENSION	 ".so"
#    else
#      define OS_PLATFORM        "HP HP-UX  64-bit"
#      define SHLIB_EXTENSION	 ".so"
#    endif
#  else
#    define RTLINK_HPUX_SHLOAD   1
#    define SHLIB_SEARCHPATH     "SHLIB_PATH"
#    define SHLIB_LOADCALL       "shl_load"
#    if defined(__hppa)
#      define OS_PLATFORM        "HP HP-UX  PA-RISC  32-bit"
#      define SHLIB_EXTENSION	 ".sl"
#    elif defined(__ia64)
#      define OS_PLATFORM        "HP HP-UX  IA64  32-bit"
#      define SHLIB_EXTENSION	 ".so"
#    else
#      define OS_PLATFORM        "HP HP-UX  32-bit"
#      define SHLIB_EXTENSION	 ".so"
#    endif
#  endif
#  define SHLIB_PREFIX           "lib"
#  define SHLIB_TERM		 "shared library"

#  define SYS_GET_OSHARDWARE(x)  sys_popen( "/usr/bin/model", (x)->os_hardware, sizeof((x)->os_hardware) )


#elif defined(_MACINTOSH)

  /* Apple MacIntosh with CFM Shared Libraries */
#  define RTLINK_APPLE_MAC	 1
#  define SHLIB_PREFIX           ""
#  define SHLIB_EXTENSION	 ""
#  define SHLIB_SEARCHPATH	 ""
#  define SHLIB_TERM		 "CFM shared library"
#  define SHLIB_LOADCALL	 "GetSharedLibrary"

#  define OS_PLATFORM            "Apple MacIntosh"

#  error Incomplete configuration -- I still need to try MACs 


#elif defined(_OPEN_SYS)

   /* IBM OS/390  POSIX SYSTEM */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_OS390		 1
#  define SHLIB_PREFIX           "lib"
   /* SAPonOS390 changed to XPLINK function passing through registers  */
   /* starting with 640 on OS/390 12.00 and changed the shared library */
   /* filename extension from ".dll" --> ".so" along with it           */
#  if defined(__XPLINK__)
#    define OS_P_XPL		" XPLINK"
#    if defined(_ENHANCED_ASCII_EXT)
#      define OS_P_NASC         " NASCII"
#      pragma runopts(FILETAG(AUTOCVT,AUTOTAG))
#      pragma runopts(ENVAR("_BPXK_AUTOCVT=ON"))
#      pragma runopts(ENVAR("_EDC_PUTENV_COPY=YES"))
#      define SHLIB_EXTENSION	 ".so"
#    else
#      define OS_P_NASC
#    endif
#    ifndef SHLIB_EXTENSION
#      define SHLIB_EXTENSION    ".dll"
#    endif
#  else
#    define OS_P_NASC
#    define OS_P_XPL
#    define SHLIB_EXTENSION	 ".dll"
#  endif
#  define SHLIB_SEARCHPATH       "LIBPATH"
#  define SHLIB_TERM		 "shared library"
#  define SHLIB_LOADCALL         "dllload"

#  ifdef _LP64
#    define OS_PLATFORM            "IBM OS/390-OE (Posix) 64-bit" OS_P_XPL OS_P_NASC
#  else
#    define OS_PLATFORM            "IBM OS/390-OE (Posix) 31-bit" OS_P_XPL OS_P_NASC
#  endif


#elif defined(__OS400__)

   /* IBM OS/400 EBCDIC */
#  define LRTIMER_GETTIMEOFDAY   1
#  define HRTIMER_GETTIMEOFDAY   1
#  define RTLINK_OS400           1
#  define SHLIB_PREFIX           ""
#  define SHLIB_EXTENSION        ""
#  define SHLIB_SEARCHPATH       "*LIBL" /* Current Library List */
#  define SHLIB_TERM		 "SRVPGM (shared library)"
#  define SHLIB_LOADCALL         "QleActBndPgm"

#  define OS_PLATFORM            "IBM OS/400"

#  define HAVE_UNISTD_H		 1
#  define HAVE_PWD_H		 1
 
#  define SYS_PLATFORM_OS400     1
#  define SYS_GET_OSNAME(x)	 sys_os400_osname(x)
#  define SYS_GET_OSRELEASE(x)	 sys_os400_osrelease(x)
#  define SYS_GET_OSHARDWARE(x)	 sys_os400_hardware(x)
#  define HAVE_POSIX_GETPWUID    1
#  define SYS_GET_USERNAME(x)	 sys_posix_getpwuid(x)
#  define HAVE_BSD_GETHOSTNAME   1
#  define SYS_GET_HOSTNAME(x)	 sys_bsd_gethostname(x)


#elif defined(__OS2__) /* MISSING: need correct preprocessor symbol here ! */

#  define RTLINK_OS2		 1
#  define SHLIB_PREFIX           ""
#  define SHLIB_EXTENSION	 ".DLL"
#  define SHLIB_SEARCHPATH       "LIBPATH"
#  define SHLIB_TERM		 "DLL"
#  define SHLIB_LOADCALL         "DosQueryModuleHandle"

#  define OS_PLATFORM            "IBM OS/2"

#  error Incomplete configuration -- I still need to try OS/2

#else

#  error This Platform is not recognized (yet).  Please insert your definitions into this tree

#endif



/* common Unix definitions ... */
#if defined(unix) || defined(UNIX)

#  define HAVE_UNISTD_H		1
#  define HAVE_PWD_H		1
#  define HAVE_UID_T		1
#  define HAVE_SYS_WAIT_H	1
#  define HAVE_POSIX_SYSTEM     1

#  ifndef SYS_GET_OSHARDWARE
#    define SYS_GET_OSHARDWARE(x)   sys_uts_oshardware(x)
#  endif

#  ifndef SYS_GET_OSRELEASE
#    define SYS_GET_OSRELEASE(x)    sys_uts_osrelease(x)
#  endif

#  ifndef SYS_GET_OSNAME
#    define SYS_GET_OSNAME(x)	    sys_uts_osname(x)
#  endif

#  ifndef SYS_GET_USERNAME
#    define HAVE_POSIX_GETPWUID   1
#    define SYS_GET_USERNAME(x)	    sys_posix_getpwuid(x)
#  endif

#  ifndef SYS_GET_HOSTNAME
#    define HAVE_BSD_GETHOSTNAME  1
#    define SYS_GET_HOSTNAME(x)	    sys_bsd_gethostname(x)
#  endif

#endif /* !UNIX  &&  !unix */



/*
 * Define DLL_FUNC_DECO, DLL_DATA_DECO, FUNCPTR_DECO and FAR
 */

#if defined(_WIN32)
#  if !defined(WINAPI)
#    if !defined(_M_IX86)
#	include <windows.h>
#    else
#       /* shortcutting Microsoft Win32 on Intel x86i, because including */
#       /* <windows.h> is painfully timeconsuming during development ... */
#       define WINAPI		__stdcall
#    endif
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__declspec(dllexport) WINAPI
#  define EXPORT_DATA		__declspec(dllexport)
#  define IMPORT_FUNCTION       __declspec(dllimport) WINAPI
#  define IMPORT_DATA		__declspec(dllimport)
#elif defined(_WINDOWS)
#  if !defined(WINAPI)
#    define WINAPI		__far __pascal
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__export WINAPI
#  define EXPORT_DATA		__export
#  define IMPORT_FUNCTION	__export WINAPI
#  define IMPORT_DATA		__export
#  define FAR			__far
#else
#  define EXPORT_FUNCTION
#  define EXPORT_DATA
#  define IMPORT_FUNCTION
#  define IMPORT_DATA
#  define FUNCPTR_DECO
#endif

#ifdef BUILDING_DLL
#  define DLL_DATA_DECO	      EXPORT_DATA
#  define DLL_FUNC_DECO	      EXPORT_FUNCTION
#else
#  define DLL_DATA_DECO	      IMPORT_DATA
#  define DLL_FUNC_DECO	      IMPORT_FUNCTION
#endif

#ifndef FAR
#  define FAR
#endif



#endif /* _XX_PLATFORM_H_ */
