#include "mysccs.h"
SCCSID("@(#)debug.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: //tools/src/freeware/gsstest/debug.c#1 $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/


#ifdef XDEBUG

#include "common.h"
#include "debug.h"

/* global variables */
int      debug_global_flag  = FALSE;

/* local variables */
static FILE  * dfp                     = NULL;
static int     debug_initialized       = FALSE;


void
debug_init( int p_enable, FILE * p_fp, char * p_filename )
{

   debug_initialized       = TRUE;
   debug_global_flag       = (p_enable==FALSE) ? FALSE : TRUE;

   if ( debug_global_flag==TRUE ) {

      fprintf(stderr, "Sending debug output to ");

      if ( p_fp==NULL || p_fp==stderr ) {

	 dfp = stderr;
	 fprintf(stderr, "STDERR\n");

      } else if ( p_fp==stdout ) {

	 dfp = stdout;
	 fprintf(stderr, "STDOUT\n");

      } else {

	 dfp = p_fp;
	 fprintf(stderr, "file \"%.200s\"\n", p_filename);

      }

   } else { /* debug_global_flag==TRUE */

      dfp = stderr;

   }


   return;

} /* debug_init() */




void
debug_print( dbg_class_et p_class, ... )
{
   va_list    args;
   char     * label;
   char     * fmt1 = NULL;
   char	    * fmt2 = NULL;

   if ( dfp==NULL ) {
      fprintf(stderr, "WAAA! I don't have a valid FILE * for debugging!\n");
      abort();
   }

   if ( debug_global_flag==FALSE
	&&  p_class != DBG_CLASS_ERR ) {
      return;
   }

   switch( p_class ) {
      case DBG_CLASS_ERR:    fmt1 = "ERROR in %.60s(): ";	   break;
      case DBG_CLASS_ARG:    fmt1 = "->> %.60s(\n";		   break;
      case DBG_CLASS_RET:    fmt1 = "<<- %.60s() ";	    	   break;

      case DBG_CLASS_STRING: fmt2 = "\t%.50s =\"%.150s\"\n";	   break;

      case DBG_CLASS_ARGV:   break;
      case DBG_CLASS_INFO:   fprintf(dfp, "*INFO* ");		   break;
      default:		     break;
   
   }

   va_start(args, p_class);

   if ( fmt1!=NULL ) {
      label = va_arg( args, char * );
      fprintf( dfp, fmt1, label );
   }

   if ( fmt2==NULL ) {
      fmt2 = va_arg( args, char * );
   }

   vfprintf(dfp, fmt2, args);

   va_end(args);



   switch( p_class ) {
      case DBG_CLASS_RET:  fprintf(dfp, "----------\n");
			   break;

      default:		   break;

   }

   fflush(dfp);

   return;

} /* debug_print() */


#endif /* !XDEBUG */

