/* SCCSID("@(#)platform.h  %E%   SAP   %I%") */

/************************************************************************/
/* $Id: //tools/src/freeware/gsstest/platform.h#4 $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/



#ifndef _XX_PLATFORM_H_
#  define _XX_PLATFORM_H_


#ifndef USHRT_MAX
#  include <limits.h>
#endif


#if USHRT_MAX >= 0x10000ul
#  define XX_SIZEOF_USHORT    4
#  error cannot handle   unsigned short > 2 bytes 
#else
#  define XX_SIZEOF_USHORT    2
#endif

#if UINT_MAX >= 0x10000ul
#  define XX_SIZEOF_UINT      4
#else
#  define XX_SIZEOF_UINT      2
#endif

#if ULONG_MAX > 0xFFFFFFFFul
#  define XX_SIZEOF_ULONG     8
#else
#  define XX_SIZEOF_ULONG     4
#endif


#if    (XX_SIZEOF_UINT   == 4)

  typedef unsigned int    Uint32;

#elif  (XX_SIZEOF_ULONG  == 4)

  typedef unsigned long   Uint32;

#elif  (XX_SIZEOF_USHORT == 4)

  typedef unsigned short  Uint32;

#endif



struct sys_platform_s {
   char    os_name[64];
   char    os_release[64];
   char    os_hardware[64];
   char    hostname[64];
   char    user[32];
   int     speed_indicator;
};


/* try to recognize platforms ... */

#if defined(_WINDOWS) || defined(_WIN32)

#  define LRTIMER_WIN_FTIME	 1
#  define HRTIMER_WIN32_QueryPerformanceCounter  1
#  define RTLINK_WINDOWS_LOADLIBRARY
#  define SHLIB_EXTENSION	 ".dll"
#  define SHLIB_TERM		 "DLL"
#  define HAVE_DOSWIN_SYSTEM	 1

#  define SYS_GET_OSNAME(x)	 win_osname(x)
#  define SYS_GET_OSRELEASE(x)	 win_osrelease(x)
#  define SYS_GET_OSHARDWARE(x)	 win_hardware(x)
#  define SYS_GET_USERNAME(x)	 win_username(x)
#  define SYS_GET_HOSTNAME(x)	 win_computername(x)


#elif defined(_AIX)

   /* AIX 3.2.x or 4.x.x */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1

   /* we need _POSIX_SOURCE and _ALL_SOURCE on AIX 3.2.5 ... */
#  include <sys/types.h>

   /* would somebody please shoot them for making the return value */
   /* from load() different from the input to unload() !           */
#  include <sys/ldr.h>

   /* would you believe it, they have implemented dlopen() in AIX 4.2 */
#  ifdef L_LOADMEMBER
#    define RTLINK_UNIX_DLOPEN	 1
#    define DLOPEN_FLAGS	 (RTLD_NOW|RTLD_MEMBER)
#    define SHLIB_EXTENSION	 ".so"
#    define SHLIB_TERM		 "shared library"
#  else
#    define RTLINK_AIX_LOAD	 1
#    define SHLIB_EXTENSION	 ".o"
#    define SHLIB_TERM		 "shared object"
#  endif

#  define SYS_GET_OSRELEASE(x)   sys_popen( "/usr/bin/oslevel", (x)->os_release,  sizeof((x)->os_release)  )
#  define SYS_GET_OSHARDWARE(x)  sys_popen( "./aix-model",      (x)->os_hardware, sizeof((x)->os_hardware) )


#elif defined(__osf__) && defined(__alpha)

   /* Digital UNIX (aka DEC OSF/1) on Alpha */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_OSFALPHA_PCC   1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"

extern int alpha_cpu_speed;

#  define SYS_GET_OSHARDWARE(x)  sprintf( (x)->os_hardware, "Alpha (%d Mhz)", alpha_cpu_speed );


#elif defined(__sun) && defined(__unix) && defined(__SVR4)

   /* SUN Solaris 2.x */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"
#  define SOLARIS_HARDWARE_QUERY 1

   int sys_solaris_oshardware( struct sys_platform_s * p_pls );

#  define SYS_GET_OSHARDWARE(x)  sys_solaris_oshardware(x)


#elif defined(linux)

   /* Linux  any.any */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"


#elif (defined(unix) || defined(__SNI_TARG_UNIX)) && defined(sinix)

   /* Siemens-Nixdorf SVR4  5.43 */
   /* Fujitsu-Siemens Reliant Unix 5.44, 5.45 */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_SINIX_COUNTER  1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"


#elif defined(__hpux) || defined(hpux)

  /* HP-UX 9.x and 10.x					        */
  /* should work for PA-Risc   9000/700 and 9000/800  machines  */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_HPUX_SHLOAD	 1
#  define SHLIB_EXTENSION	 ".sl"
#  define SHLIB_TERM		 "shared library"

#  define SYS_GET_OSHARDWARE(x)  sys_popen( "/usr/bin/model", (x)->os_hardware, sizeof((x)->os_hardware) )


#elif defined(_MACINTOSH)

  /* Apple MacIntosh with CFM Shared Libraries */
#  define RTLINK_APPLE_MAC	 1
#  define SHLIB_EXTENSION	 ""
#  define SHLIB_TERM		 "CFM shared library"

#  error Incomplete configuration -- I still need to try MACs 


#elif defined(_OPEN_SYS)

   /* IBM OS/390  POSIX SYSTEM */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_OS390		 1
#  define SHLIB_EXTENSION	 ".dll"
#  define SHLIB_TERM		 "shared library"


#elif defined(__OS400__) /* MISSING: need correct prepocessor symbol here */

   /* IBM OS/400 EBCDIC */
#  define LRTIMER_GETTIMEOFDAY  1
#  define HRTIMER_GETTIMEOFDAY  1
#  define RTLINK_OS400		1
#  define SHLIB_EXTENSION	"*SRVPGM"
#  define SHLIB_TERM		"shared library"

#  define SYS_PLATFORM_OS400    1
#  define SYS_GET_OSNAME(x)	sys_os400_osname(x)
#  define SYS_GET_OSRELEASE(x)	sys_os400_osrelease(x)
#  define SYS_GET_OSHARDWARE(x)	sys_os400_hardware(x)
#  define SYS_GET_USERNAME(x)	sys_os400_username(x)
#  define SYS_GET_HOSTNAME(x)	sys_os400_hostname(x)


#elif defined(__OS2__) /* MISSING: need correct preprocessor symbol here ! */

#  define RTLINK_OS2		 1
#  define SHLIB_EXTENSION	 ".DLL"
#  define SHLIB_TERM		 "DLL"

#  error Incomplete configuration -- I still need to try OS/2


#else

#  error This Platform is not recognized (yet).  Please insert your definitions into this tree

#endif



/* common Unix definitions ... */
#if defined(unix) || defined(UNIX)

#  define HAVE_UNISTD_H
#  define HAVE_PWD_H
#  define HAVE_UID_T
#  define HAVE_SYS_WAIT_H
#  define HAVE_POSIX_SYSTEM  1

#  ifndef SYS_GET_OSHARDWARE
#    define SYS_GET_OSHARDWARE(x)   sys_uts_oshardware(x)
#  endif

#  ifndef SYS_GET_OSRELEASE
#    define SYS_GET_OSRELEASE(x)    sys_uts_osrelease(x)
#  endif

#  ifndef SYS_GET_OSNAME
#    define SYS_GET_OSNAME(x)	    sys_uts_osname(x)
#  endif

#  ifndef SYS_GET_USERNAME
#    define SYS_GET_USERNAME(x)	    sys_getpwuid(x)
#  endif

#  ifndef SYS_GET_HOSTNAME
#    define SYS_GET_HOSTNAME(x)	    sys_gethostname(x)
#  endif

#endif /* !UNIX  &&  !unix */



/*
 * Define DLL_FUNC_DECO, DLL_DATA_DECO, FUNCPTR_DECO and FAR
 */

#if defined(_WIN32)
#  if !defined(WINAPI)
#    if !defined(_M_IX86)
#	include <windows.h>
#    else
#       /* shortcutting Microsoft Win32 on Intel x86i, because including */
#       /* <windows.h> is painfully timeconsuming during development ... */
#       define WINAPI		__stdcall
#    endif
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__declspec(dllexport) WINAPI
#  define EXPORT_DATA		__declspec(dllexport)
#  define IMPORT_FUNCTION       __declspec(dllimport) WINAPI
#  define IMPORT_DATA		__declspec(dllimport)
#elif defined(_WINDOWS)
#  if !defined(WINAPI)
#    define WINAPI		__far __pascal
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__export WINAPI
#  define EXPORT_DATA		__export
#  define IMPORT_FUNCTION	__export WINAPI
#  define IMPORT_DATA		__export
#  define FAR			__far
#else
#  define EXPORT_FUNCTION
#  define EXPORT_DATA
#  define IMPORT_FUNCTION
#  define IMPORT_DATA
#  define FUNCPTR_DECO
#endif

#ifdef BUILDING_DLL
#  define DLL_DATA_DECO	      EXPORT_DATA
#  define DLL_FUNC_DECO	      EXPORT_FUNCTION
#else
#  define DLL_DATA_DECO	      IMPORT_DATA
#  define DLL_FUNC_DECO	      IMPORT_FUNCTION
#endif

#ifndef FAR
#  define FAR
#endif



#endif /* _XX_PLATFORM_H_ */
