#include "mysccs.h"
SCCSID("@(#)link_lib.c   %E%   SAP   %I%")

/************************************************************************/
/* $Id: //tools/src/freeware/gsstest/link_lib.c#1 $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#include "gsstest.h"
#include "rtlink.h"
#include "sncgss.h"

int dll_dynamic_linking = FALSE;

/*********************************************************************/
/* There are some (Unix) platforms where debugging problems within   */
/* a shared library is "somewhat" difficult.  For convenience, this  */
/* stub allows static instead of dynamic linking ...                 */
/*								     */
/* To use it, put link_lib$(OBJ) instead of load_dll$(OBJ) into the  */
/* gsstest$(EXE) executable and add the (static) gssapi library to   */
/* the library list.						     */
/*********************************************************************/
static char   * dll_name = "statically linked gssapi library";


int
dll_load_gssapi( int            p_trclevel,
		 char         * p_libname,
		 DLL_GSSFP_T  * p_gssfp )
{
   size_t      len;

   if ( p_gssfp==NULL )
      return(RTLERR_INVALID_HANDLE);

   XVEB((V_OK, p_trclevel, "GSS-API library was statically linked ... \n\n" ));

   memset( p_gssfp, 0, sizeof(*p_gssfp) );

   (p_gssfp->dll_handle)			= 0;

   (p_gssfp->gss_acquire_cred)			= gss_acquire_cred;
   (p_gssfp->gss_release_cred)			= gss_release_cred;
   (p_gssfp->gss_init_sec_context)		= gss_init_sec_context;
   (p_gssfp->gss_accept_sec_context)		= gss_accept_sec_context;
   (p_gssfp->gss_process_context_token)		= gss_process_context_token;
   (p_gssfp->gss_delete_sec_context)		= gss_delete_sec_context;
   (p_gssfp->gss_context_time)			= gss_context_time;
   (p_gssfp->gss_get_mic)			= gss_get_mic;
   (p_gssfp->gss_verify_mic)			= gss_verify_mic;
   (p_gssfp->gss_wrap)				= gss_wrap;
   (p_gssfp->gss_unwrap)			= gss_unwrap;
   (p_gssfp->gss_display_status)		= gss_display_status;
   (p_gssfp->gss_indicate_mechs)		= gss_indicate_mechs;
   (p_gssfp->gss_compare_name)			= gss_compare_name;
   (p_gssfp->gss_display_name)			= gss_display_name;
   (p_gssfp->gss_import_name)			= gss_import_name;
   (p_gssfp->gss_release_name)			= gss_release_name;
   (p_gssfp->gss_release_buffer)		= gss_release_buffer;
   (p_gssfp->gss_release_oid_set)		= gss_release_oid_set;
   (p_gssfp->gss_inquire_cred)			= gss_inquire_cred;
   (p_gssfp->gss_add_cred)			= gss_add_cred;
   (p_gssfp->gss_inquire_cred_by_mech)		= gss_inquire_cred_by_mech;
   (p_gssfp->gss_inquire_context)		= gss_inquire_context;
   (p_gssfp->gss_wrap_size_limit)		= gss_wrap_size_limit;
   (p_gssfp->gss_export_sec_context)		= gss_export_sec_context;
   (p_gssfp->gss_import_sec_context)		= gss_import_sec_context;
   (p_gssfp->gss_create_empty_oid_set)		= gss_create_empty_oid_set;
   (p_gssfp->gss_add_oid_set_member)		= gss_add_oid_set_member;
   (p_gssfp->gss_test_oid_set_member)		= gss_test_oid_set_member;
   (p_gssfp->gss_inquire_names_for_mech)	= gss_inquire_names_for_mech;
   (p_gssfp->gss_inquire_mechs_for_name)	= gss_inquire_mechs_for_name;
   (p_gssfp->gss_canonicalize_name)		= gss_canonicalize_name;
   (p_gssfp->gss_export_name)			= gss_export_name;
   (p_gssfp->gss_duplicate_name)		= gss_duplicate_name;
   (p_gssfp->gss_last_func)			= (GSS_VOID_FUNC_T *)0;

   (p_gssfp->flags)				= (GSS_DL_V1|GSS_DL_V2|GSS_DL_REQ|GSS_DL_NEED|GSS_DL_OPT);
   (p_gssfp->mech_set)				= GSS_C_NO_OID_SET;
   (p_gssfp->mech)				= GSS_C_NO_OID;
   (p_gssfp->context_transfer_calls)		= TRUE;
   (p_gssfp->canonical_names_calls)		= TRUE;

   len = strlen(dll_name);
   p_gssfp->dll_name = malloc( len+1 );
   if ( p_gssfp->dll_name!=NULL ) {
      memcpy( p_gssfp->dll_name, dll_name, len+1 );
   }

   XVEB((V_OK, p_trclevel-1, "\n"));

   return(0);

} /* dll_load_gssapi() */



/*
 * dll_unload_gssapi()
 *
 *
 */
int
dll_unload_gssapi( int    p_trclevel,  DLL_GSSFP_T  * p_gssfp )
{
   /* Now this is easy to emulate :-)   */
   UNUSED_PARAMETER(p_trclevel);
   
   if ( p_gssfp!=NULL ) {

      release_name( p_gssfp, &(p_gssfp->ini_name) );
      release_name( p_gssfp, &(p_gssfp->acc_name) );

      verbose_freemem( (void **) &(p_gssfp->initiator), &(p_gssfp->initiator_len) );
      verbose_freemem( (void **) &(p_gssfp->acceptor),  &(p_gssfp->acceptor_len)  );
      verbose_freemem( (void **) &(p_gssfp->def_acc),   &(p_gssfp->def_acc_len)   );
      verbose_freemem( (void **) &(p_gssfp->can_acc),   &(p_gssfp->can_acc_len)   );

      if ( p_gssfp->dll_name!=NULL ) {
	 free( p_gssfp->dll_name );
	 (p_gssfp->dll_name) = NULL;
      }

      memset( p_gssfp, 0, sizeof(*p_gssfp) );

   }

   return(0);

} /* dll_unload_gssapi() */

