#include "mysccs.h"
SCCSID("@(#)non_ansi.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: non_ansi.c,v 1.6 2000/07/26 14:41:49 d019080 Exp $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/



#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "non_ansi.h"




/*
 * Strcaseicmp()
 *
 * Case independent string compare
 *
 */
int
Strcaseicmp( const char *s1, const char *s2 )
{
   const unsigned char  * a  = (const unsigned char *) s1;
   const unsigned char  * b  = (const unsigned char *) s2;
   int                    c1 = 0;
   int                    c2 = 0;

   if ( a==b )
      return(0);

   for ( ; c1==c2 ; a++, b++ ) {
      c1 = isupper(*a) ? tolower(*a) : *a ;
      c2 = isupper(*b) ? tolower(*b) : *b ;

      if ( c1==0 || c2==0 ) {
	 break;
      }
   }
   
   return( c2 - c1 );

} /* Strcaseicmp() */




/*
 * Strncaseicmp()
 *
 * Case independent string compare with a length limit
 *
 */
int
Strncaseicmp( const char *s1, const char *s2, size_t count )
{
   const unsigned char   * a = (const unsigned char *) s1;
   const unsigned char   * b = (const unsigned char *) s2;
   int                     c1 = 0;
   int                     c2 = 0;
   size_t		   i;

   if ( a==b )
      return(0);

   for( i=0 ; i<count && c1==c2 ; a++, b++, i++ ) {
      c1 = isupper(*a) ? tolower(*a) : *a ;
      c2 = isupper(*b) ? tolower(*b) : *b ;

      if (c1==0 || c2==0) {
	 break;
      }
   }
   
   return( c2 - c1 );

} /* Strncaseicmp() */




/*
 * Strnlen()
 *
 * strlen with a maximum limit
 *
 */
size_t
Strnlen( const char *s1, size_t count )
{
   size_t       i;

   for( i=0 ; i<count && s1[i]!=0 ; i++ );

   return(i);

} /* Strnlen() */




/*
 * Strmaxcpy()
 *
 * copy a string into a limited buffer, possibly truncating it
 * function returns NULL when truncating source string
 *
 */
char *
Strmaxcpy( char *dest, const char *src, size_t count )
{
   char  * ptr = NULL;

   if ( count!=0 ) {
      if ( src==NULL || count<=1 ) {
	 *dest = '\0';
	 if ( src!=NULL && *src!='\0' ) {
	    ptr = dest;
	 }

      } else {

	 strncpy( dest, src, count );
	 if ( dest[count-1]=='\0' ) {
	    ptr = dest;
	 } else {
	    /* strcpy didn't put a NUL here => source was longer than count */
	    dest[count-1] = '\0';
	 }
      }
   }

   return(ptr);

} /* Strmaxcpy() */




/*
 * Strmaxdup()
 *
 * copy a string into dynamic memory when it's less than the max size
 *
 */
char *
Strmaxdup( char * src, size_t  max_len )
{
   char    * ptr = NULL;
   size_t    len;

   for ( len=0 ; src[len]!='\0'  &&  len<max_len ; len++ );
   if ( src[len]=='\0' ) {
      ptr = malloc( len+1 );
      if ( ptr!=NULL )
	 memcpy( ptr, src, len+1 );
   }

   return(ptr);

} /* Strmaxdup() */




/*
 * Xgetopt()
 *
 *
 */
int     optind = 1;
int     opterr = 0;
int     optopt = 0;

char  * optarg;

int
Xgetopt( int    p_argc, char   ** p_argv,  char  * p_options )
{
   char   * opos = 0;

   if ( p_options==NULL ) {
      fprintf(stderr, "getopt(): bad option string!\n");
      return(-1);
   }

   if ( p_argv[optind]==NULL ) {
      optopt = 0;
      return(-1);
   }

   if ( p_argv[optind][0]=='-' ) {

      optopt = p_argv[optind][1];
      if ( optopt == '\0' )
	 return(-1);

      if ( optopt=='-' ) {
	 optind++;
	 return(-1);
      }
      opos = strchr(p_options, optopt);
      optind++;
      if ( opos==NULL ) {
	 return('?');
      }

      if ( opos[1]==':' ) {
	 if ( optind<=p_argc && p_argv[optind]!=NULL ) {
	    optarg = p_argv[optind];
	    optind++;
	    return(optopt);
	 }
	 return ( p_options[0]==':' ? ':' : '?' );
      }
      optarg = NULL;

      return(optopt);

   } 

   optarg = NULL;
   optopt = '-';

   return(-1);

}/* Xgetopt() */
