/* @(#)%M%   %I%   SAP   %E% */
/**********************************************************************/
/* $Id: sncgss.h,v 1.3 2000/07/26 14:41:50 d019080 Exp $
 **********************************************************************/
/*                                                                    */
/*  (C) Copyright 1995-1998 SAP AG.  All rights reserved.             */
/*                                                                    */
/*                                                                    */
/*  sncgss.h   Security Software independent Header file              */
/*             for the DLL-Adapter                                    */
/*                                                                    */
/*  sncgss     DLL-Adapter for third party security software          */
/*             Module "Secure Network Communication"                  */
/*  ========                                                          */
/*                                                                    */
/*                                                                    */
/*  AUTHOR:    Martin Rex                                             */
/*                                                                    */
/*  CREATED:                                                          */
/*    26.06.1995   mrex                                               */
/*                                                                    */
/**********************************************************************/

#ifndef SNCGSS_H
#  define SNCGSS_H  1

#ifndef UNREFERENCED_PARAMETER
#  define UNREFERENCED_PARAMETER(a)    ((a)=(a))
#endif

/**********************************************************************/
/*                                                                    */
/*  Public type definitions                                           */
/*                                                                    */
/**********************************************************************/

/**********************************************************************
 *
 * SAPGSS type definitions for use within the snc*.[ch] modules
 *
 * If these don't match with the GSS-API definitions, then
 * we might have a problem
 *
 **********************************************************************/



typedef enum sapgss_prod_id {
    SAPGSS_ID_DUMMY       = 0, /* No security         (26-jun-95) mrex   */
    SAPGSS_ID_GENERIC     = 1, /* Generic GSS-API v2 Mechanism,          */
			       /*   let GSS-API fight it out ...         */
    SAPGSS_ID_KERBEROS5_1 = 2, /* Kerberos 5 / MIT v1 (26-jun-95) mrex   */
    SAPGSS_ID_SECUDE_1    = 3, /* SecuDE x.x       v1 (21-sep-95) mrex   */
    SAPGSS_ID_SAPNTLM     = 4, /* SAPNTLM          v1 (08-okt-97) mrex   */
    SAPGSS_ID_SPKM1       = 5, /* SPKM1               (18-aug-98) mrex   */
    SAPGSS_ID_SPKM2       = 6, /* SPKM2               (18-aug-98) mrex   */

    SAPGSS_ID_RESERVED    = 7, /* reserved ID         (30-oct-96) mrex   */

    SAPGSS_ID_ITSEC	  = 8, /* iTSEC/UBS	      (11-Sep-98) mrex   */
    SAPGSS_ID_SDTI        = 9, /* (SDTI Connect) Keon (13-Jan-99) mrex   */
    SAPGSS_ID_NEC	  = 10,/* NEC                 (07-Jun-00) mrex   */

    SAPGSS_ID_INVALID
} SAPGSS_MECH_ID;

#define NUM_INTERNAL_STUBS  (SAPGSS_ID_SAPNTLM+1)


struct sapgss_info_s {
  int                major_rev;     /* major revision number of adapter */
  int                minor_rev;     /* minor revision number of adapter */

  char             * adapter_name;  /* Adapter identification string    */
  SAPGSS_MECH_ID     mech_id;       /* security mechanism identifier    */

  char               integ_avail;   /* product supports Integrity QOP        */
  char               conf_avail;    /* product supports Confidentiality QOP  */

  char   reverse_operation;   /* reverse operation when client is behind  */
                              /* a firewall and has no possibility to     */
                              /* access the KDC and acquire tickets ...   */
                              /* (nescessary for Kerberos5, DCE, ...)     */

  char   export_sec_context;  /* This product supports exporting of an    */
                              /* established security context,            */
                              /* as defined by GSS-API v2                 */

  OM_uint32  wrap_overhead;

  gss_OID_desc FAR * nt_canonical_name;
  gss_OID_desc FAR * nt_private_name1;
  gss_OID_desc FAR * nt_private_name2;
  gss_OID_desc FAR * nt_private_name3;
  gss_OID_desc FAR * nt_private_name4;

  char         FAR * mech_prefix_string;

  char   mutual_auth;         /* This product supports mutual authentication */
  char   replay_prot;         /* This product supports replay detection      */

};
  


/**********************************************************************/
/*                                                                    */
/*  Export interface                                                  */
/*    - Function list  ( Prototype definitions )                      */
/*                                                                    */
/**********************************************************************/

#define ARG3_INIT_ADAPTER				\
	struct sapgss_info_s FAR * ,			\
        size_t                     ,			\
        int 

OM_uint32 DLL_FUNC_DECO sapsnc_init_adapter( ARG3_INIT_ADAPTER );
typedef OM_uint32 (FUNCPTR_DECO SAPSNC_INIT_ADAPTER_T)( ARG3_INIT_ADAPTER );


#define ARG4_EXPORT_CNAME_BLOB				 \
	OM_uint32   FAR * ,   	/* minor_status       */ \
	gss_name_t        ,   	/* input_name         */ \
	gss_buffer_t      ,     /* output_name_buffer */ \
        int		        /* adapter_index (snc internal use) */ 

OM_uint32 DLL_FUNC_DECO sapsnc_export_cname_blob( ARG4_EXPORT_CNAME_BLOB );
typedef OM_uint32 (FUNCPTR_DECO SAPSNC_EXPORT_CNAME_BLOB_T)( ARG4_EXPORT_CNAME_BLOB );



#define ARG4_IMPORT_CNAME_BLOB				 \
	OM_uint32   FAR * ,	/* minor_status       */ \
	gss_buffer_t      ,	/* input_name_buffer  */ \
	gss_name_t  FAR * ,	/* output_name        */ \
        int                     /* adapter_index (snc internal use) */

OM_uint32 DLL_FUNC_DECO sapsnc_import_cname_blob( ARG4_IMPORT_CNAME_BLOB );
typedef OM_uint32 (FUNCPTR_DECO SAPSNC_IMPORT_CNAME_BLOB_T)( ARG4_IMPORT_CNAME_BLOB );


/*
 *   GSS-API Version 1 functionality (RFC 1508 & 1509 )
 */
OM_uint32 DLL_FUNC_DECO sapgss_acquire_cred( ARG8_ACQUIRE_CRED );
OM_uint32 DLL_FUNC_DECO sapgss_release_cred( ARG2_RELEASE_CRED );
OM_uint32 DLL_FUNC_DECO sapgss_init_sec_context( ARG13_INIT_SEC_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_accept_sec_context( ARG11_ACCEPT_SEC_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_process_context_token( ARG3_PROCESS_CONTEXT_TOKEN );
OM_uint32 DLL_FUNC_DECO sapgss_delete_sec_context( ARG3_DELETE_SEC_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_context_time( ARG3_CONTEXT_TIME );
OM_uint32 DLL_FUNC_DECO sapgss_get_mic( ARG5_GET_MIC );
OM_uint32 DLL_FUNC_DECO sapgss_verify_mic( ARG5_VERIFY_MIC );
OM_uint32 DLL_FUNC_DECO sapgss_wrap( ARG7_WRAP );
OM_uint32 DLL_FUNC_DECO sapgss_unwrap( ARG6_UNWRAP );
OM_uint32 DLL_FUNC_DECO sapgss_display_status( ARG6_DISPLAY_STATUS );
OM_uint32 DLL_FUNC_DECO sapgss_indicate_mechs( ARG2_INDICATE_MECHS );
OM_uint32 DLL_FUNC_DECO sapgss_compare_name( ARG4_COMPARE_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_display_name( ARG4_DISPLAY_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_import_name( ARG4_IMPORT_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_release_name( ARG2_RELEASE_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_release_buffer( ARG2_RELEASE_BUFFER );
OM_uint32 DLL_FUNC_DECO sapgss_release_oid_set( ARG2_RELEASE_OID_SET );
OM_uint32 DLL_FUNC_DECO sapgss_inquire_cred( ARG6_INQUIRE_CRED );


/*
 * New functionality of GSS-API Version 2 (RFC 2743 & 2744 )
 */
OM_uint32 DLL_FUNC_DECO sapgss_add_cred( ARG11_ADD_CRED );
OM_uint32 DLL_FUNC_DECO sapgss_inquire_cred_by_mech( ARG7_INQUIRE_CRED_BY_MECH );
OM_uint32 DLL_FUNC_DECO sapgss_inquire_context( ARG9_INQUIRE_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_wrap_size_limit( ARG6_WRAP_SIZE_LIMIT );
OM_uint32 DLL_FUNC_DECO sapgss_export_sec_context( ARG3_EXPORT_SEC_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_import_sec_context( ARG3_IMPORT_SEC_CONTEXT );
OM_uint32 DLL_FUNC_DECO sapgss_create_emtpy_oid_set( ARG2_CREATE_EMPTY_OID_SET );
OM_uint32 DLL_FUNC_DECO sapgss_add_oid_set_member( ARG3_ADD_OID_SET_MEMBER );
OM_uint32 DLL_FUNC_DECO sapgss_test_oid_set_member( ARG4_TEST_OID_SET_MEMBER );
OM_uint32 DLL_FUNC_DECO sapgss_inquire_names_for_mech( ARG3_INQUIRE_NAMES_FOR_MECH );
OM_uint32 DLL_FUNC_DECO sapgss_inquire_mechs_for_name( ARG3_INQUIRE_MECHS_FOR_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_canonicalize_name( ARG4_CANONICALIZE_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_export_name( ARG3_EXPORT_NAME );
OM_uint32 DLL_FUNC_DECO sapgss_duplicate_name( ARG3_DUPLICATE_NAME );

#endif  /* SNCGSS_H */

