/* sccsid = "@(#)gss_argm.h   %E%   SAP   %I%" */

/************************************************************************/
/* $Id: gss_argm.h,v 1.3 2000/07/26 14:41:48 d019080 Exp $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/


#ifndef _GSS_ARGM_H_
#  define _GSS_ARGM_H_

/************************************************************************/
/*									*/
/*  Argument vectors for GSS-API calls in MACROs			*/
/*  for consistency of function declarators and function pointers	*/
/*									*/
/************************************************************************/

/*
 *   GSS-API Version 1 functionality (RFC 1508 & 1509 )
 */
#define ARG8_ACQUIRE_CRED					   \
	OM_uint32     FAR * ,	/* minor_status			*/ \
	gss_name_t	    ,	/* desired_name			*/ \
	OM_uint32	    ,	/* time_req			*/ \
	gss_OID_set	    ,	/* desired_mechs		*/ \
	gss_cred_usage_t    ,	/* cred_usage			*/ \
	gss_cred_id_t FAR * ,	/* output_cred_handle		*/ \
	gss_OID_set   FAR * ,	/* actual_mechs			*/ \
	OM_uint32     FAR *	/* time_rec			*/ 

OM_uint32 DLL_FUNC_DECO gss_acquire_cred   ( ARG8_ACQUIRE_CRED );
typedef OM_uint32 (FUNCPTR_DECO GSS_ACQUIRE_CRED_T)( ARG8_ACQUIRE_CRED );


#define ARG2_RELEASE_CRED					   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_cred_id_t FAR *		/* cred_handle		*/

OM_uint32 DLL_FUNC_DECO gss_release_cred   ( ARG2_RELEASE_CRED );
typedef OM_uint32 (FUNCPTR_DECO GSS_RELEASE_CRED_T)( ARG2_RELEASE_CRED );



#define ARG13_INIT_SEC_CONTEXT					   \
	OM_uint32     FAR *    ,	/* minor_status		*/ \
	gss_cred_id_t          ,	/* initiator_cred_handle */ \
	gss_ctx_id_t  FAR *    ,	/* context_handle	*/ \
	gss_name_t             ,	/* target_name		*/ \
	gss_OID		       ,	/* mech_type		*/ \
	OM_uint32	       ,	/* req_flags		*/ \
	OM_uint32	       ,	/* time_req		*/ \
	gss_channel_bindings_t ,	/* input_chan_bindings	*/ \
	gss_buffer_t	       ,	/* input_token		*/ \
	gss_OID	      FAR *    ,	/* actual_mech_type	*/ \
	gss_buffer_t	       ,	/* output_token		*/ \
	OM_uint32     FAR *    ,	/* ret_flags		*/ \
	OM_uint32     FAR *		/* time_rec		*/

OM_uint32 DLL_FUNC_DECO gss_init_sec_context   ( ARG13_INIT_SEC_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_INIT_SEC_CONTEXT_T)( ARG13_INIT_SEC_CONTEXT );



#define ARG11_ACCEPT_SEC_CONTEXT				   \
	OM_uint32     FAR *    ,	/* minor_status		*/ \
	gss_ctx_id_t  FAR *    ,	/* context_handle	*/ \
	gss_cred_id_t	       ,	/* acceptor_cred_handle */ \
	gss_buffer_t	       ,	/* input_token_buffer	*/ \
	gss_channel_bindings_t ,	/* input_chan_bindings	*/ \
	gss_name_t    FAR *    ,	/* src_name		*/ \
	gss_OID	      FAR *    ,	/* mech_type		*/ \
	gss_buffer_t	       ,	/* output_token		*/ \
	OM_uint32     FAR *    ,	/* ret_flags		*/ \
	OM_uint32     FAR *    ,	/* time_rec		*/ \
	gss_cred_id_t FAR *		/* delegated_cred_handle */

OM_uint32 DLL_FUNC_DECO gss_accept_sec_context   ( ARG11_ACCEPT_SEC_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_ACCEPT_SEC_CONTEXT_T)( ARG11_ACCEPT_SEC_CONTEXT );



#define ARG3_PROCESS_CONTEXT_TOKEN				   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	    ,		/* context_handle	*/ \
	gss_buffer_t			/* token_buffer		*/

OM_uint32 DLL_FUNC_DECO gss_process_context_token   ( ARG3_PROCESS_CONTEXT_TOKEN );
typedef OM_uint32 (FUNCPTR_DECO GSS_PROCESS_CONTEXT_TOKEN_T)( ARG3_PROCESS_CONTEXT_TOKEN );



#define ARG3_DELETE_SEC_CONTEXT					   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t  FAR * ,		/* context_handle	*/ \
	gss_buffer_t			/* output_token		*/

OM_uint32 DLL_FUNC_DECO gss_delete_sec_context   ( ARG3_DELETE_SEC_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_DELETE_SEC_CONTEXT_T)( ARG3_DELETE_SEC_CONTEXT );



#define ARG3_CONTEXT_TIME					   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	    ,		/* context_handle	*/ \
	OM_uint32     FAR *		/* time_rec		*/

OM_uint32 DLL_FUNC_DECO gss_context_time   ( ARG3_CONTEXT_TIME );
typedef OM_uint32 (FUNCPTR_DECO GSS_CONTEXT_TIME_T)( ARG3_CONTEXT_TIME );



/* v2 name for gss_sign() */
#define ARG5_GET_MIC						   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	    ,		/* context_handle	*/ \
	gss_qop_t	    ,		/* qop_req		*/ \
	gss_buffer_t	    ,		/* message_buffer	*/ \
	gss_buffer_t			/* message_token	*/

OM_uint32 DLL_FUNC_DECO gss_get_mic ( ARG5_GET_MIC );
typedef OM_uint32 (FUNCPTR_DECO GSS_GET_MIC_T)( ARG5_GET_MIC );



/* v2 name for gss_verify() */
#define ARG5_VERIFY_MIC						   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	   ,		/* context_handle	*/ \
	gss_buffer_t	   ,		/* message_buffer	*/ \
	gss_buffer_t	   ,		/* token_buffer		*/ \
	gss_qop_t    FAR *		/* qop_state		*/
	
OM_uint32 DLL_FUNC_DECO gss_verify_mic ( ARG5_VERIFY_MIC );
typedef OM_uint32 (FUNCPTR_DECO GSS_VERIFY_MIC_T)( ARG5_VERIFY_MIC );



/* v2 name for gss_seal() */
#define ARG7_WRAP						   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	   ,		/* context_handle	*/ \
	int		   ,		/* conf_req_flag	*/ \
	gss_qop_t	   ,		/* qop_req		*/ \
	gss_buffer_t	   ,		/* input_message_buffer */ \
	int	     FAR * ,		/* conf_state		*/ \
	gss_buffer_t			/* output_message_buffer*/

OM_uint32 DLL_FUNC_DECO gss_wrap ( ARG7_WRAP );
typedef OM_uint32 (FUNCPTR_DECO GSS_WRAP_T)( ARG7_WRAP );



/* v2 name for gss_unseal() */
#define ARG6_UNWRAP						   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	   ,		/* context_handle	*/ \
	gss_buffer_t	   ,		/* input_message_buffer */ \
	gss_buffer_t	   ,		/* output_message_buffer*/ \
	int	     FAR * ,		/* conf_state		*/ \
	gss_qop_t    FAR *		/* qop_state		*/

OM_uint32 DLL_FUNC_DECO gss_unwrap ( ARG6_UNWRAP );
typedef OM_uint32 (FUNCPTR_DECO GSS_UNWRAP_T)( ARG6_UNWRAP );



#define ARG6_DISPLAY_STATUS					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	OM_uint32	   ,		/* status_value		*/ \
	int		   ,		/* status_type		*/ \
	gss_OID		   ,		/* mech_type		*/ \
	OM_uint32    FAR * ,		/* message_context	*/ \
	gss_buffer_t			/* status_string	*/

OM_uint32 DLL_FUNC_DECO gss_display_status   ( ARG6_DISPLAY_STATUS );
typedef OM_uint32 (FUNCPTR_DECO GSS_DISPLAY_STATUS_T)( ARG6_DISPLAY_STATUS );



#define ARG2_INDICATE_MECHS					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID_set  FAR *		/* mech_set		*/

OM_uint32 DLL_FUNC_DECO gss_indicate_mechs   ( ARG2_INDICATE_MECHS );
typedef OM_uint32 (FUNCPTR_DECO GSS_INDICATE_MECHS_T)( ARG2_INDICATE_MECHS );



#define ARG4_COMPARE_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* name1		*/ \
	gss_name_t	   ,		/* name2		*/ \
	int	     FAR *		/* name_equal		*/

OM_uint32 DLL_FUNC_DECO gss_compare_name   ( ARG4_COMPARE_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_COMPARE_NAME_T)( ARG4_COMPARE_NAME );



#define ARG4_DISPLAY_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* input_name		*/ \
	gss_buffer_t	   ,		/* output_name_buffer	*/ \
	gss_OID	     FAR *		/* output_name_type	*/

OM_uint32 DLL_FUNC_DECO gss_display_name   ( ARG4_DISPLAY_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_DISPLAY_NAME_T)( ARG4_DISPLAY_NAME );



#define ARG4_IMPORT_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_buffer_t	   ,		/* input_name_buffer	*/ \
	gss_OID		   ,		/* input_name_type	*/ \
	gss_name_t   FAR *		/* output_name		*/

OM_uint32 DLL_FUNC_DECO gss_import_name   ( ARG4_IMPORT_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_IMPORT_NAME_T)( ARG4_IMPORT_NAME );



#define ARG2_RELEASE_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t   FAR *		/* input_name		*/

OM_uint32 DLL_FUNC_DECO gss_release_name   ( ARG2_RELEASE_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_RELEASE_NAME_T)( ARG2_RELEASE_NAME );



#define ARG2_RELEASE_BUFFER					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_buffer_t			/* buffer		*/

OM_uint32 DLL_FUNC_DECO gss_release_buffer   ( ARG2_RELEASE_BUFFER );
typedef OM_uint32 (FUNCPTR_DECO GSS_RELEASE_BUFFER_T)( ARG2_RELEASE_BUFFER );



#define ARG2_RELEASE_OID_SET					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID_set  FAR *		/* set			*/

OM_uint32 DLL_FUNC_DECO gss_release_oid_set   ( ARG2_RELEASE_OID_SET );
typedef OM_uint32 (FUNCPTR_DECO GSS_RELEASE_OID_SET_T)( ARG2_RELEASE_OID_SET );



#define ARG6_INQUIRE_CRED					   \
	OM_uint32	  FAR * ,	/* minor_status		*/ \
	gss_cred_id_t		,	/* cred_handle		*/ \
	gss_name_t	  FAR * ,	/* name			*/ \
	OM_uint32	  FAR * ,	/* lifetime		*/ \
	gss_cred_usage_t  FAR * ,	/* cred_usage		*/ \
	gss_OID_set	  FAR *		/* mechanisms		*/

OM_uint32 DLL_FUNC_DECO gss_inquire_cred   ( ARG6_INQUIRE_CRED );
typedef OM_uint32 (FUNCPTR_DECO GSS_INQUIRE_CRED_T)( ARG6_INQUIRE_CRED );




/*
 * New functionality in GSS-API Version 2
 */
#define ARG11_ADD_CRED						   \
	OM_uint32     FAR * ,		/* minor_status		*/ \
	gss_cred_id_t	    ,		/* input_cred_handle	*/ \
	gss_name_t	    ,		/* desired_name		*/ \
	gss_OID		    ,		/* desired_mech		*/ \
	gss_cred_usage_t    ,		/* cred_usage		*/ \
	OM_uint32	    ,		/* initiator_time_req	*/ \
	OM_uint32	    ,		/* acceptor_time_req	*/ \
	gss_cred_id_t FAR * ,		/* output_cred_handle	*/ \
	gss_OID_set   FAR * ,		/* actual_mechs		*/ \
	OM_uint32     FAR * ,		/* initiator_time_rec	*/ \
	OM_uint32     FAR *		/* acceptor_time_rec	*/

OM_uint32 DLL_FUNC_DECO gss_add_cred   ( ARG11_ADD_CRED );
typedef OM_uint32 (FUNCPTR_DECO GSS_ADD_CRED_T)( ARG11_ADD_CRED );



#define ARG7_INQUIRE_CRED_BY_MECH				   \
	OM_uint32	 FAR * ,	/* minor_status		*/ \
	gss_cred_id_t	       ,	/* cred_handle		*/ \
	gss_OID		       ,	/* mech_type		*/ \
	gss_name_t	 FAR * ,	/* name			*/ \
	OM_uint32	 FAR * ,	/* initiator_lifetime	*/ \
	OM_uint32	 FAR * ,	/* acceptor_lifetime	*/ \
	gss_cred_usage_t FAR *		/* cred_usage		*/

OM_uint32 DLL_FUNC_DECO gss_inquire_cred_by_mech   ( ARG7_INQUIRE_CRED_BY_MECH );
typedef OM_uint32 (FUNCPTR_DECO GSS_INQUIRE_CRED_BY_MECH_T)( ARG7_INQUIRE_CRED_BY_MECH );



#define ARG9_INQUIRE_CONTEXT					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	   ,		/* context_handle	*/ \
	gss_name_t   FAR * ,		/* initiator_name	*/ \
	gss_name_t   FAR * ,		/* acceptor_name	*/ \
	OM_uint32    FAR * ,		/* lifetime_rec		*/ \
	gss_OID	     FAR * ,		/* mech_type		*/ \
	OM_uint32    FAR * ,		/* ret_flags		*/ \
	int	     FAR * ,		/* locally_initiated	*/ \
	int	     FAR *		/* open			*/

OM_uint32 DLL_FUNC_DECO gss_inquire_context   ( ARG9_INQUIRE_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_INQUIRE_CONTEXT_T)( ARG9_INQUIRE_CONTEXT );



#define ARG6_WRAP_SIZE_LIMIT					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t	   ,		/* context handle	*/ \
	int		   ,		/* conf_req_flag	*/ \
	gss_qop_t	   ,		/* qop_req		*/ \
	OM_uint32	   ,		/* requested output size*/ \
	OM_uint32    FAR *		/* maximum input size	*/

OM_uint32 DLL_FUNC_DECO gss_wrap_size_limit   ( ARG6_WRAP_SIZE_LIMIT );
typedef OM_uint32 (FUNCPTR_DECO GSS_WRAP_SIZE_LIMIT_T)( ARG6_WRAP_SIZE_LIMIT );



#define ARG3_EXPORT_SEC_CONTEXT					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_ctx_id_t FAR * ,		/* context_handle	*/ \
	gss_buffer_t			/* interprocess_token	*/

OM_uint32 DLL_FUNC_DECO gss_export_sec_context   ( ARG3_EXPORT_SEC_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_EXPORT_SEC_CONTEXT_T)( ARG3_EXPORT_SEC_CONTEXT );



#define ARG3_IMPORT_SEC_CONTEXT					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_buffer_t	   ,		/* interprocess_token	*/ \
	gss_ctx_id_t FAR *		/* context_handle	*/

OM_uint32 DLL_FUNC_DECO gss_import_sec_context   ( ARG3_IMPORT_SEC_CONTEXT );
typedef OM_uint32 (FUNCPTR_DECO GSS_IMPORT_SEC_CONTEXT_T)( ARG3_IMPORT_SEC_CONTEXT );



#define ARG2_CREATE_EMPTY_OID_SET				   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID_set  FAR *		/* oid_set		*/

OM_uint32 DLL_FUNC_DECO gss_create_empty_oid_set   ( ARG2_CREATE_EMPTY_OID_SET );
typedef OM_uint32 (FUNCPTR_DECO GSS_CREATE_EMPTY_OID_SET_T)( ARG2_CREATE_EMPTY_OID_SET );



#define ARG3_ADD_OID_SET_MEMBER					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID		   ,		/* member_oid		*/ \
	gss_OID_set  FAR *		/* oid_set		*/

OM_uint32 DLL_FUNC_DECO gss_add_oid_set_member   ( ARG3_ADD_OID_SET_MEMBER );
typedef OM_uint32 (FUNCPTR_DECO GSS_ADD_OID_SET_MEMBER_T)( ARG3_ADD_OID_SET_MEMBER );



#define ARG4_TEST_OID_SET_MEMBER				   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID		   ,		/* member		*/ \
	gss_OID_set	   ,		/* set			*/ \
	int	     FAR *		/* present		*/

OM_uint32 DLL_FUNC_DECO gss_test_oid_set_member   ( ARG4_TEST_OID_SET_MEMBER );
typedef OM_uint32 (FUNCPTR_DECO GSS_TEST_OID_SET_MEMBER_T)( ARG4_TEST_OID_SET_MEMBER );



#define ARG3_INQUIRE_NAMES_FOR_MECH				   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_OID		   ,		/* mechanism_oid	*/ \
	gss_OID_set  FAR *		/* name_types		*/

OM_uint32 DLL_FUNC_DECO gss_inquire_names_for_mech   ( ARG3_INQUIRE_NAMES_FOR_MECH );
typedef OM_uint32 (FUNCPTR_DECO GSS_INQUIRE_NAMES_FOR_MECH_T)( ARG3_INQUIRE_NAMES_FOR_MECH );



#define ARG3_INQUIRE_MECHS_FOR_NAME				   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* input_name		*/ \
	gss_OID_set  FAR *		/* mechanism oids	*/

OM_uint32 DLL_FUNC_DECO gss_inquire_mechs_for_name   ( ARG3_INQUIRE_MECHS_FOR_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_INQUIRE_MECHS_FOR_NAME_T)( ARG3_INQUIRE_MECHS_FOR_NAME );



#define ARG4_CANONICALIZE_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* input_name		*/ \
	gss_OID		   ,		/* mechanism_type	*/ \
	gss_name_t   FAR *		/* output_name		*/

OM_uint32 DLL_FUNC_DECO gss_canonicalize_name   ( ARG4_CANONICALIZE_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_CANONICALIZE_NAME_T)( ARG4_CANONICALIZE_NAME );



#define ARG3_EXPORT_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* input_name		*/ \
	gss_buffer_t			/* output_name_blob	*/

OM_uint32 DLL_FUNC_DECO gss_export_name   ( ARG3_EXPORT_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_EXPORT_NAME_T)( ARG3_EXPORT_NAME );



#define ARG3_DUPLICATE_NAME					   \
	OM_uint32    FAR * ,		/* minor_status		*/ \
	gss_name_t	   ,		/* src_name		*/ \
	gss_name_t   FAR *		/* dest_name		*/
	
OM_uint32 DLL_FUNC_DECO gss_duplicate_name   ( ARG3_DUPLICATE_NAME );
typedef OM_uint32 (FUNCPTR_DECO GSS_DUPLICATE_NAME_T)( ARG3_DUPLICATE_NAME );


#endif /* _GSS_ARGM_H_ */
