/* SCCSID("@(#)debug.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: debug.h,v 1.6 2000/07/26 14:41:48 d019080 Exp $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/


#ifndef _XX_DEBUG_H_
#  define  _XX_DEBUG_H_

#include <stdarg.h>

#ifdef     XDEBUG

extern int debug_global_flag;

typedef enum dbg_class_e {
      DBG_CLASS_ERR	= (1<<0),
      DBG_CLASS_ARG	= (1<<1),
      DBG_CLASS_ARGV	= (1<<2),
      DBG_CLASS_RET	= (1<<3),
      DBG_CLASS_INFO	= (1<<4),
      DBG_CLASS_STRING	= (1<<5)
} dbg_class_et;


extern void debug_init( int enable, FILE * fp, char * filename );
extern void debug_print( dbg_class_et p_class, ... );

#define DEBUG_INIT()	   debug_init( FALSE, stderr, NULL );

#define DEBUG_BEGIN(x)	   char  * this_Call GNU_UNUSED = # x ;
#define DEBUG_EXEC(x)	   x


#undef XDBG
#define XDBG(x)  debug_print x ;
#define D_ERR    DBG_CLASS_ERR,  this_Call
#define D_ARG    DBG_CLASS_ARG,  this_Call
#define D_RET    DBG_CLASS_RET,  this_Call
#define D_ARGV   DBG_CLASS_ARGV
#define D_INFO   DBG_CLASS_INFO
#define D_STRING DBG_CLASS_STRING


#if 1
#define DEBUG_ERR(x)
#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_ARG(x)
#define DEBUG_ARG_STRING(x)

#define DEBUG_RET(x)

#else

#define DEBUG_ARG(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "->> %s(\n", this_Call);		 \
	 fprintf x ;					 \
	 fflush(tf);					 \
      }

#define DEBUG_ARG_STRING(x)				 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "\t%s = \"%s\"\n", #x, x);		 \
	 fflush(tf);					 \
      }

#define DEBUG_ERR(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "  ERROR in %s\n  ", this_Call);	 \
	 fprintf x;					 \
	 fflush(tf);					 \
      }


#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_RET(x)					 \
      if ( (debug_global_flag) )			 \
      {							 \
	 fprintf(tf, "<<- %s() ", this_Call);		 \
	 fprintf x;					 \
	 fprintf(tf, "----------\n");			 \
	 fflush(tf);					 \
      }
#endif


#else  /* !XDEBUG */

#define XDBG(x)
#define DEBUG_INIT()

#define DEBUG_BEGIN(x)
#define DEBUG_ERR(x)
#define DEBUG_INFO(x)
#define DEBUG_STRANGE(x)

#define DEBUG_ARG(x)
#define DEBUG_ARG_STRING(x)

#define DEBUG_RET(x)

#define DEBUG_EXEC(x)


#endif /* !XDEBUG */



#endif /* _XX_DEBUG_H_ */
