/*
 * @(#) $Id: //shared_tc/com.sap.security.core.server/702_SP_REL/src/_vsi/java/_test/com/sap/security/core/server/vsi/service/test/VsiTest.java#10 $
 * 
 * Copyright (c) 2004 - 2012 SAP AG All rights reserved.
 */

package com.sap.security.core.server.vsi.service.test;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

import com.sap.security.core.server.vsi.api.Adapter;
import com.sap.security.core.server.vsi.api.ContentInfo;
import com.sap.security.core.server.vsi.api.Driver;
import com.sap.security.core.server.vsi.api.Engine;
import com.sap.security.core.server.vsi.api.Group;
import com.sap.security.core.server.vsi.api.Instance;
import com.sap.security.core.server.vsi.api.Parameter;
import com.sap.security.core.server.vsi.api.Profile;
import com.sap.security.core.server.vsi.api.Provider;
import com.sap.security.core.server.vsi.api.Server;
import com.sap.security.core.server.vsi.api.VSIFilterInputStream;
import com.sap.security.core.server.vsi.api.VSIService;
import com.sap.security.core.server.vsi.api.Virus;
import com.sap.security.core.server.vsi.api.exception.VSIServiceException;
import com.sap.security.core.server.vsi.api.exception.VSIServiceMessage;
import com.sap.security.core.server.vsi.api.exception.VirusInfectionException;
import com.sap.security.core.server.vsi.api.exception.VirusScanException;
import com.sap.security.core.server.vsi.gui.VSIRuntimePanel;
import com.sap.security.core.server.vsi.service.VSIServiceFrame;
import com.sap.security.core.server.vsi.service.configuration.VSIRuntimeConfig;
import com.sap.security.nw.vsi.osgi.core.VSIServiceFactory;

/**
 * Virus Scan Interface test class. It tests the VSI framework in stand-alone
 * mode.
 * 
 * <pre>
 * 
 * History:
 *     1.0      Initial Version for SAP NetWeaver 04
 *     1.5      Enhancements in the native VSI layer
 *     1.6      Dual runtime support (JAVA standalone and J2EE)
 *     1.7      Added scanStream methods and support ActiveContent scan
 *     1.8      Added getContentInfo and support for Content filtering
 *     1.9      Minor bug fixes and new vendor parameters
 * </pre>
 * 
 * @author <a href=mailto:markus.strehle@sap.com>Markus Strehle</a>
 * 
 * @version 1.9, $Date: 2013/05/16 $
 * 
 * @since 1.0
 * 
 */

public class VsiTest {
    /** private static panel */
    private VsiTestPanel _vsiTestPanel = null;
    /** private static panel */
    private javax.swing.JPanel _vsiResultPanel = null;

    /**
     * Main function of <code>VsiTest</code>
     * 
     * @param args
     */
    public static void main(String[] args) {

        try {
            Properties vsiProperties = new Properties();
            String cfgFile = null;
            boolean createPropertiesFile = true;
            // start main
            if (args != null && args.length == 0) {
                System.out.println("...  enter VsiTest framework  ... ");  //$JL-SYS_OUT_ERR$
                cfgFile = getCommandParam(args, "-c");
                if (cfgFile == null) {
                    cfgFile = getCommandParam(args, "-cfg");
                }
                if (cfgFile == null) {
                    cfgFile = "vsi.properties";
                    createPropertiesFile = false;
                }
                FileInputStream vsiPStream = null;
                try {
                    vsiPStream = new FileInputStream(cfgFile);
                    if (vsiPStream.available() > 0) {
                        vsiProperties.load(vsiPStream);
                        vsiPStream.close();
                    }
                } catch (Exception e) {
                    vsiProperties = null;
                    if(createPropertiesFile==false) {
                       cfgFile = null; 
                }
                }
            } else {
                wrapVsiScan(args);
                return;
            }
            // createRessourceBundle(
            // VSIServiceMessage.ID0100_NO_INSTANCE_AVAILABLE.create());
            // create object of this class
            final VsiTest vsiTest = new VsiTest();
            // create the "Test" panel
            vsiTest._vsiTestPanel = vsiTest.new VsiTestPanel();
            // create the "Result" panel
            vsiTest._vsiResultPanel = vsiTest._vsiTestPanel.getInfoPanel();
            // start VSI service
            VSIServiceFactory.startVSI(vsiProperties);
            // Initialize the JFrame and add the JPanels
            vsiTest.initComponents();
            VSIServiceFactory.setPropertiesFile(cfgFile);
            // leave main thread
        } catch (Throwable vse) {
            if (args != null && args.length == 0) {
                // $JL-EXC$
                // $JL-SYS_OUT_ERR$
                if (vse != null && 
                    vse.getMessage() != null && 
                    vse.getMessage().length() > 0) {
                    System.out.println("Exception: " + vse.getMessage());  //$JL-SYS_OUT_ERR$
                    System.out.print(printHelp());  //$JL-SYS_OUT_ERR$
                } else {
                    System.out.print(printHelp());  //$JL-SYS_OUT_ERR$
                    return;
                }
                // there was an exception ...
            } else {
                if (vse.getMessage() == null)
                    System.out.println("Exception: No configuration available");  //$JL-SYS_OUT_ERR$
                else
                    System.out.println(vse.getMessage());  //$JL-SYS_OUT_ERR$
            }
        }
        if (args != null && args.length == 0) {
            // leave main
            // $JL-SYS_OUT_ERR$
            System.out.println("...  leave VsiTest framework ... ");  //$JL-SYS_OUT_ERR$
        }
    }

    /**
     * Parse the arguments for an option
     */
    static String getCommandParam(String[] args, String option) {
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals(option) && args.length > i + 1) {
                if (i + 1 < args.length)
                    return args[i + 1];
                else
                    return new String("");
            }
        }
        return null;
    }

    /**
     * start VSI framework
     * 
     * @throws VSIServiceException
     */
    private static void startVSA(String[] args)
                                               throws VSIServiceException {
        InputStream in = null;
        Properties p = new Properties();
        boolean createPropertiesFile = true;
        String cfgFile = getCommandParam(args, "-c");
        String cfgVsa = getCommandParam(args, "-V");
        String cfgTraceLevel = getCommandParam(args, "-l");
        String cfgTraceFile = getCommandParam(args, "-f");
        if (cfgTraceLevel != null && cfgTraceFile != null) {
            VSIServiceFactory.setTrace(cfgTraceFile, cfgTraceLevel);
        }
        if (cfgFile == null)
            cfgFile = getCommandParam(args, "-cfg");
        if (cfgFile == null) {
            cfgFile = "vsi.properties";
            createPropertiesFile = false;
        }
        if (cfgFile != null) {
            try {
                in = VsiTest.class.getResourceAsStream(cfgFile);
                if (in == null)
                    in = ClassLoader.getSystemResourceAsStream(cfgFile);
                if (in == null)
                    in = new FileInputStream(cfgFile);
                if (in.available() > 0) {
                    p.load(in);
                    in.close();
                    VSIServiceFactory.startVSI(p);
                    VSIServiceFactory.getService();
                    VSIServiceFactory.setPropertiesFile(cfgFile);
                    return;
                }
            } catch (FileNotFoundException fe) {
                // $JL-EXC$
                if(createPropertiesFile==false) {
                    cfgFile = null; 
                 }
            } catch (IOException ie) {
                // $JL-EXC$
                if(createPropertiesFile==false) {
                    cfgFile = null; 
                 }
            }
        }
        if (cfgVsa != null && cfgVsa.length() > 0) {
            VSIServiceFactory.startVSI(cfgVsa, null, null, null);
        } else {
            VSIServiceFactory.startVSI(null);
        }
        VSIServiceFactory.getService();
        VSIServiceFactory.setPropertiesFile(cfgFile);
    }

    /**
     * Static Wrapper for main(), to be used from outside of VsiTest for JUnit.
     * 
     * @param args
     *            Arguments to be used for call
     * @return none. PrintOut results to console.
     * 
     * @throws VSIServiceException
     * @throws VirusScanException
     * @throws VirusInfectionException
     * 
     * @see com.sap.security.core.server.vsi.api.Instance
     * @see VSIServiceException
     * @see VirusScanException
     * @see VirusInfectionException
     */
    public static synchronized ContentInfo[] wrapVsiScan(String[] args)
                                                                       throws VSIServiceException,
                                                                       VirusScanException,
                                                                       VirusInfectionException,
                                                                       IOException {
        ContentInfo[] cInfo = new ContentInfo[0];
        String command = (args != null && args.length > 0) ? args[0].toLowerCase() : null;
        String lastOpt = (args != null && args.length > 0) ? args[args.length - 1] : "EICAR";
        /* remove -- for commands */
        if (command != null && command.charAt(0) == '-') {
            command = command.substring(1);
            if(command.charAt(0) == '-')
               command = command.substring(1);
        }
        if (command == null) {
            System.out.print(printUsage());  //$JL-SYS_OUT_ERR$
            return cInfo;
        } else if (command.startsWith("scan") == true) {
            /* deactivate security audit for command scan actions */
            System.setProperty("vsi.security.log.level", "-1");
            startVSA(args);
            if (command.compareToIgnoreCase("scan") == 0) {
                String buf = getCommandParam(args, "-buffer");
                if (buf == null) {
                    cInfo = execVsiScan(false, false, false, true, 0, null, 0, null, lastOpt);
                } else {
                    FileInputStream fis = null;
                    byte[] _b = null;
                    try {
                        // get the file
                        fis = new FileInputStream(lastOpt);
                        _b = new byte[(int) new File(lastOpt).length()];
                        fis.read(_b);
                        cInfo = execVsiScan(false, false, false, true, 0, null, 1, _b, lastOpt);
                    } catch (Exception e) {
                        // $JL-EXC$
                        cInfo = execVsiScan(false, false, false, true, 0, null, 0, null, lastOpt);
                    } finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            } catch (IOException ie) {
                                // $JL-EXC$
                            }
                        }
                    }
                }
            } else {
                byte[] _b = null;
                String _f2s = lastOpt.toUpperCase();
                if (_f2s.startsWith("EICAR"))
                    _b = Virus.EICAR;
                else
                    _b = Virus.SHAKESPEARE;
                if (command.startsWith("scanbyte") == true) {
                    cInfo = execVsiScan(false, false, false, true, 0,
                            null, 1, _b, lastOpt);
                } else {
                    int threads = 1;
                    int loops = 1;
                    String maxThead = getCommandParam(args, "-T");
                    String maxLoop = getCommandParam(args, "-r");
                    try {
                        threads = (maxThead != null) ? Integer.parseInt(maxThead) : 1;
                    } catch (Exception e) {
                        threads = 1;
                    }
                    try {
                        loops = (maxLoop != null) ? Integer.parseInt(maxLoop) : 1;
                    } catch (Exception e) {
                        loops = 1;
                    }
                    cInfo = execVsiThreadedScan(false, false, false,
                            true, 0, null, 1, _b, lastOpt, 0, threads,
                            loops, null);
                }
            }
            if (cInfo != null) {
                System.out.println("No threat found in " + lastOpt);  //$JL-SYS_OUT_ERR$
                for (int i = 0; i < cInfo.length; i++) {
                    System.out.println("=================================");  //$JL-SYS_OUT_ERR$
                    System.out.println("Object name: " + cInfo[0].getObjectName());  //$JL-SYS_OUT_ERR$
                    System.out.println("Object type: " + cInfo[0].getContentType());  //$JL-SYS_OUT_ERR$
                    System.out.println("Object ext.: " + cInfo[0].getExtension());  //$JL-SYS_OUT_ERR$
                }
            }
            return cInfo;
        } else if (command.compareToIgnoreCase("help") == 0) {
            System.out.print(printHelp());  //$JL-SYS_OUT_ERR$
        } else if (command.compareToIgnoreCase("h") == 0) {
            System.out.print(printHelp());  //$JL-SYS_OUT_ERR$
        } else if (command.compareToIgnoreCase("info") == 0) {
            startVSA(args);
            System.out.print(getVersionInfo());  //$JL-SYS_OUT_ERR$
            VSIServiceFactory.stopVSI();
        } else if (command.compareToIgnoreCase("version") == 0) {
            startVSA(args);
            System.out.print(getVersionInfo());  //$JL-SYS_OUT_ERR$
            VSIServiceFactory.stopVSI();
        } else {
            try {
                final VsiTest vsiTest = new VsiTest();
                vsiTest._vsiTestPanel = vsiTest.new VsiTestPanel();
                vsiTest._vsiResultPanel = vsiTest._vsiTestPanel.getInfoPanel();
                startVSA(args);
                vsiTest.initComponents();
            } catch (Throwable e) {
                System.out.print(printHelp());  //$JL-SYS_OUT_ERR$
            }
            return cInfo;
        }
        return cInfo;
    }

    /**
     * Static scan function. This functions wraps execVsiScan for threaded scan
     * 
     * @param
     * 
     * @see #execVsiScan(boolean, boolean, boolean, boolean, int, String, int,
     *      byte[], String)
     * 
     */
    public static synchronized ContentInfo[] execVsiThreadedScan(
                                                                 boolean doClean,
                                                                 boolean doActiveContent,
                                                                 boolean doMimeCheck,
                                                                 boolean doProfileOnly,
                                                                 int instType,
                                                                 String instName,
                                                                 int actType,
                                                                 byte[] byteArray,
                                                                 String objectName,
                                                                 int threadType,
                                                                 int threads,
                                                                 int loops,
                                                                 String durationTime)
                                                                                     throws VSIServiceException,
                                                                                     VirusScanException,
                                                                                     VirusInfectionException,
                                                                                     IOException {
        final VsiTest vsiTest   = new VsiTest();
        ContentInfo[] cInfo     = new ContentInfo[0];
        VSIServiceException vse = null;
        Thread[] objThreads     = new Thread[threads];
        int durationSeconds     = 300;
        int i;

        try {
            durationSeconds = (durationTime != null) ? Integer.parseInt(durationTime) : 300;
        } catch (Exception e) {
            durationSeconds = 300;
        }
        for (i = 0; i < threads; i++) {
            objThreads[i] = vsiTest.new VsiTestThread(doClean,
                    doActiveContent, doMimeCheck, doProfileOnly,
                    instType, instName, actType, byteArray, objectName,
                    (threadType == 0), loops);
            objThreads[i].setName("VSI Scan Thread " + i);
            objThreads[i].start();
        }
        if (threadType == 1) {
            try {
                Thread.sleep(1000 * durationSeconds);
            } catch (InterruptedException e) {
                // $JL-EXC$
                // $JL-SYS_OUT_ERR$
            }
        } else if (threadType == 2) {
            objThreads[0].run();
            vse = ((VsiTestThread) objThreads[0]).getException();
            cInfo = ((VsiTestThread) objThreads[0]).getContent();
            if (vse != null)
                throw vse;
            return cInfo;
        }
        for (i = 0; i < threads; i++) {
            ((VsiTestThread) objThreads[i]).stopMe();
        }
        try {
            for (i = 0; i < threads; i++)
                objThreads[i].join();
        } catch (InterruptedException e) {
            // $JL-EXC$
            // $JL-SYS_OUT_ERR$
        }
        vse = ((VsiTestThread) objThreads[0]).getException();
        cInfo = ((VsiTestThread) objThreads[0]).getContent();
        if (vse != null)
            throw vse;
        return cInfo;
    }

    /**
     * Static scan function. This is a generic scan/clean function wrapper which
     * can be used also outside of "VsiTest" - therefore it is static.
     * <p>
     * You must pass the reference of the "VSIService" object which you have to
     * create first by starting the VSI framework.
     * <p>
     * All other parameters are passed directly to the VSI-API.
     * 
     * @param doClean
     *            Flag weather a clean or scan method should be invoked.
     * @param instType
     *            <ul>
     *            Type of the instance (see <code>Instance</code>): <li>0:
     *            Profile <li>1: Group <li>2: Provider
     *            </ul>
     * @param instName
     *            Name of the instance object (Profile/Group/Provider). Defined
     *            before in configuration. If this String is "", then we use the
     *            default one. This way is used only here, in VSI-API there is
     *            an extra method for.
     * @param actType
     *            Action type to be performed
     *            <ul>
     *            Type of the action (see <code>Instance</code>): <li>0: File
     *            scan <li>1: Byte (array) scan <li>2: Stream (InputStream) scan
     *            </ul>
     * @param byteArray
     *            Scan a byte array
     * @param objectName
     *            Pass an object name for the action or use this as "file name"
     *            to be scanned.
     * 
     * @throws VSIServiceException
     * @throws VirusScanException
     * @throws VirusInfectionException
     * 
     * @see com.sap.security.core.server.vsi.api.Instance
     * @see VSIServiceException
     * @see VirusScanException
     * @see VirusInfectionException
     * 
     */
    public static ContentInfo[] execVsiScan(
                                            boolean doClean,
                                            boolean doActiveContent,
                                            boolean doMimeCheck,
                                            boolean doProfileOnly,
                                            int instType,
                                            String instName,
                                            int actType,
                                            byte[] byteArray,
                                            String objectName)
                                                              throws VSIServiceException,
                                                              VirusScanException,
                                                              VirusInfectionException,
                                                              IOException {
        Instance inst = null;
        VSIService obj = VSIServiceFactory.getService();
        if(obj==null)             
            throw new VSIServiceException(
                VSIServiceMessage.getMessage(2), null);
        // //////////////////////////////////////////////////////////
        // switch for instance type (profile, group, provider)
        // //////////////////////////////////////////////////////////
        switch (instType) {
        case 0:
            if (instName == null || instName.length() == 0)
                inst = obj.getInstance();
            else
                inst = obj.getInstance(instName);
            break;
        case 1:
            if (instName == null || instName.length() == 0)
                inst = obj.getInstanceByGroup();
            else
                inst = obj.getInstanceByGroup(instName);
            break;
        case 2:
            if (instName == null || instName.length() == 0)
                inst = obj.getInstanceByProvider();
            else
                inst = obj.getInstanceByProvider(instName);
            break;
        default:
            throw new VSIServiceException(
                    VSIServiceMessage.getMessage(3), null);
        }
        if (inst == null)
            throw new VSIServiceException(
                    VSIServiceMessage.getMessage(2), null);

        try {
            if (doProfileOnly == true) {
                inst.setDefaultConfig();
            }
            if (doClean == true)
                inst.setParameter(new Parameter("CUST_CLEAN", "BOOL",
                        "1"));
            if (doActiveContent == true)
                inst.setParameter(new Parameter("CUST_ACTIVE_CONTENT",
                        "BOOL", "1"));
            if (doMimeCheck == true)
                inst.setParameter(new Parameter("CUST_CHECK_MIME_TYPE",
                        "BOOL", "1"));
            // ///////////////////////////////////////////////////////////////////
            // switch for object or action type (scanFile, scanBytes,
            // scanStream)
            // ///////////////////////////////////////////////////////////////////
            switch (actType) {
            case 0: // file scan
                inst.scanFileEx(doClean, objectName);
                break;
            case 1: // byte scan
                inst.scanBytesEx(doClean, objectName, byteArray,
                        byteArray.length);
                break;
            case 2: // stream scan
                VSIFilterInputStream vin = null;
                HttpURLConnection connection = null;
                URL url = null;
                try {
                    url = new URL(objectName);
                    connection = (HttpURLConnection) url
                            .openConnection();
                } catch (Exception e) {
                    throw new IOException("Exception in " + e);
                }
                // select were the stream should be stored locally
                JFileChooser fileChooser = new JFileChooser();
                fileChooser
                        .setDialogTitle("Select a file where the stream should be stored.");
                int result = fileChooser.showSaveDialog(null);

                if (result != JFileChooser.APPROVE_OPTION) {
                    // user did not pressed the OK button
                    throw new IOException(
                            "Select a file where the HTTP stream should be stored.");
                } else if (result == JFileChooser.APPROVE_OPTION) {
                    // initialize values, here the content length
                    int size = connection.getContentLength();
                    // set up VSI input stream for URL
                    vin = obj.createVSIStream(connection
                            .getInputStream());
                    // ///////////////////////////
                    // stream scan
                    // ///////////////////////////
                    inst.scanStreamEx(doClean, objectName, vin, size);
                    // set up output stream
                    OutputStream out = new FileOutputStream(
                            fileChooser.getSelectedFile());
                    int read = 0;
                    // create buffer
                    byte[] buffer = new byte[8192];
                    while (read < size) {
                        if (vin.available() > 0) {
                            // read from stream
                            int readLen = vin.read(buffer);
                            read += readLen;
                            // write to output file
                            out.write(buffer, 0, readLen);
                        }
                    }
                    out.close(); // cleanup
                    vin.close(); // cleanup
                }
                connection.disconnect(); // cleanup
                break;
            default:
                // undefined situation
                throw new VSIServiceException(
                        VSIServiceMessage.getMessage(3), null);
            }
            return inst.getContentInfo();
        } finally {
            // cleanup
            obj.releaseInstance(inst);
        }
    }

    private class VsiTestThread extends Thread {

        boolean doClean;
        boolean doActiveContent;
        boolean doMimeCheck;
        boolean doProfileOnly;
        boolean doRun = true;
        int instType;
        String instName;
        int actType;
        byte[] byteArray;
        String objectName;
        int loopAction = 1;
        boolean autoend;

        ContentInfo[] cInfo = null;
        VSIServiceException vse = null;

        public VsiTestThread(boolean doClean,
                             boolean doActiveContent,
                             boolean doMimeCheck,
                             boolean doProfileOnly,
                             int instType,
                             String instName,
                             int actType,
                             byte[] byteArray,
                             String objectName,
                             boolean autoend,
                             int loopAction) {
            this.doClean = doClean;
            this.doActiveContent = doActiveContent;
            this.doMimeCheck = doMimeCheck;
            this.doProfileOnly = doProfileOnly;
            this.instType = instType;
            this.instName = instName;
            this.actType = actType;
            this.byteArray = byteArray;
            this.objectName = objectName;
            this.loopAction = loopAction;
            this.autoend = autoend;
        }

        public void run() {
            super.run();
            int i = 0;
            while ((autoend == false && doRun == true)
                    || (autoend == true && i < this.loopAction)) {
                try {
                    cInfo = execVsiScan(doClean, doActiveContent,
                            doMimeCheck, doProfileOnly, instType,
                            instName, actType, byteArray, objectName);
                } catch (VirusScanException e) {
                    if (vse == null)
                        vse = e;
                } catch (VirusInfectionException e) {
                    if (vse == null)
                        vse = e;
                } catch (VSIServiceException e) {
                    if (vse == null)
                        vse = e;
                } catch (IOException e) {
                    if (vse == null)
                        vse = new VSIServiceException(e);
                } catch (Exception e) {
                    if (vse == null)
                        vse = new VSIServiceException(e);
                }
                i++;
            }
        }

        public void stopMe() {
            doRun = false;
        }

        public synchronized void start() {
            super.start();
            doRun = true;
        }

        public VSIServiceException getException() {
            return vse;
        }

        public ContentInfo[] getContent() {
            return cInfo;
        }
    }

    /**
     * Help function to initialize the JComponents
     * 
     * @return JFrame for the application
     * @throws Exception
     */
    private JFrame initComponents() throws Exception {

        final JTabbedPane vsiTabPanel = new javax.swing.JTabbedPane();
        System.out.println("VSI framework started ... ");  //$JL-SYS_OUT_ERR$
        vsiTabPanel.addTab(
                "Configuration",
                new VSIRuntimePanel(((VSIRuntimeConfig) VSIServiceFactory.getService()).getRuntimeInterface()));
        vsiTabPanel.addTab("Info", _vsiResultPanel);
        vsiTabPanel.addTab("Test", _vsiTestPanel);
        vsiTabPanel.setName("VsiTesTabPane");
        vsiTabPanel.setSelectedIndex(2);
        vsiTabPanel.addChangeListener(new javax.swing.event.ChangeListener() {
                    public void stateChanged(javax.swing.event.ChangeEvent evt) {
                        vsiTestTabPaneStateChanged(evt);
                    }
                });
        _vsiTestPanel.resetPanel();
        ImageIcon img = new ImageIcon(VsiTest.class.getResource("sap.png"));
        JFrame frame = new JFrame("Virus Scan Provider (stand-alone)");
        frame.setIconImage(img.getImage());
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                processWindowEvent(e);
                super.windowClosing(e);
            }

        });
        frame.getContentPane().add(vsiTabPanel);
        frame.setSize(800, 700);
        frame.setLocation(100, 100);
        frame.setVisible(true);
        return frame;
    }

    /**
     * Event handler which is used when terminating the GUI.
     * 
     * @param e
     *            Event
     */
    private void processWindowEvent(WindowEvent e) {
        try {
            VSIServiceFrame.shutdown();
            System.out.println("VSI framework stopped ... ");  //$JL-SYS_OUT_ERR$
        } catch (Exception ee) {
            // $JL-EXC$
            // $JL-SYS_OUT_ERR$
            System.out.println("Exception.....................");  //$JL-SYS_OUT_ERR$
        }
    }

    /**
     * Event of the TAB change
     * 
     * @param evt
     *            Event
     */
    private void vsiTestTabPaneStateChanged(
                                            javax.swing.event.ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane) evt.getSource();
        switch (pane.getSelectedIndex()) {
        case 0: // Configuration:
            break;
        case 1: // Info:
            _vsiTestPanel.resetInfoPanel();
            break;
        case 2: // Test:
            _vsiTestPanel.resetPanel();
            break;
        default:
            break;
        }

    }

    /**
     * Helper: printout the online help to VsiTest
     */
    static private String printUsage() {
        String usageText = new String(
                " Usage:                                                           \n"
                        + "   java -jar com.sap.security.nw.vsi [command] [options] [file] \n\n"
                        + " Commands:                                                        \n"
                        + "   help        help about the program commands and options        \n"
                        + "   info        return the AV version information                  \n"
                        + "   scan        scan a single file with SAP internal API           \n"
                        + "   scanbyte    scan either EICAR or SHAKESPEARE with SAP API      \n"
                        + "   scanthreads parallel scan of byte arrays Multi-Threaded        \n\n"
                        + " Options:                                                         \n"
                        + "   [-cfg config file] [-V VSA_LIB path] [-f trace file] [-buffer] \n"
                        + "   [-l trace level (0|1|2|3)] [-T max. threads] [-r loop count]   \n");
        return usageText;
    }

    static private String printHelp() {
        return new String(
                " Usage:                                                           \n"
                        + "   java -jar com.sap.security.nw.vsi [command] [options] [file] \n\n"
                        + " Commands:                                                        \n"
                        + "   help        Show the program commands and options              \n"
                        + "   info        Print out the configuration and the                \n"
                        + "               AV version information                             \n"
                        + "   scan        Scan a single file                                 \n"
                        + "               with SAP VSI API                                   \n"
                        + "   scanbyte    Scan a byte array, using interanl                  \n"
                        + "               EICAR or SHAKESPEARE with SAP API                  \n"
                        + "   scanthreads Scan of byte array in Multi-Threaded               \n"
                        + "               environment                                        \n\n"
                        + " Options:                                                         \n"
                        + "   -cfg        Configuration file containing the properties       \n"
                        + "   -V          VSA_LIB path                                       \n"
                        + "   -f          Trace file                                         \n"
                        + "   -buffer     Options can be used for command scan. The local    \n"
                        + "               file will be loaded into a byte array and scanned  \n"
                        + "   -l          Trace level (0|1|2|3)]                             \n"
                        + "   -T          Max. threads                                       \n"
                        + "   -r          Loop count for command scanthreads                 \n");
    }

    /**
     * Return the version of AV engine and configuration
     * 
     * @return
     */
    private static String getVersionInfo() throws VSIServiceException {
        int i, ii;
        VSIService _vsi = VSIServiceFactory.getService();
        Instance _v = null;
        StringBuffer tBuff = new StringBuffer();
        if(_vsi == null)
           throw new VSIServiceException(new Exception("VSI service start failed"));
        tBuff.append("=========================================================================\n");
        tBuff.append("Defaults:\n");
        tBuff.append("Profile : ");
        tBuff.append(_vsi.getProfile().getName());
        tBuff.append("\nGroup   : ");
        tBuff.append(_vsi.getGroup().getName());
        tBuff.append("\nProvider: ");
        try {
            if (_vsi.getProvider() != null)
                tBuff.append(_vsi.getProvider().getName());
        } catch (VSIServiceException e) {
            tBuff.append("<none>");
        }
        tBuff.append("\n=========================================================================\n");
        if (_vsi.getProfiles().length == 0)
            tBuff.append("No profiles available");
        for (i = 0; i < _vsi.getProfiles().length; i++) {
            Profile pro = _vsi.getProfile(i);
            tBuff.append("Profile name: ");
            tBuff.append(pro.getName());
            tBuff.append("\nIs Active   : ");
            tBuff.append(pro.isActive() ? "Yes" : "No");
            tBuff.append("\nIs Available: ");
            try {
                if (pro.isActive()) {
                    _v = _vsi.getInstance(i);
                    tBuff.append("Yes");
                } else {
                    tBuff.append("No");
                }
            } catch (VSIServiceException e) {
                tBuff.append("No, error: ");
                tBuff.append(e.getMessage());
            } finally {
                if(_v != null)
                   _vsi.releaseInstance(_v);
            }
            if (pro.getReferenceProfile() == null) {
                tBuff.append("\nCondition   : ");
                tBuff.append(pro.getProfileLinkCondition() == Profile.PROFILE_AND_LINKED ? 
                          "All steps"
                        : "At least one step");
                tBuff.append("\n       Steps: \n");
                for (ii = 0; ii < pro.getProfileSteps().length; ii++) {
                    tBuff.append("              ");
                    tBuff.append(ii + 1);
                    tBuff.append(". ");
                    tBuff.append(pro.getProfileSteps()[ii][0]);
                    tBuff.append(" : ");
                    tBuff.append(pro.getProfileSteps()[ii][1]);
                    tBuff.append("\n");
                }
            } else {
                tBuff.append("\nReference   : ");
                tBuff.append(pro.getReferenceProfile());
            }
            for (ii = 0; ii < pro.getParameters().length; ii++) {
                Parameter par = pro.getParameters()[ii];
                tBuff.append("\n   Parameter: ");
                tBuff.append(par.getParameterName());
                tBuff.append("\n              ");
                tBuff.append(par.getParameterValue());
            }
            if (i < _vsi.getProfiles().length - 1)
                tBuff.append("\n-------------------------------------------------------------------------\n");
        }
        tBuff.append("\n=========================================================================\n");
        if (_vsi.getGroups().length == 0)
            tBuff.append("No groups configured");
        for (i = 0; i < _vsi.getGroups().length; i++) {
            Group grp = _vsi.getGroup(i);
            tBuff.append("Group name  : ");
            tBuff.append(grp.getName());
            for (ii = 0; ii < grp.getProviders().length; ii++) {
                tBuff.append("\n   Providers: ");
                tBuff.append("\n              ");
                tBuff.append(grp.getProviders()[ii]);
            }

            for (ii = 0; ii < grp.getParameters().length; ii++) {
                Parameter par = grp.getParameters()[ii];
                tBuff.append("\n   Parameter: ");
                tBuff.append(par.getParameterName());
                tBuff.append("\n              ");
                tBuff.append(par.getParameterValue());
            }
            if (i < _vsi.getGroups().length - 1)
                tBuff.append("\n-------------------------------------------------------------------------\n");
        }
        tBuff.append("\n=========================================================================\n");
        if (_vsi.getGroups().length == 0)
            tBuff.append("No provider available");
        for (i = 0; i < _vsi.getProviders().length; i++) {
            Provider prov;
            try {
                prov = _vsi.getProvider(i);
            } catch (VSIServiceException e) {
                continue;
            }
            tBuff.append("Provider    : ");
            tBuff.append(prov.getName());
            tBuff.append("\nType        : ");
            tBuff.append(prov.isServer() ? "Server" : "Adapter");
            tBuff.append("\nVSA Version : ");
            tBuff.append(prov.getAdapter().getVsaMajorVersion());
            tBuff.append(".");
            tBuff.append(prov.getAdapter().getVsaMinorVersion());
            tBuff.append("\nVendor Info : ");
            tBuff.append(prov.getAdapter().getVendorInfoText());
            tBuff.append("\nProduct Name: ");
            tBuff.append(prov.getAdapter().getVsaVendorName());
            for (ii = 0; ii < prov.getParameters().length; ii++) {
                Parameter par = prov.getParameters()[ii];
                tBuff.append("\n   Parameter: ");
                tBuff.append(par.getParameterName());
                tBuff.append("\n              ");
                tBuff.append(par.getParameterValue());
            }
            tBuff.append("\nEngine Version : ");
            tBuff.append(prov.getEngine().getEngineMajorVersion());
            tBuff.append(".");
            tBuff.append(prov.getEngine().getEngineMinorVersion());
            tBuff.append("\nEngine String  : ");
            tBuff.append(prov.getEngine().getEngineVersion());
            tBuff.append("\nEngine Known-V#: ");
            tBuff.append(prov.getEngine().getKnownViruses());
            tBuff.append("\nEngine Data    : ");
            tBuff.append(prov.getEngine().getEngineDate());
            for (ii = 0; ii < prov.getEngine().getNumberOfDrivers(); ii++) {
                Driver drv = prov.getDrivers()[ii];
                tBuff.append("\nDrivers        : ");
                tBuff.append(ii + 1);
                tBuff.append(". ");
                tBuff.append(drv.getDriverName());
                tBuff.append(" , Date: ");
                tBuff.append(drv.getDriverDate());
            }
            if (i < _vsi.getProviders().length - 1)
                tBuff.append("\n-------------------------------------------------------------------------\n");
        }
        tBuff.append("\n=========================================================================\n");
        return tBuff.toString();
    }

    /**
     * Helper: Read a file into a byte array.
     * 
     * @param file
     *            FileName
     * @return ByteArray
     */
    static private byte[] fileRead(String file) {
        File f = new File(file);
        byte[] b = new byte[(int) f.length()];
        try {
            FileInputStream in = new FileInputStream(file);
            /* Read file into byte array */
            in.read(b);
        } catch (Exception e) {
            // $JL-EXC$
            // $JL-SYS_OUT_ERR$
            System.out.println(e); //$JL-SYS_OUT_ERR$
        }
        return b;
    }

    /**
     * Helper: Write a byte array to file.
     * 
     * @param file
     *            FileName
     * @param b
     *            ByteArray
     */
    static private void fileWrite(String file, byte[] b) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            /* Write bytes to file */
            out.write(b);
            out.close();
        } catch (Exception e) {
            // $JL-EXC$
            // $JL-SYS_OUT_ERR$
            // System.out.println(e.toString());
        }
    }

    /**
     * Private Class to create a JPanel with components to test this framework.
     * <p>
     * The swing components are placed in the same order as the ABAP program
     * RSVSCANTEST (transaction: VSCANTEST) due to have the same perspective.
     * 
     * @author Markus Strehle (d036670)
     */
    private class VsiTestPanel extends javax.swing.JPanel {
        private com.sap.security.core.server.vsi.api.Provider vsiProviderInfo = null;
        static final long serialVersionUID = 5895594137474551067L;

        /** Creates new form VsiTest */
        public VsiTestPanel() {
            initComponents();
            int i;
            vsiResultText.setForeground(new java.awt.Color(255, 0, 0));
            vsiComboAction.addItem("Check Only");
            vsiComboAction.addItem("Check and Clean");
            vsiComboAction.addItem("Check for Active Content");
            vsiComboAction.addItem("Determine MIME Content");
            vsiComboAction.addItem("Use Profile's Settings");
            vsiComboAction.setSelectedIndex(4);
            vsiCombo1.addItem("EICAR Anti-Virus Test File");
            vsiCombo1.addItem("Shakespeare: Sonnet 18 (ASCII)");
            vsiDurationAction.addItem("Single Execution");
            vsiDurationAction.addItem("Looped Execution");
            vsiDurationAction.addItem("Endless Execution");
            for (i = 1; i < 100; i++)
                vsiThreadAction.addItem(new Integer(i).toString());
            for (i = 1; i < 11; i++)
                vsiLoopAction.addItem(new Integer(i).toString());
            vsiDurationText.setVisible(false);
            vsiLoopAction.setEnabled(true);
            jLabel7.setVisible(false);
            vsiRadioBtn1.setSelected(true);
            vsiFileChoseF.setEnabled(false);
            vsiFileChoser.setEnabled(false);
            vsiURLChoseF.setEnabled(false);
            vsiURLChoseF.setText("http://eicar.org/download/eicar.com");
            vsiRadioS1.setSelected(true);
            jcheckFileAsBuffer.setEnabled(false);
            vsiComboS2.setEnabled(false);
            vsiComboS3.setEnabled(false);
            jLabel3.setPreferredSize(new java.awt.Dimension(150, 21));
        }

        /**
         * Return the Test JPanel
         * 
         * @return
         */
        public javax.swing.JPanel getTestPanel() {
            return jvsiTestPanel;
        }

        /**
         * Return the Info JPanel
         * 
         * @return
         */
        public javax.swing.JPanel getInfoPanel() {
            return jvsiResultPanel;
        }

        /**
         * Initialize Info Tables on Info TAB
         */
        public void resetInfoTables() {
            ((javax.swing.table.DefaultTableModel) vsiDriverTable
                    .getModel()).setRowCount(0);
            vsiDriverTable.removeAll();
            ((javax.swing.table.DefaultTableModel) vsiParamTable
                    .getModel()).setRowCount(0);
            vsiParamTable.removeAll();
            vsiDriverLabel.setText("Loaded Drivers");
            vsiParamLabel.setText("Supported Parameters");
            vsiEngineTable.setValueAt("", 0, 1);
            vsiEngineTable.setValueAt("", 1, 1);
            vsiEngineTable.setValueAt("", 2, 1);
            vsiEngineTable.setValueAt("", 3, 1);
            vsiServerTable.setValueAt("", 0, 1);
            vsiServerTable.setValueAt("", 1, 1);
            vsiServerTable.setValueAt("", 2, 1);
            vsiServerTable.setValueAt("", 3, 1);
            vsiAdapterTable.setValueAt("", 0, 1);
            vsiAdapterTable.setValueAt("", 1, 1);
            vsiAdapterTable.setValueAt("", 2, 1);
        }

        /**
         * reset this Info Panel and re-initialize it
         * 
         * @param vsiService
         *            VSIService object
         */
        public void resetInfoPanel() {
            VSIService vsiService = VSIServiceFactory.getService();
            if(vsiService==null) return;
            int i = 0;
            String[] providers = vsiService.getProviders();
            Provider _tmpProvider = vsiProviderInfo;
            vsiInfoProvider.removeAllItems();
            if (providers.length == 0) {
                resetInfoTables();
                vsiInfoProvider.addItem("");
                vsiProviderInfo = null;
                _tmpProvider = null;
            } else {
                for (i = 0; i < providers.length; i++) {
                    try {
                        vsiInfoProvider.addItem(vsiService.getProvider(providers[i]));
                    } catch (VSIServiceException e) {
                        // $JL-EXC$
                        continue;
                    }
                }
            }

            if (_tmpProvider != null) {
                vsiInfoProvider.setSelectedItem(_tmpProvider);
            }
            vsiEngineTable.setColumnSelectionAllowed(true);
            vsiDriverTable.setRowSelectionAllowed(true);
            vsiEngineTable.setColumnSelectionInterval(0, 0);
            vsiAdapterTable.setColumnSelectionAllowed(true);
            vsiAdapterTable.setColumnSelectionInterval(0, 0);
            vsiServerTable.setColumnSelectionAllowed(true);
            vsiServerTable.setColumnSelectionInterval(0, 0);
            vsiParamTable.setColumnSelectionAllowed(true);
            vsiParamTable.setColumnSelectionInterval(0, 0);
            vsiServerLabel.setVisible(false);
            vsiServerTable.setVisible(false);
            jScrollPane3.setVisible(false);
        }

        /**
         * reset this Panel and re-initialize it
         * 
         * @param vsiService
         *            VSIService object
         */
        public void resetPanel() {
            VSIService vsiService = VSIServiceFactory.getService();
            if(vsiService==null) return;
            int i = 0;
            vsiComboS1.removeAllItems();
            vsiComboS2.removeAllItems();
            vsiComboS3.removeAllItems();
            vsiInfoProvider.removeAllItems();
            vsiComboS1.addItem("");
            vsiComboS2.addItem("");
            vsiComboS3.addItem("");
            vsiInfoProvider.addItem("");
            String[] groups = vsiService.getGroups();
            String[] providers = vsiService.getProviders();
            String[] profiles = vsiService.getProfiles();
            for (i = 0; i < profiles.length; i++) {
                try {
                    if (vsiService.getProfile(profiles[i]).isActive())
                        vsiComboS1.addItem(profiles[i]);
                } catch (Exception e) {
                    // $JL-EXC$
                    continue;
                }
            }
            for (i = 0; i < providers.length; i++) {
                try {
                    if (vsiService.getProvider(providers[i]) != null)
                        vsiComboS3.addItem(providers[i]);
                    vsiInfoProvider.addItem(providers[i]);
                } catch (Exception e) {
                    // $JL-EXC$
                    continue;
                }
            }
            for (i = 0; i < groups.length; i++)
                vsiComboS2.addItem(groups[i]);
        }

        /**
         * This method is called from within the constructor to initialize the
         * form. WARNING: Do NOT modify this code. The content of this method is
         * always regenerated by the Form Editor.
         */
        // <editor-fold defaultstate="collapsed"
        // desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {
            java.awt.GridBagConstraints gridBagConstraints;

            vsiTestBtnGroup = new javax.swing.ButtonGroup();
            vsiScanBtnGroup = new javax.swing.ButtonGroup();
            jvsiTestPanel = new javax.swing.JPanel();
            vsiCombo1 = new javax.swing.JComboBox();
            jLabel1 = new javax.swing.JLabel();
            vsiRadioBtn3 = new javax.swing.JRadioButton();
            vsiRadioBtn2 = new javax.swing.JRadioButton();
            vsiRadioBtn1 = new javax.swing.JRadioButton();
            vsiFileChoser = new javax.swing.JButton();
            vsiURLChoseF = new javax.swing.JTextField();
            jLabel2 = new javax.swing.JLabel();
            vsiRadioS1 = new javax.swing.JRadioButton();
            vsiRadioS2 = new javax.swing.JRadioButton();
            vsiRadioS3 = new javax.swing.JRadioButton();
            vsiComboS1 = new javax.swing.JComboBox();
            vsiComboS2 = new javax.swing.JComboBox();
            vsiComboS3 = new javax.swing.JComboBox();
            jLabel3 = new javax.swing.JLabel();
            jLabel4 = new javax.swing.JLabel();
            vsiComboAction = new javax.swing.JComboBox();
            jSeparator1 = new javax.swing.JSeparator();
            vsiResultText = new javax.swing.JTextArea();
            vsiSubmitBtn = new javax.swing.JButton();
            vsiFileChoseF = new javax.swing.JTextField();
            jLabel5 = new javax.swing.JLabel();
            jLabel6 = new javax.swing.JLabel();
            vsiDurationAction = new javax.swing.JComboBox();
            vsiDurationText = new javax.swing.JTextField();
            vsiThreadAction = new javax.swing.JComboBox();
            vsiLoopAction = new javax.swing.JComboBox();
            jLabel7 = new javax.swing.JLabel();
            jLabel8 = new javax.swing.JLabel();
            jcheckFileAsBuffer = new javax.swing.JCheckBox();
            jvsiResultPanel = new javax.swing.JPanel();
            vsiInfoProviderL = new javax.swing.JLabel();
            vsiInfoProvider = new javax.swing.JComboBox();
            vsiEngineLabel = new javax.swing.JLabel();
            jScrollPane1 = new javax.swing.JScrollPane();
            vsiEngineTable = new javax.swing.JTable();
            vsiDriverLabel = new javax.swing.JLabel();
            jScrollPane2 = new javax.swing.JScrollPane();
            vsiDriverTable = new javax.swing.JTable();
            vsiServerLabel = new javax.swing.JLabel();
            jScrollPane3 = new javax.swing.JScrollPane();
            vsiServerTable = new javax.swing.JTable();
            vsiAdapterLabel = new javax.swing.JLabel();
            jScrollPane4 = new javax.swing.JScrollPane();
            vsiAdapterTable = new javax.swing.JTable();
            vsiParamLabel = new javax.swing.JLabel();
            jScrollPane5 = new javax.swing.JScrollPane();
            vsiParamTable = new javax.swing.JTable();

            setLayout(new java.awt.BorderLayout());

            jvsiTestPanel.setLayout(new java.awt.GridBagLayout());

            vsiCombo1.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiCombo1.setPreferredSize(new java.awt.Dimension(210, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            jvsiTestPanel.add(vsiCombo1, gridBagConstraints);

            jLabel1.setText("Object to Be Checked");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiTestPanel.add(jLabel1, gridBagConstraints);
            jLabel1.getAccessibleContext().setAccessibleDescription("Object to Be Checked");
            vsiTestBtnGroup.add(vsiRadioBtn3);
            vsiRadioBtn3.setText("URL, HTTP Stream (e.g. http://localhost:1080)");
            vsiRadioBtn3.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn3.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn3.setPreferredSize(new java.awt.Dimension(280,23));
            vsiRadioBtn3.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioBtn3ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioBtn3, gridBagConstraints);
            vsiTestBtnGroup.add(vsiRadioBtn2);
            vsiRadioBtn2.setText("Local File");
            vsiRadioBtn2.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn2.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn2.setPreferredSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn2.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioBtn2ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioBtn2, gridBagConstraints);
            vsiTestBtnGroup.add(vsiRadioBtn1);
            vsiRadioBtn1.setText("Test data");
            vsiRadioBtn1.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn1.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn1.setPreferredSize(new java.awt.Dimension(280, 23));
            vsiRadioBtn1.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioBtn1ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioBtn1, gridBagConstraints);
            vsiFileChoser.setText("...");
            vsiFileChoser.setMaximumSize(new java.awt.Dimension(30, 25));
            vsiFileChoser.setMinimumSize(new java.awt.Dimension(30, 25));
            vsiFileChoser.setPreferredSize(new java.awt.Dimension(30, 25));
            vsiFileChoser.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiFileChoserActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 20, 0);
            jvsiTestPanel.add(vsiFileChoser, gridBagConstraints);
            vsiURLChoseF.setMinimumSize(new java.awt.Dimension(350, 21));
            vsiURLChoseF.setPreferredSize(new java.awt.Dimension(350, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 20, 0);
            jvsiTestPanel.add(vsiURLChoseF, gridBagConstraints);
            jLabel2.setText("Scanner Selection");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
            jvsiTestPanel.add(jLabel2, gridBagConstraints);
            vsiScanBtnGroup.add(vsiRadioS1);
            vsiRadioS1.setText("Virus Scan Profile");
            vsiRadioS1.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioS1.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioS1.setPreferredSize(new java.awt.Dimension(280, 23));
            vsiRadioS1.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioS1ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioS1, gridBagConstraints);
            vsiScanBtnGroup.add(vsiRadioS2);
            vsiRadioS2.setText("Scanner Group");
            vsiRadioS2.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioS2.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioS2.setPreferredSize(new java.awt.Dimension(280, 23));
            vsiRadioS2.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioS2ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioS2, gridBagConstraints);
            vsiScanBtnGroup.add(vsiRadioS3);
            vsiRadioS3.setText("Virus Scan Provider");
            vsiRadioS3.setMaximumSize(new java.awt.Dimension(280, 23));
            vsiRadioS3.setMinimumSize(new java.awt.Dimension(280, 23));
            vsiRadioS3.setPreferredSize(new java.awt.Dimension(280, 23));
            vsiRadioS3.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiRadioS3ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jvsiTestPanel.add(vsiRadioS3, gridBagConstraints);
            vsiComboS1.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiComboS1.setOpaque(false);
            vsiComboS1.setPreferredSize(new java.awt.Dimension(210, 21));
            vsiComboS1.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiComboS1ActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 11;
            jvsiTestPanel.add(vsiComboS1, gridBagConstraints);
            vsiComboS2.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiComboS2.setPreferredSize(new java.awt.Dimension(210, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 13;
            jvsiTestPanel.add(vsiComboS2, gridBagConstraints);
            vsiComboS3.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiComboS3.setPreferredSize(new java.awt.Dimension(210, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 15;
            jvsiTestPanel.add(vsiComboS3, gridBagConstraints);
            jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
            jLabel3.setLabelFor(vsiComboS1);
            jLabel3.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
            jLabel3.setMaximumSize(new java.awt.Dimension(30, 14));
            jLabel3.setMinimumSize(new java.awt.Dimension(30, 14));
            jLabel3.setPreferredSize(new java.awt.Dimension(30, 14));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 11;
            jvsiTestPanel.add(jLabel3, gridBagConstraints);
            jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
            jLabel4.setLabelFor(vsiComboAction);
            jLabel4.setText("Action");
            jLabel4.setOpaque(true);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 19;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiTestPanel.add(jLabel4, gridBagConstraints);
            vsiComboAction.setMinimumSize(new java.awt.Dimension(150, 21));
            vsiComboAction.setPreferredSize(new java.awt.Dimension(150, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 19;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiTestPanel.add(vsiComboAction, gridBagConstraints);
            jSeparator1.setMinimumSize(new java.awt.Dimension(350, 5));
            jSeparator1.setPreferredSize(new java.awt.Dimension(350, 5));
            jSeparator1.setVerifyInputWhenFocusTarget(false);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
            jvsiTestPanel.add(jSeparator1, gridBagConstraints);
            vsiResultText.setEditable(false);
            vsiResultText.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
            vsiResultText.setLineWrap(true);
            vsiResultText.setWrapStyleWord(true);
            vsiResultText.setOpaque(false);
            vsiResultText.setPreferredSize(new java.awt.Dimension(350, 100));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 23;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 20, 0);
            jvsiTestPanel.add(vsiResultText, gridBagConstraints);
            vsiSubmitBtn.setText("Execute the Test");
            vsiSubmitBtn.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiSubmitBtnActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 22;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 10, 0);
            jvsiTestPanel.add(vsiSubmitBtn, gridBagConstraints);
            vsiFileChoseF.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiFileChoseF.setPreferredSize(new java.awt.Dimension(210, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 20, 0);
            jvsiTestPanel.add(vsiFileChoseF, gridBagConstraints);
            jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
            jLabel5.setLabelFor(vsiComboAction);
            jLabel5.setText("Duration");
            jLabel5.setOpaque(true);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 20;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
            jvsiTestPanel.add(jLabel5, gridBagConstraints);
            jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
            jLabel6.setLabelFor(vsiComboAction);
            jLabel6.setText("Threads");
            jLabel6.setOpaque(true);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 21;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
            jvsiTestPanel.add(jLabel6, gridBagConstraints);
            vsiDurationAction.setMinimumSize(new java.awt.Dimension(130, 21));
            vsiDurationAction.setPreferredSize(new java.awt.Dimension(130, 21));
            vsiDurationAction.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiDurationActionActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 20;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiTestPanel.add(vsiDurationAction, gridBagConstraints);
            vsiDurationText.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
            vsiDurationText.setText("300");
            vsiDurationText.setPreferredSize(new java.awt.Dimension(50, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 20;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiTestPanel.add(vsiDurationText, gridBagConstraints);
            vsiThreadAction.setMinimumSize(new java.awt.Dimension(130, 21));
            vsiThreadAction.setPreferredSize(new java.awt.Dimension(50, 21));
            vsiThreadAction.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiThreadActionActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 21;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(10, 75, 0, 0);
            jvsiTestPanel.add(vsiThreadAction, gridBagConstraints);
            vsiLoopAction.setMinimumSize(new java.awt.Dimension(130, 21));
            vsiLoopAction.setPreferredSize(new java.awt.Dimension(50, 21));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 21;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
            gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
            jvsiTestPanel.add(vsiLoopAction, gridBagConstraints);
            jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
            jLabel7.setLabelFor(vsiComboAction);
            jLabel7.setText("seconds");
            jLabel7.setOpaque(true);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 20;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 5, 0, 0);
            jvsiTestPanel.add(jLabel7, gridBagConstraints);
            jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
            jLabel8.setLabelFor(vsiLoopAction);
            jLabel8.setText("Loops/Thread");
            jLabel8.setOpaque(true);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 21;
            gridBagConstraints.insets = new java.awt.Insets(10, 80, 0, 0);
            jvsiTestPanel.add(jLabel8, gridBagConstraints);
            jcheckFileAsBuffer.setActionCommand("jcheckFileAsBuffer");
            jcheckFileAsBuffer.setAutoscrolls(true);
            jcheckFileAsBuffer.setText("Scan File as ByteArray");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
            jvsiTestPanel.add(jcheckFileAsBuffer, gridBagConstraints);
            jcheckFileAsBuffer.getAccessibleContext().setAccessibleName("jcheckFileAsBuffer");
            add(jvsiTestPanel, java.awt.BorderLayout.NORTH);
            jvsiResultPanel.setLayout(new java.awt.GridBagLayout());
            vsiInfoProviderL.setLabelFor(vsiInfoProvider);
            vsiInfoProviderL.setText("Virus Scan Provider");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
            jvsiResultPanel.add(vsiInfoProviderL, gridBagConstraints);
            vsiInfoProvider.setMinimumSize(new java.awt.Dimension(210, 21));
            vsiInfoProvider.setPreferredSize(new java.awt.Dimension(210, 21));
            vsiInfoProvider.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            vsiInfoProviderActionPerformed(evt);
                        }
                    });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
            gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
            jvsiResultPanel.add(vsiInfoProvider, gridBagConstraints);
            vsiEngineLabel.setText("Engine Data");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiResultPanel.add(vsiEngineLabel, gridBagConstraints);
            jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
            jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
            jScrollPane1.setPreferredSize(new java.awt.Dimension(500, 69));
            vsiEngineTable.setModel(new javax.swing.table.DefaultTableModel(
                   new Object[][] { { "Version", null },
                                    { "Version Text", null },
                                    { "Date", null },
                                    { "Known Viruses", null } },
                            new String[] { "", "" }) {
                        Class[] types = new Class[] {
                                java.lang.String.class,
                                java.lang.String.class };
                        boolean[] canEdit = new boolean[] { false, false };

                        public Class getColumnClass(int columnIndex) {
                            return types[columnIndex];
                        }

                        public boolean isCellEditable(
                                                      int rowIndex,
                                                      int columnIndex) {
                            return canEdit[columnIndex];
                        }
                    });
            vsiEngineTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
            vsiEngineTable.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            vsiEngineTable.setMinimumSize(new java.awt.Dimension(30, 30));
            vsiEngineTable.setPreferredSize(new java.awt.Dimension(500, 65));
            vsiEngineTable.setRowSelectionAllowed(false);
            vsiEngineTable.setSelectionBackground(new java.awt.Color(0, 255, 255));
            vsiEngineTable.getTableHeader().setReorderingAllowed(false);
            vsiEngineTable.setVerifyInputWhenFocusTarget(false);
            jScrollPane1.setViewportView(vsiEngineTable);
            vsiEngineTable.getColumnModel().getSelectionModel().setSelectionMode(
                            javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
            vsiEngineTable.getColumnModel().getColumn(0).setResizable(false);
            vsiEngineTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            vsiEngineTable.getColumnModel().getColumn(1).setResizable(false);
            vsiEngineTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
            gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
            jvsiResultPanel.add(jScrollPane1, gridBagConstraints);
            vsiDriverLabel.setText("Loaded Drivers");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiResultPanel.add(vsiDriverLabel, gridBagConstraints);
            jScrollPane2.setAutoscrolls(true);
            jScrollPane2.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 100));

            vsiDriverTable.setModel(new javax.swing.table.DefaultTableModel(
                            new Object[][] {
                            }, new String[] { "Version", "Driver Name",
                                              "Date", "Known Viruses" }) {
                        Class[] types = new Class[] {
                                java.lang.String.class,
                                java.lang.String.class,
                                java.lang.Object.class,
                                java.lang.Object.class };
                        boolean[] canEdit = new boolean[] { false,
                                false, false, false };

                        public Class getColumnClass(int columnIndex) {
                            return types[columnIndex];
                        }

                        public boolean isCellEditable(
                                                      int rowIndex,
                                                      int columnIndex) {
                            return canEdit[columnIndex];
                        }
                    });
            vsiDriverTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
            vsiDriverTable.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            vsiDriverTable.setMinimumSize(new java.awt.Dimension(30, 30));
            vsiDriverTable.setPreferredSize(new java.awt.Dimension(500, 100));
            vsiDriverTable.setRowSelectionAllowed(false);
            vsiDriverTable.setSelectionBackground(new java.awt.Color(204, 204, 204));
            vsiDriverTable.getTableHeader().setReorderingAllowed(false);
            vsiDriverTable.setVerifyInputWhenFocusTarget(false);
            jScrollPane2.setViewportView(vsiDriverTable);
            vsiDriverTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            vsiDriverTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            vsiDriverTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            vsiDriverTable.getColumnModel().getColumn(3).setPreferredWidth(50);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 10;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
            gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
            jvsiResultPanel.add(jScrollPane2, gridBagConstraints);

            vsiServerLabel.setText("Virus Scan Server  ");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiResultPanel.add(vsiServerLabel, gridBagConstraints);
            vsiServerLabel.getAccessibleContext().setAccessibleName("Server Data");

            jScrollPane3.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
            jScrollPane3.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
            jScrollPane3.setPreferredSize(new java.awt.Dimension(500, 69));

            vsiServerTable.setModel(new javax.swing.table.DefaultTableModel(
                   new Object[][] { { "Version", null },
                                    { "Version Text", null },
                                    { "Start Time", null },
                                    { "Build Data", null } },
                            new String[] { "", "" }) {
                        Class[] types = new Class[] {
                                java.lang.String.class,
                                java.lang.String.class };
                        boolean[] canEdit = new boolean[] { false,
                                false };

                        public Class getColumnClass(int columnIndex) {
                            return types[columnIndex];
                        }

                        public boolean isCellEditable(
                                                      int rowIndex,
                                                      int columnIndex) {
                            return canEdit[columnIndex];
                        }
                    });
            vsiServerTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
            vsiServerTable.setColumnSelectionAllowed(true);
            vsiServerTable.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            vsiServerTable.setMinimumSize(new java.awt.Dimension(30, 30));
            vsiServerTable.setPreferredSize(new java.awt.Dimension(500, 65));
            vsiServerTable.setRowSelectionAllowed(false);
            vsiServerTable.setSelectionBackground(new java.awt.Color(0, 255, 255));
            vsiServerTable.getTableHeader().setReorderingAllowed(false);
            vsiServerTable.setVerifyInputWhenFocusTarget(false);
            jScrollPane3.setViewportView(vsiServerTable);
            vsiServerTable.getColumnModel().getSelectionModel().setSelectionMode(
                            javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
            vsiServerTable.getColumnModel().getColumn(0).setResizable(false);
            vsiServerTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            vsiServerTable.getColumnModel().getColumn(1).setResizable(false);
            vsiServerTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
            gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
            jvsiResultPanel.add(jScrollPane3, gridBagConstraints);
            vsiAdapterLabel.setText("Adapter Data");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiResultPanel.add(vsiAdapterLabel, gridBagConstraints);
            jScrollPane4.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
            jScrollPane4.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
            jScrollPane4.setPreferredSize(new java.awt.Dimension(500, 50));

            vsiAdapterTable.setModel(new javax.swing.table.DefaultTableModel(
                   new Object[][] { { "Manufacturer", null },
                                    { "Product Name", null },
                                    { "Version", null } },
                            new String[] { "", "" }) {
                        Class[] types = new Class[] {
                                java.lang.String.class,
                                java.lang.String.class };
                        boolean[] canEdit = new boolean[] { false,
                                false };

                        public Class getColumnClass(int columnIndex) {
                            return types[columnIndex];
                        }

                        public boolean isCellEditable(
                                                      int rowIndex,
                                                      int columnIndex) {
                            return canEdit[columnIndex];
                        }
                    });
            vsiAdapterTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
            vsiAdapterTable.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            vsiAdapterTable.setMinimumSize(new java.awt.Dimension(30, 30));
            vsiAdapterTable.setPreferredSize(new java.awt.Dimension(500, 50));
            vsiAdapterTable.setRowSelectionAllowed(false);
            vsiAdapterTable.setSelectionBackground(new java.awt.Color(0, 255, 255));
            vsiAdapterTable.getTableHeader().setReorderingAllowed(false);
            vsiAdapterTable.setVerifyInputWhenFocusTarget(false);
            jScrollPane4.setViewportView(vsiAdapterTable);
            vsiAdapterTable.getColumnModel().getSelectionModel().setSelectionMode(
                            javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
            vsiAdapterTable.getColumnModel().getColumn(0).setResizable(false);
            vsiAdapterTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            vsiAdapterTable.getColumnModel().getColumn(1).setResizable(false);
            vsiAdapterTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 10;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
            jvsiResultPanel.add(jScrollPane4, gridBagConstraints);
            vsiParamLabel.setText("Supported Parameters");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 0);
            jvsiResultPanel.add(vsiParamLabel, gridBagConstraints);
            jScrollPane5.setAutoscrolls(true);
            jScrollPane5.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            jScrollPane5.setPreferredSize(new java.awt.Dimension(500, 100));
            vsiParamTable.setModel(new javax.swing.table.DefaultTableModel(
                            new Object[][] {
                            }, new String[] { "Parameters", "Type",
                                    "Initial", "Value" }) {
                        Class[] types = new Class[] {
                                java.lang.String.class,
                                java.lang.String.class,
                                java.lang.Object.class,
                                java.lang.Object.class };
                        boolean[] canEdit = new boolean[] { false,
                                false, false, false };

                        public Class getColumnClass(int columnIndex) {
                            return types[columnIndex];
                        }

                        public boolean isCellEditable(
                                                      int rowIndex,
                                                      int columnIndex) {
                            return canEdit[columnIndex];
                        }
                    });
            vsiParamTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
            vsiParamTable.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            vsiParamTable.setMinimumSize(new java.awt.Dimension(30, 30));
            vsiParamTable.setPreferredSize(new java.awt.Dimension(500, 150));
            vsiParamTable.setRowSelectionAllowed(false);
            vsiParamTable.setSelectionBackground(new java.awt.Color(0, 255, 255));
            vsiParamTable.getTableHeader().setReorderingAllowed(false);
            vsiParamTable.setVerifyInputWhenFocusTarget(false);
            jScrollPane5.setViewportView(vsiParamTable);
            vsiParamTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            vsiParamTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            vsiParamTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            vsiParamTable.getColumnModel().getColumn(3).setPreferredWidth(50);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 10;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
            gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
            jvsiResultPanel.add(jScrollPane5, gridBagConstraints);
            add(jvsiResultPanel, java.awt.BorderLayout.CENTER);
        }// </editor-fold>//GEN-END:initComponents

        private void vsiFileChoserActionPerformed(
                                                  java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiFileChoserActionPerformed
            // FILE OPEN DIALOG
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Select a Virus Scan Adapter");
            int returnVal = fc.showOpenDialog(this);

            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();
                vsiFileChoseF.setText(file.getAbsolutePath());
            }
        }// GEN-LAST:event_vsiFileChoserActionPerformed

        private void vsiRadioBtn1ActionPerformed(
                                                 java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioBtn1ActionPerformed
            //
            vsiFileChoseF.setEnabled(false);
            vsiFileChoser.setEnabled(false);
            vsiURLChoseF.setEnabled(false);
            jcheckFileAsBuffer.setEnabled(false);
            vsiCombo1.setEnabled(true);
        }// GEN-LAST:event_vsiRadioBtn1ActionPerformed

        private void vsiRadioBtn2ActionPerformed(
                                                 java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioBtn2ActionPerformed
            //
            vsiFileChoseF.setEnabled(true);
            vsiFileChoser.setEnabled(true);
            vsiURLChoseF.setEnabled(false);
            jcheckFileAsBuffer.setEnabled(true);
            vsiCombo1.setEnabled(false);
        }// GEN-LAST:event_vsiRadioBtn2ActionPerformed

        private void vsiRadioS3ActionPerformed(
                                               java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioS3ActionPerformed
            //
            vsiComboS1.setEnabled(false);
            vsiComboS2.setEnabled(false);
            vsiComboS3.setEnabled(true);
        }// GEN-LAST:event_vsiRadioS3ActionPerformed

        private void vsiRadioS2ActionPerformed(
                                               java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioS2ActionPerformed
            //
            vsiComboS1.setEnabled(false);
            vsiComboS2.setEnabled(true);
            vsiComboS3.setEnabled(false);
        }// GEN-LAST:event_vsiRadioS2ActionPerformed

        private void vsiRadioS1ActionPerformed(
                                               java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioS1ActionPerformed
            //
            vsiComboS1.setEnabled(true);
            vsiComboS2.setEnabled(false);
            vsiComboS3.setEnabled(false);
        }// GEN-LAST:event_vsiRadioS1ActionPerformed

        /**
         * Execute the scan or clean action
         * 
         * @param evt
         */
        private void vsiSubmitBtnActionPerformed(
                                                 java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiSubmitBtnActionPerformed
            // "Execute the action"
            boolean doClean = vsiComboAction.getSelectedIndex() == 1;
            boolean doActCont = vsiComboAction.getSelectedIndex() == 2;
            boolean doMimeCheck = vsiComboAction.getSelectedIndex() == 3;
            boolean doProfile = vsiComboAction.getSelectedIndex() == 4;
            ContentInfo[] content;
            byte[] byteArray = null;
            int instType = 0;
            int actType = 0;
            String instName = "";
            String objName = null;
            if (vsiRadioBtn1.isSelected()) {
                actType = 1;
                if (vsiCombo1.getSelectedIndex() == 0) {
                    byteArray = Virus.EICAR;
                    objName = "EICAR";
                } else {
                    byteArray = Virus.SHAKESPEARE;
                    objName = "Shakespeare";
                }
            } else {
                File objFile = null;
                if (vsiRadioBtn2.isSelected()) {
                    actType = 0;
                    objFile = new File(vsiFileChoseF.getText());
                    objName = objFile.getAbsolutePath();
                } else if (vsiRadioBtn3.isSelected()) {
                    actType = 2;
                    objName = vsiURLChoseF.getText();
                }
                if (jcheckFileAsBuffer.isSelected()) {
                    FileInputStream fis = null;
                    try {
                        // get the file
                        fis = new FileInputStream(objFile);
                        byteArray = new byte[(int) objFile.length()];
                        fis.read(byteArray);
                        actType = 1;
                    } catch (Exception e) {
                        // $JL-EXC$
                        byteArray = null;
                        actType = 0;
                    } finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            } catch (IOException ie) {
                                // $JL-EXC$
                            }
                        }
                    }
                } else {
                    byteArray = null;
                }
            }
            if (vsiRadioS1.isSelected()) {
                instType = 0;
                instName = (String) vsiComboS1.getSelectedItem();
            } else if (vsiRadioS2.isSelected()) {
                instType = 1;
                instName = (String) vsiComboS2.getSelectedItem();
            } else if (vsiRadioS3.isSelected()) {
                instType = 2;
                instName = (String) vsiComboS3.getSelectedItem();
            }
            try {
                vsiResultText.setForeground(new java.awt.Color(255, 0,
                        0));
                if (vsiDurationAction.getSelectedIndex() == 0
                        && vsiThreadAction.getSelectedIndex() == 0
                        && vsiLoopAction.getSelectedIndex() == 0) {
                    content = VsiTest.execVsiScan(doClean, doActCont,
                            doMimeCheck, doProfile, instType, instName,
                            actType, byteArray, objName);
                } else {
                    content = VsiTest.execVsiThreadedScan(doClean,
                            doActCont, doMimeCheck, doProfile,
                            instType, instName, actType, byteArray,
                            objName,
                            vsiDurationAction.getSelectedIndex(),
                            (vsiThreadAction.getSelectedIndex() + 1),
                            (vsiLoopAction.getSelectedIndex() + 1),
                            vsiDurationText.getText());
                }
                vsiResultText.setForeground(new java.awt.Color(0, 128,
                        0));
                if (content != null && content.length > 0) {
                    vsiResultText
                            .setText("Check performed successfully\n-------------------------------------\n"
                                    + "Content-Type: "
                                    + content[0].getContentType()
                                    + "\n"
                                    + "Extension      : "
                                    + content[0].getExtension());
                } else {
                    vsiResultText
                            .setText("Check performed successfully");
                }

            } catch (java.net.UnknownHostException uhost) {
                // $JL-EXC$-
                vsiResultText
                        .setText("Unknown Host "
                                + uhost.getLocalizedMessage()
                                + " specified!\nCheck if you need a HTTP proxy and set -Dhttp.proxyHost=<myproxy> -Dhttp.proxy=<number>");
            } catch (java.io.FileNotFoundException fex) {
                // $JL-EXC$
                vsiResultText.setText("Object "
                        + fex.getLocalizedMessage() + " not found!");
            } catch (IOException iox) {
                // $JL-EXC$
                vsiResultText.setText(iox.getLocalizedMessage());
            } catch (VirusScanException sx) {
                // $JL-EXC$
                vsiResultText.setText(sx.getLocalizedMessage());
            } catch (VirusInfectionException iex) {
                // $JL-EXC$
                vsiResultText.setText(iex.getLocalizedMessage());
            } catch (VSIServiceException vex) {
                // $JL-EXC$
                vsiResultText.setText(vex.getLocalizedMessage());
            }
        }// GEN-LAST:event_vsiSubmitBtnActionPerformed

        private void vsiComboS1ActionPerformed(
                                               java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiComboS1ActionPerformed
            if (vsiComboS1 == null
                    || vsiComboS1.getSelectedItem() == null)
                return;
            if (vsiComboS1.getSelectedItem().equals("")) {
                jLabel3.setText("(Default profile)");
            } else {
                jLabel3.setText("");
            }
        }// GEN-LAST:event_vsiComboS1ActionPerformed

        private void vsiInfoProviderActionPerformed(
                                                    java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiInfoProviderActionPerformed
            Object _item;
            Engine _engine;
            Driver _driver;
            Adapter _adapter;
            Server _server;
            Parameter _parameter;
            int i;
            boolean bRefresh = false;
            if (vsiInfoProvider == null
                    || vsiInfoProvider.getSelectedItem() == null)
                return;
            if (vsiInfoProvider.getSelectedItem() != null
                    && vsiInfoProvider.getSelectedItem().toString()
                            .length() > 0) {
                _item = vsiInfoProvider.getSelectedItem();
                if (vsiProviderInfo == null) {
                    vsiProviderInfo = (Provider) _item;
                    bRefresh = true;
                } else {
                    if (_item.equals(vsiProviderInfo)) {
                        bRefresh = false;
                        return;
                    } else {
                        vsiProviderInfo = (Provider) _item;
                        bRefresh = true;
                    }
                }
            } else {
                return;
            }
            if (bRefresh == false)
                return;
            /* now we request the data from Provider and assign it to tables */
            try {
                StringBuffer _numdate = new StringBuffer("");
                _engine = vsiProviderInfo.getEngine();
                _numdate.append(new Integer(_engine.getEngineMajorVersion()).toString());
                _numdate.append(".");
                _numdate.append(new Integer(_engine.getEngineMinorVersion()).toString());
                vsiEngineTable.removeAll();
                vsiDriverTable.removeAll();
                vsiEngineTable.setValueAt(_numdate.toString(), 0, 1);
                vsiEngineTable.setValueAt(_engine.getEngineVersion(), 1, 1);
                vsiEngineTable.setValueAt(_engine.getEngineDate(), 2, 1);
                vsiEngineTable.setValueAt(new Long(_engine.getKnownViruses()).toString(), 3, 1);
                i = vsiProviderInfo.getDrivers().length;
                if (i == 0) {
                    vsiDriverLabel.setVisible(false);
                    vsiDriverTable.setVisible(false);
                    jScrollPane2.setVisible(false);
                } else {
                    vsiDriverLabel.setVisible(true);
                    vsiDriverTable.setVisible(true);
                    jScrollPane2.setVisible(true);
                    if (i < 5) {
                        switch (i) {
                        case 1:
                            jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 35));
                            break;
                        case 2:
                            jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 50));
                            break;
                        default:
                            jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 22 * i));
                            break;
                        }
                    } else {
                        jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 100));
                    }
                    vsiDriverTable.setPreferredSize(new java.awt.Dimension(500, 16 * i));
                    vsiDriverLabel.setText("Loaded Drivers " + "(" + i + ")");
                    ((javax.swing.table.DefaultTableModel) vsiDriverTable.getModel()).setRowCount(i);
                    for (i = 0; i < vsiProviderInfo.getDrivers().length; i++) {
                        _driver = vsiProviderInfo.getDrivers()[i];
                        if (_driver.getDriverMajorVersion() > 0
                                && _driver.getDriverMinorVersion() > 0) {
                            _numdate = new StringBuffer("");
                            _numdate.append(new Integer(_driver
                                    .getDriverMajorVersion())
                                    .toString());
                            _numdate.append(".");
                            _numdate.append(new Integer(_driver
                                    .getDriverMinorVersion())
                                    .toString());
                        } else {
                            _numdate = new StringBuffer("");
                        }
                        vsiDriverTable.setValueAt(_numdate.toString(),
                                i, 0);
                        vsiDriverTable.setValueAt(
                                _driver.getDriverName(), i, 1);
                        vsiDriverTable.setValueAt(
                                _driver.getDriverDate(), i, 2);
                        if (_driver.getNumberOfKnwonViruses() > 0)
                            vsiDriverTable.setValueAt(
                                    new Long(_driver
                                            .getNumberOfKnwonViruses())
                                            .toString(), i, 3);
                    }
                }
                if (vsiProviderInfo.isServer()) {
                    vsiServerLabel.setVisible(true);
                    vsiServerTable.setVisible(true);
                    vsiServerTable.setColumnSelectionAllowed(true);
                    vsiServerTable.setColumnSelectionInterval(0, 0);
                    jScrollPane3.setVisible(true);
                    _server = vsiProviderInfo.getServer();
                    _numdate = new StringBuffer("");
                    _numdate.append(new Integer(_server.getServerMajorVersion()).toString());
                    _numdate.append(".");
                    _numdate.append(new Integer(_server.getServerMinorVersion()).toString());
                    vsiServerTable.removeAll();
                    vsiServerTable.setValueAt(_numdate.toString(), 0, 1);
                    vsiServerTable.setValueAt(_server.getServerVersion(), 1, 1);
                    vsiServerTable.setValueAt(_server.getStartupDate(),2, 1);
                    vsiServerTable.setValueAt(_server.getBuildInfo(),3, 1);
                } else {
                    vsiServerLabel.setVisible(false);
                    vsiServerTable.setVisible(false);
                    jScrollPane3.setVisible(false);
                }
                _adapter = vsiProviderInfo.getAdapter();
                _numdate = new StringBuffer("");
                _numdate.append(new Integer(_adapter.getVsaMajorVersion()).toString());
                _numdate.append(".");
                _numdate.append(new Integer(_adapter.getVsaMinorVersion()).toString());
                vsiAdapterTable.removeAll();
                vsiAdapterTable.setValueAt(_adapter.getVendorInfoText(), 0, 1);
                vsiAdapterTable.setValueAt(_adapter.getVsaVendorName(), 1, 1);
                vsiAdapterTable.setValueAt(_numdate.toString(), 2, 1);
                vsiParamTable.getColumnModel().getColumn(0).setPreferredWidth(150);
                vsiParamTable.getColumnModel().getColumn(1).setPreferredWidth(50);
                vsiParamTable.getColumnModel().getColumn(2).setPreferredWidth(50);
                vsiParamTable.getColumnModel().getColumn(3).setPreferredWidth(250);
                i = vsiProviderInfo.getParameters().length;
                if (i == 0) {
                    vsiParamTable.setVisible(false);
                    vsiParamTable.setVisible(false);
                    jScrollPane5.setVisible(false);
                } else {
                    vsiParamTable.setVisible(true);
                    vsiParamTable.setVisible(true);
                    jScrollPane5.setVisible(true);
                    if (i < 5)
                        jScrollPane5.setPreferredSize(new java.awt.Dimension(500, 26 * i));
                    else
                        jScrollPane5.setPreferredSize(new java.awt.Dimension(500, 100));
                    vsiParamTable.setPreferredSize(new java.awt.Dimension(500, 16 * i));
                    vsiParamLabel.setText("Supported Parameters " + "(" + i + ")");
                    ((javax.swing.table.DefaultTableModel) vsiParamTable.getModel()).setRowCount(i);
                    for (i = 0; i < vsiProviderInfo.getParameters().length; i++) {
                        _parameter = vsiProviderInfo.getParameters()[i];
                        vsiParamTable.setValueAt(_parameter.getParameterName(), i, 0);
                        vsiParamTable.setValueAt(_parameter.getParamterType(), i, 1);
                        if (_parameter.getParameterName().startsWith("INIT")) {
                            vsiParamTable.setValueAt("X", i, 2);
                        } else {
                            vsiParamTable.setValueAt(" ", i, 2);
                        }
                        vsiParamTable.setValueAt(_parameter.getParameterValue(), i, 3);
                    }
                }
            } catch (VSIServiceException vsi) {
                // $JL-EXC$
                vsiEngineTable.removeAll();
            }
            // vsiEngineTable
            /* end of assignment */
        }// GEN-LAST:event_vsiInfoProviderActionPerformed

        private void vsiDurationActionActionPerformed(
                                                      java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiDurationActionActionPerformed
            int i = vsiDurationAction.getSelectedIndex();
            if (i == 1) {
                vsiDurationText.setVisible(true);
                jLabel7.setVisible(true);
            } else {
                vsiDurationText.setVisible(false);
                jLabel7.setVisible(false);
            }
        }// GEN-LAST:event_vsiDurationActionActionPerformed

        private void vsiThreadActionActionPerformed(
                                                    java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiThreadActionActionPerformed
            /*
             * if(vsiThreadAction.getSelectedIndex() > 0) {
             * vsiLoopAction.setEnabled(true); } else {
             * vsiLoopAction.setSelectedItem("1");
             * vsiLoopAction.setEnabled(false); }
             */
        }// GEN-LAST:event_vsiThreadActionActionPerformed

        private void vsiRadioBtn3ActionPerformed(
                                                 java.awt.event.ActionEvent evt) {// GEN-FIRST:event_vsiRadioBtn3ActionPerformed
            //
            vsiURLChoseF.setEnabled(true);
            vsiFileChoseF.setEnabled(false);
            vsiFileChoser.setEnabled(false);
            jcheckFileAsBuffer.setEnabled(false);
            vsiCombo1.setEnabled(false);
        }// GEN-LAST:event_vsiRadioBtn3ActionPerformed

        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JLabel jLabel1;
        private javax.swing.JLabel jLabel2;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JLabel jLabel5;
        private javax.swing.JLabel jLabel6;
        private javax.swing.JLabel jLabel7;
        private javax.swing.JLabel jLabel8;
        private javax.swing.JScrollPane jScrollPane1;
        private javax.swing.JScrollPane jScrollPane2;
        private javax.swing.JScrollPane jScrollPane3;
        private javax.swing.JScrollPane jScrollPane4;
        private javax.swing.JScrollPane jScrollPane5;
        private javax.swing.JSeparator jSeparator1;
        private javax.swing.JCheckBox jcheckFileAsBuffer;
        private javax.swing.JPanel jvsiResultPanel;
        private javax.swing.JPanel jvsiTestPanel;
        private javax.swing.JLabel vsiAdapterLabel;
        private javax.swing.JTable vsiAdapterTable;
        private javax.swing.JComboBox vsiCombo1;
        private javax.swing.JComboBox vsiComboAction;
        private javax.swing.JComboBox vsiComboS1;
        private javax.swing.JComboBox vsiComboS2;
        private javax.swing.JComboBox vsiComboS3;
        private javax.swing.JLabel vsiDriverLabel;
        private javax.swing.JTable vsiDriverTable;
        private javax.swing.JComboBox vsiDurationAction;
        private javax.swing.JTextField vsiDurationText;
        private javax.swing.JLabel vsiEngineLabel;
        private javax.swing.JTable vsiEngineTable;
        private javax.swing.JTextField vsiFileChoseF;
        private javax.swing.JButton vsiFileChoser;
        private javax.swing.JComboBox vsiInfoProvider;
        private javax.swing.JLabel vsiInfoProviderL;
        private javax.swing.JComboBox vsiLoopAction;
        private javax.swing.JLabel vsiParamLabel;
        private javax.swing.JTable vsiParamTable;
        private javax.swing.JRadioButton vsiRadioBtn1;
        private javax.swing.JRadioButton vsiRadioBtn2;
        private javax.swing.JRadioButton vsiRadioBtn3;
        private javax.swing.JRadioButton vsiRadioS1;
        private javax.swing.JRadioButton vsiRadioS2;
        private javax.swing.JRadioButton vsiRadioS3;
        private javax.swing.JTextArea vsiResultText;
        private javax.swing.ButtonGroup vsiScanBtnGroup;
        private javax.swing.JLabel vsiServerLabel;
        private javax.swing.JTable vsiServerTable;
        private javax.swing.JButton vsiSubmitBtn;
        private javax.swing.ButtonGroup vsiTestBtnGroup;
        private javax.swing.JComboBox vsiThreadAction;
        private javax.swing.JTextField vsiURLChoseF;
        // End of variables declaration//GEN-END:variables

    }

    /**
     * Consistency checker for the entire message class to be called in
     * test-targets of the make process.
     * <p>
     * It can be called on any instance of the message class and cannot be
     * static because the data regarding resource bundle name and prefixes are
     * given in the constructor.
     * <p>
     * By configuring the system property
     * 
     * <pre></pre>
     * 
     * @throws Exception
     *             Any error is thrown as exception with detail message text.
     */
    public static void createRessourceBundle(Object object)
                                                           throws Exception {

        boolean bGenerate = true;
        /* Name of the resource bundle */
        String bundleName = VSIServiceMessage.class.getName();
        /* Prefix of the message key in the bundle */
        /* Constant value for "OK" */
        final String PROPERTY_BUNDLE_ERROR_IGNORE = "IGNORE";
        /* Constant value for "GENERATE" */
        final String PROPERTY_BUNDLE_ERROR_GENERATE = "GENERATE";
        String bundleErrorBehavior = (bGenerate == true ? PROPERTY_BUNDLE_ERROR_GENERATE
                : PROPERTY_BUNDLE_ERROR_IGNORE);

        String prefixInBundle = VSIServiceMessage.PREFIX_IN_BUNDLE;
        /*
         * Boolean indicator that a bundle error was found. Controls that the
         * bundle is regenerated at the end.
         */
        boolean bundleErrorFound = false;
        /* Check that the value of the property is in the allowed range */
        if ((bundleErrorBehavior == null)
                || "".equals(bundleErrorBehavior)
                || PROPERTY_BUNDLE_ERROR_GENERATE
                        .equals(bundleErrorBehavior)
                || PROPERTY_BUNDLE_ERROR_IGNORE
                        .equals(bundleErrorBehavior)) {
            /* Map empty value to null */
            if ("".equals(bundleErrorBehavior)) {
                bundleErrorBehavior = null;
            }
        } else {
            throw new Exception("System property \"" + ""
                    + "\" has value \"" + bundleErrorBehavior
                    + "\" which is not known. "
                    + "Permitted are [<null>|IGNORE|GENERATE]");

        }
        /*
         * Get the resource bundle as direct properties object. Do not use the
         * ResourceBundle function directly because we only want to read the
         * non-localized master version of the resource bundle file.
         */
        Properties bundleMessages;
        bundleName = bundleName
                .substring(bundleName.lastIndexOf(".") + 1);
        String fileName = bundleName + ".properties";
        /* Evaluate the indicator what to do in case of errors */
        try {
            bundleMessages = new Properties();
            bundleMessages.load(object.getClass().getResourceAsStream(
                    fileName));
        } catch (Exception e) {
            // $JL-EXC$
            /*
             * Set the bundle message variable to null to indicate that there is
             * no bundle available.
             */
            bundleMessages = null;
            /* Trigger regeneration at the end */
            bundleErrorFound = true;
            /*
             * If the bundle is not found, this will cause an error unless a
             * special "I know, but not now" flag is set".
             */
            String messageText = "Resource bundle \"" + fileName
                    + "\" not found. ";
            if (PROPERTY_BUNDLE_ERROR_IGNORE
                    .equals(bundleErrorBehavior)) {
                // $JL-SYS_OUT_ERR$
                System.err.println("\n" + messageText + "Property \""
                        + "" + "\" set to \""
                        + PROPERTY_BUNDLE_ERROR_IGNORE
                        + "\". Will continue without further action.");

            } else if (PROPERTY_BUNDLE_ERROR_GENERATE
                    .equals(bundleErrorBehavior)) {
                // $JL-SYS_OUT_ERR$
                System.err
                        .println("\n"
                                + messageText
                                + "Property \""
                                + ""
                                + "\" set to \""
                                + PROPERTY_BUNDLE_ERROR_GENERATE
                                + "\". Will generate bundle if default texts are "
                                + "free of inconsistencies.");
            } else {
                // $JL-EXC$
                throw new Exception(messageText);
            }
        }
        /*
         * Loop over all fields in the class and extract all fields that are
         * derived from BaseMsg. These are the message constants.
         */
        Field[] fields = object.getClass().getFields();
        Map keyToTextMap = new TreeMap();
        HashMap bundleCrossCheck = new HashMap();
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            Class fieldClass = field.getType();
            String fieldName = field.getName();
            /* Ignore if not message constant */
            if (!VSIServiceMessage.BaseMsg.class.isAssignableFrom(field
                    .getType())) {
                continue;
            }
            String currentLocation = "[Class \""
                    + object.getClass().getName() + "\", message \""
                    + fieldName + "\"]";
            /* Get field contents */
            VSIServiceMessage.BaseMsg fieldMsg = (VSIServiceMessage.BaseMsg) field
                    .get(object);
            String key = fieldMsg.getKey();
            String defaultText = fieldMsg.getDefaultText();
            Class implementingClass = fieldMsg.getImplementingClass();
            /* Implementing class must be identical to the current class */
            if (implementingClass != object.getClass()) {
                throw new Exception(currentLocation
                        + "Declared implementing class \""
                        + implementingClass
                        + "\" not equal to declaring class \""
                        + object.getClass() + "\"");
            }
            /*
             * Check that the default text does not contain single quotes, as
             * these need to be escaped by duplicating them.
             */
            int scanPosition = 0;
            while (scanPosition < defaultText.length()) {
                /* Locate tick in string */
                int tickPosition = defaultText.indexOf('\'',
                        scanPosition);
                /* If not found, we are finished */
                if (tickPosition == -1) {
                    break;
                }
                /*
                 * Otherwise, check whether the character on the right side is
                 * also a single tick --> OK
                 */
                if ((tickPosition < (defaultText.length() - 1))
                        && (defaultText.charAt(tickPosition + 1) == '\'')) {
                    scanPosition++;
                    continue;
                }
                /* Otherwise (single tick), complain */
                throw new Exception(currentLocation + "Key \"" + key
                        + "\" contains a single tick (') "
                        + "at position " + tickPosition
                        + "which leads to faulty results in the "
                        + "MessageFormat class.");
            }
            /* Check that key is unique within class */
            if (keyToTextMap.containsKey(key)) {
                throw new Exception(currentLocation + "Key \"" + key
                        + "\" occurs multiple times");
            }
            keyToTextMap.put(key, defaultText);
            /* Check that key is a numeric field */
            try {
                Integer.parseInt(key);
            } catch (Exception e) {
                // $JL-EXC$
                throw new Exception(currentLocation
                        + "Key must be a numeric value");
            }
            /* Check that the variable name contains the key string somehow */
            if (fieldName.indexOf(key) == -1) {
                throw new Exception(currentLocation + "Key \"" + key
                        + "\" is not contained in the message name");
            }
            /*
             * Check the message text itself for a correct number of parameters.
             */
            int expectedArguments;
            if (fieldClass == VSIServiceMessage.Msg0.class) {
                expectedArguments = 0;
            } else if (fieldClass == VSIServiceMessage.Msg1.class) {
                expectedArguments = 1;
            } else if (fieldClass == VSIServiceMessage.Msg2.class) {
                expectedArguments = 2;
            } else if (fieldClass == VSIServiceMessage.Msg3.class) {
                expectedArguments = 3;
            } else if (fieldClass == VSIServiceMessage.Msg4.class) {
                expectedArguments = 4;
            } else {
                throw new Exception(currentLocation
                        + "Class type is \"" + fieldClass.getName()
                        + "\", but only Msg0..Msg4 supported.");
            }
            /* Load the message into the message formatter class */
            MessageFormat messageFormat;
            try {
                // Consistency checker not critical $JL-LOOP$
                messageFormat = new MessageFormat(defaultText);
            } catch (Exception e) {
                // $JL-EXC$
                throw new Exception(currentLocation
                        + "MessageFormat-Exception for \""
                        + defaultText + "\":\n" + e.toString());
            }
            /* Create an object array with Strings <0>, <1>, <2>, ... */
            Object[] parameters = new Object[10];
            for (int j = 0; j < 10; j++) {
                parameters[j] = new String("<" + j + ">");
            }
            /*
             * Apply the string to the message. This will replace all variables
             * by the appropriate test tag. Superfluous tags are not harmful
             * according to experimental findings.
             */
            String result;
            try {
                result = messageFormat.format(parameters);
            } catch (Exception e) {
                // $JL-EXC$
                throw new Exception(currentLocation
                        + "format-Exception for \"" + defaultText
                        + "\":\n" + e.toString());
            }
            /* Count which tags are present, stop at the first non-replaced tag */
            int foundTags = 0;
            for (int j = 0; j < 10; j++) {
                String lookFor = (String) (parameters[j]);
                if (result.indexOf(lookFor) >= 0) {
                    foundTags++;
                } else {
                    /* Check whether this tag must be present */
                    if (j < expectedArguments) {
                        throw new Exception(
                                currentLocation
                                        + "Key should have "
                                        + expectedArguments
                                        + " variables, but in the message text \""
                                        + defaultText + "\""
                                        + " the variable {" + j
                                        + "} is missing.");
                    }
                }
            }
            if (expectedArguments != foundTags) {
                throw new Exception(currentLocation
                        + "Key should declare " + expectedArguments
                        + " variables, but in the message text \""
                        + defaultText + "\" a number of " + foundTags
                        + " variables was found");

            }
            /*
             * If resource bundle present, check that the message can be read
             * from there and is identical to the message in the default text.
             * If this is not the case, a message is printed and if permitted
             * the system continues.
             */
            if (bundleMessages != null) {
                String bundleKey = prefixInBundle + key;
                String bundleMessage = bundleMessages
                        .getProperty(bundleKey);
                /* Store this key as being valid */
                bundleCrossCheck.put(bundleKey, null);
                if ((bundleMessage == null)
                        || (!(bundleMessage.equals(defaultText)))) {
                    String messageText;
                    if (bundleMessage == null) {
                        messageText = currentLocation
                                + "Entry with key \"" + prefixInBundle
                                + key
                                + "\" not found in property file \""
                                + fileName + "\".";

                    } else {
                        messageText = currentLocation
                                + "Entry with key \""
                                + prefixInBundle
                                + key
                                + "\" in property file \""
                                + fileName
                                + "\" has value \""
                                + bundleMessage
                                + "which is unequal to default value \""
                                + defaultText + "\".";
                    }
                    /* Trigger bundle generation at the end */
                    bundleErrorFound = true;
                    if (bundleErrorBehavior != null) {
                        /* Print message, but continue */
                        // $JL-SYS_OUT_ERR$
                        System.err.println(messageText);  //$JL-SYS_OUT_ERR$
                    } else {
                        throw new Exception(messageText);
                    }
                }
            }
        }
        /*
         * If resource bundle present, cross check that there are no superfluous
         * messages within
         */
        if (bundleMessages != null) {
            Enumeration keyNames = bundleMessages.propertyNames();
            while (keyNames.hasMoreElements()) {
                String propKey = (String) keyNames.nextElement();
                if (!bundleCrossCheck.containsKey(propKey)) {
                    bundleErrorFound = true;
                    String messageText = "Resource file \""
                            + fileName
                            + "\" contains key \""
                            + propKey
                            + "\" which is not covered by a constant in class \""
                            + object.getClass().getName() + "\"";
                    if (bundleErrorBehavior != null) {
                        // $JL-SYS_OUT_ERR$
                        System.err.println(messageText);
                    } else {
                        throw new Exception(messageText);
                    }
                }
            }
        }
        /* If generation required, do it */
        if (bundleErrorFound
                && (PROPERTY_BUNDLE_ERROR_GENERATE
                        .equals(bundleErrorBehavior))) {
            PrintWriter bundleFile = new PrintWriter(
                    new FileOutputStream(bundleName + ".properties"));
            /* Write header comments */
            bundleFile.println("####################################"
                    + "####################################");
            bundleFile.println("#");
            bundleFile.println("# Resource bundle for message class");
            bundleFile.println("# \"" + bundleName + "\"");
            bundleFile.println("#");
            bundleFile.println("# Generated on "
                    + (new Date()).toString() + " by \""
                    + object.getClass().getName()
                    + ".createRessourceBundle()" + "\"");
            bundleFile.println("#");
            bundleFile.println("####################################"
                    + "####################################");
            bundleFile.println();
            Set entries = keyToTextMap.entrySet();
            Iterator entryIterator = entries.iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = (Map.Entry) entryIterator.next();
                String key = (String) entry.getKey();
                String defaultText = (String) entry.getValue();
                bundleFile.println(prefixInBundle + key + " = "
                        + defaultText);
            }
            bundleFile.flush();
            bundleFile.close();
            /*
             * After this, error out with exception because the test was not
             * successful
             */
            throw new Exception("Generated resource bundle \""
                    + bundleName + "\". Move it to the "
                    + "proper location and restart the test.");
        }
    }
}
