/**********************************************************************/
/* $Id: //tools/src/SAPSource/VSA/sap/vssap.h#5 $
 **********************************************************************/
/*
 *  (C) Copyright SAP AG, Walldorf 2013, All Rights reserved
 *
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*header--------------------------------------------------------------*/
/*                                                                    */
/* Description:                                                       */
/* ============                                                       */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  Author:        Markus Strehle, SAP AG                             */
/*  Reviewer:      SAP Security Department, SAP AG                    */
/*  Version:       2.00                                               */
/*                                                                    */
/*  Created:                                                          */
/*    01 Nov 2003  Markus Strehle                                     */
/*                                                                    */
/*  Modified:                                                         */
/*    20 Nov  2004  Markus Strehle                                    */
/*    06 June 2005  Markus Strehle                                    */
/*                  (added VSA_SCANERROR for wrong action type)       */
/*    06 Dec  2012  Markus Strehle                                    */
/*                  Return VSA_CONTENTINFO for VSI 2                  */
/*                                                                    */
/*  Remarks:                                                          */
/*      Modifications are done for NW-VSI Version 2.00                */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#ifndef VSSAP_H
#define VSSAP_H

#undef VSAonWindows
#undef VSAonUnix
#undef VSAonLinux
#undef VSAonSolaris
#undef VSAonAIX
#undef VSAonOS390
#undef VSAonHP
#undef VSAon64Bit

#if defined(__WINDOWS__) || defined(_WIN32) || defined(WIN32)
# define VSAonWindows
#else
# define VSAonUnix
# if defined(__linux__)
# define VSAonLinux
# elif defined(__sun__)
# define VSAonSolaris
# elif defined(_AIX) || defined(aix)
# define VSAonAIX
# elif defined (__s390__)
# define VSAonOS390
# elif defined(__hpux__) || defined(__hpux)
# define VSAonHP
# endif
#endif

#if defined(_M_X64) || defined(_AMD64_) || defined(_M_IA64) || defined(_IA64_)
# define VSAon64Bit
#endif
/*--------------------------------------------------------------------*/
/* VSA example defines                                                */
/*--------------------------------------------------------------------*/
/* this adapter provides NW-VSI version 1 */
#define VSI_VERSION            1

/* adapter constants in VSA_CONFIG        */
#define VSA_ADAPTER_ID         "SAP"
#define VSA_ADAPTER_MAJVER     2
#define VSA_ADAPTER_MINVER     0
#define VSA_VENDORINFO         "SAP AG, Product Security Development"
#define VSA_VENDORINFO_LN      (sizeof(VSA_VENDORINFO)-1)
#define VSA_ADAPTERNAME        "Demo Virus Scan Adapter supported by SAP"
#define VSA_ADAPTERNAME_LN     (sizeof(VSA_ADAPTERNAME)-1)

#define VSA_VERSION_STRING     "Demo Adapter for NW-VSI without AV protection"
#define VSA_DRIVER_SIZE         1
#define VSA_DRIVER_NAME        "Demo Driver to detect EICAR-STRING"

#define VSA_BYTE_NAME          (PChar)"BYTES"
#define EXT_LN                  10
#define MIME_LN                 255

/* Platform specific defines */
#ifdef VSAonWindows
# include "direct.h"
# include  "io.h"
# define DIRSLASH               '\\'
# define DIRSLASH_STR           "\\"
# define getcwd                 _getcwd
# define vsaaccess              _access
# define vsamkdir( mydir )      mkdir( mydir )
#else
# include <unistd.h>
# define DIRSLASH               '/'
# define DIRSLASH_STR           "/"
# define vsamkdir( mydir )      mkdir( (mydir) , 0744 )
# define vsaaccess              access
#endif

/* we can not access to the engine, so we know 1 driver/definition */
#define MAX_DRIVERS         1
#define CLEANUP(x)          { rc = x; goto cleanup; }

/* define exported symbols for zOS */
#ifdef SAPonOS390
#pragma export(VsaStartup)
#pragma export(VsaGetConfig)
#pragma export(VsaInit)
#pragma export(VsaScan)
#pragma export(VsaReleaseScan)
#pragma export(VsaEnd)
#pragma export(VsaCleanup)
#endif
/* structures for VsaGetConfig returning own configuration */
typedef struct {
    VS_INITPARAM_T     tCode;
    VS_PARAMTYPE_T     tType;
    size_t             lLength;
    VSA_PARAMVALUE     pvValue;
} MY_INITPARAMS;

typedef struct  {
    VS_OPTPARAM_T      tCode;
    VS_PARAMTYPE_T     tType;
    size_t             lLength;
    VSA_PARAMVALUE     pvValue;
} MY_OPTPARAMS;

/* structure for transporting our USRDATA + our
 * function pointer + virus_info 
 */
struct usrdata {
    VSA_RC          vsa_rc;
    UInt            uiMsgFlags;
    size_t          lObjectSize;
    VSA_ENGINE      heng;
    VSA_EVENTCBFP   pvFncptr;
    void           *pvUsrdata;
    Bool            bScanBestEffort;
    Bool            bScanAllFiles;
    Bool            bScanCompressed;
    UInt            iComress2Level;
    Bool            bMimeCheck;
    Bool            bActiveContent;
    PChar           pszScanMimeTypes;
    PChar           pszBlockMimeTypes;
    PChar           pszScanExtensions;
    PChar           pszBlockExtensions;
    VS_OBJECTTYPE_T tFileType;
    VS_OBJECTTYPE_T tObjectType;
    PVSA_SCANINFO   pScanInfo;
};
typedef struct usrdata USRDATA, *PUSRDATA, **PPUSRDATA;

/* helper macros */
#define VSAddINITParameter(pl, i, c, a, b, s) \
{       pl[i].struct_size    = sizeof(VSA_INITPARAM); \
        pl[i].tCode          = c; \
        pl[i].tType          = a; \
        pl[i].lLength        = b; \
        pl[i].pvValue        = s; \
        i++; \
}
#define VSAddOPTParameter(pl, i, c, a, b, s) \
{       pl[i].struct_size    = sizeof(VSA_OPTPARAM); \
        pl[i].tCode          = c; \
        pl[i].tType          = a; \
        pl[i].lLength        = b; \
        pl[i].pvValue        = s; \
        i++; \
}

#define CB_FUNC(msg, udata)                         \
    ((pUsrData->pvFncptr != NULL) && (pUsrData->uiMsgFlags & msg)) ?        \
      pUsrData->pvFncptr ( pUsrData->heng, msg, (VSA_PARAM)udata, pUsrData->pvUsrdata ) : VS_CB_OK;

#define SET_VSA_RC(_vsa_rc_) \
{   if (pUsrData->vsa_rc == VSA_OK || pUsrData->vsa_rc > _vsa_rc_) \
    pUsrData->vsa_rc = _vsa_rc_; }

#define SETSTRING( buf, txt )                                           \
{   if (txt != NULL && (len=strlen((const char*)txt)) > (size_t)0)      \
    {   buf = (PChar)malloc(len+1);                                     \
    if (buf == NULL)                                                    \
        CLEANUP(VSA_E_NO_SPACE);                                        \
    /* CCQ_OFF */ memcpy(buf,txt,len); /*CCQ_ON */                      \
    buf[len] = 0; } /* ensure zero termination */                       \
    else                                                                \
        buf = NULL;                                                     \
}

#define SETSTRINGLN( buf, txt, len )                                    \
{   if (txt != NULL && (len>0))                                         \
    {   buf = (PChar)malloc(len+1);                                     \
    if (buf == NULL)                                                    \
        CLEANUP(VSA_E_NO_SPACE);                                        \
    /* CCQ_OFF */ memcpy(buf,txt,len); /*CCQ_ON */                      \
    buf[len] = 0; } /* ensure zero termination */                       \
    else                                                                \
        buf = NULL;                                                     \
}

#define SETERRORTEXT    SETSTRING

#endif /* VSSAP_H */
