/* $Id: //bas/720_REL/src/sec/vsi/vsaxxvir.h#3 $
 **********************************************************************/
/*
 *  (C) Copyright SAP AG, Walldorf 2008, All Rights reserved
 *
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*include-------------------------------------------------------------
 *
 * Description:
 * ============
 *
 * vsaxxvir.h:  vsa = Project  Virus Scan Adapter
 * ==========    xx = OS-independent code
 *              vir = Virus
 *
 *  Author:    Markus Strehle  (SAP AG)
 *  Reviewer:
 *  Version:   1.00
 *
 *  Description:
 *  This header contains several test patterns for external AV engines.
 *  The main purpose of these patterns is for SAP application tests,  
 *  not for tests of the external engine. For a certification you should
 *  also be able to detect these patterns.
 *  This header contains pattern contstants which are also defined in
 *  ABAP report RSVSCANTEST (use transaction VSCANTEST) and in the 
 *  JAVA interface "com.sap.security.core.server.vsi.api.Virus", which
 *  is included in development component tc/sec/vsi/interface (see
 *  SAP NetWeaver Studio).
 *  
 *--------------------------------------------------------------------*/
#ifndef VSAXXVIR_H
#define VSAXXVIR_H

/**
 *  Eicar test virus definition:
 *  The EICAR virus is only a test string of 68 bytes, adapted from http://www.eicar.org
 *  The usage of this test virus is without any warrenty!
 */
#define EICAR_STRING         "X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*"
#define EICAR_STRING_U       /*SAPUNICODEOK_STRINGCONST*/cU(EICAR_STRING)       /* cU := SAP macro for UTF16 string */
#define EICAR_STRING_R       /*SAPUNICODEOK_STRINGCONST*/cR(EICAR_STRING)       /* cR := SAP macro for RAW string   */
#define EICAR_LENGTH         68

/**
 *  Eicar test virus definition:
 *  The EICAR virus is only a test string of 68 bytes, adapted from http://www.eicar.org
 *  The usage of this test virus is without any warrenty!
 */
#define CLEAN_EICAR_STRING   "X5O!P%@AP[4\\PZX54(P^)7CC)7}$SAP-STANDARD-CLEANOBJECT-TEST-FILE!$H+H*"
#define CLEAN_EICAR_STRING_U /*SAPUNICODEOK_STRINGCONST*/cU(CLEAN_EICAR_STRING) /* cU := SAP macro for UTF16 string */
#define CLEAN_EICAR_STRING_R /*SAPUNICODEOK_STRINGCONST*/cR(CLEAN_EICAR_STRING) /* cR := SAP macro for RAW string   */
#define CLEAN_EICAR_LENGTH   68

/**
 *  "Shakespeare" as positive case for any virus checks.
 *  We (SAP) have no chance to check the positive (means virus-free) case.
 *  So we define here some text fragment from Shakespears Sonnet 18 as byte sequence without any virus
 *  infection.
 */
#define SHAKESPEARE_STRING   "Shall I compare thee to a summer's day? Thou art more lovely and more temperate: "         \
                             "Rough winds do shake the darling buds of May, And summer's lease hath all too short "      \
                             "a date: Sometime too hot the eye of heaven shines, And often is his gold complexion "      \
                             "dimm'd; And every fair from fair sometime declines, By chance, or nature's changing "      \
                             "course, untrimm'd; But thy eternal summer shall not fade, Nor lose possession of that "    \
                             "fair thou owest; Nor shall Death brag thou wander'st in his shade, When in eternal lines " \
                             "to time thou growest; So long as men can breathe, or eyes can see, So long lives this, "   \
                             "and this gives life to thee."
#define SHAKESPEARE_STRING_U /*SAPUNICODEOK_STRINGCONST*/cU(SHAKESPEARE_STRING) /* cU := SAP macro for UTF16 string */
#define SHAKESPEARE_STRING_R /*SAPUNICODEOK_STRINGCONST*/cR(SHAKESPEARE_STRING) /* cR := SAP macro for RAW string   */
#define SHAKESPEARE_LENGHT   623


#endif /* VSAXXVIR_H */
