@echo off
rem Batch script to demonstrate usage of VSATEST utility on Windows systems
rem echo ""
rem echo ""

if "%PROCESSOR_ARCHITECTURE%" == "x86"  (
  set CFG_XML=etc\vsa-smoke.xml
  set SAP_PLATFORM=ntintel
) else (
  if "%PROCESSOR_ARCHITECTURE%" == "AMD64"  (
    set SAP_PLATFORM=ntamd64
  ) else (
    set SAP_PLATFORM=ntia64
  )
  set CFG_XML=etc\vsa-smoke.xml
)
if not defined VSA_LIB (
  set VSSAP=vssap\opt\%SAP_PLATFORM%\vssap.dll
) else (
  set VSSAP=%VSA_LIB%
)

rem echo Start vsatest with parameter options -cfg -V -info -v

vsatest\opt\%SAP_PLATFORM%\vsatest.exe testdata -D data -cfg %CFG_XML% > out\stdout.log
vsatest\opt\%SAP_PLATFORM%\vsatest.exe -cfg %CFG_XML% -info -v -V "%VSSAP%" %* > out\stdout.log
IF errorlevel 1 goto OUT
set CFG_XML=etc\vsa-cert.xml
vsatest\opt\%SAP_PLATFORM%\vsatest.exe -cfg etc\vsa-cert.xml -info -v -V "%VSSAP%" %* >> out\stdout.log
goto OUT

:OUT
type out\stdout.log
echo ""
echo OS Platform     : %OS% %PROCESSOR_ARCHITECTURE%
echo SAP Platform    : %SAP_PLATFORM% 
echo Command line    : vsatest\opt\%SAP_PLATFORM%\vsatest.exe -cfg %CFG_XML% -info -v -V %VSSAP% %*
echo Result of run   : out/stdout.log
