import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Vector;

import com.sap.idm.vds.*;


/**
 * Common class for all the different testings
 *
 * @author I054742
 *
 */
abstract public class Testing {

	/* Maximum amount of time for the current process */
	protected long maxTime;
	/* Time when the current process started */
	protected long startTime;
	
	protected long endTime;
	/* Indicates if the time for the current process expired */
	protected boolean timeExpired;
	
	protected long times[] = new long[1];
	
	 /* They will hold the current number of additions, deletions and modifications respectively */
	protected int currents[] = new int[Globals.NUMB_OF_OPERS];
	
	 /* They will hold the maximum number of modifications, additions and deletions respectively */
	protected int maxims[] = new int[Globals.NUMB_OF_OPERS];

	/* Parameters for testing distribution */
	protected int totalEntries=0;
	protected int totalEntriesWhereAdding=0;
	protected int percentageDeleteEntries=0;
	protected int percentageModif=0;
	
    protected boolean success;
    
    protected String testName;
    
    
	abstract boolean execute();
	
	
	abstract void writeReport();
	
	protected void writeHeader () {
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"############ Final Report for "+this.testName+" Testing ############");
		Loggin.Log("");
	}

	
	protected void writeNumbOfTC () {
		
		MyHashMap nOfExecTC = TestCase.getNumbOfExecTC();
		
		for (Iterator it = nOfExecTC.keySet().iterator(); it.hasNext(); ) {
			
			String tcId = (String)it.next();
			int n = ((Integer)nOfExecTC.get(tcId)).intValue();
			tcId = tcId.substring("testcase_".length()).toUpperCase();
			Loggin.Log(Globals.indent()+"Executed "+n+" \""+tcId+"\" test cases");
		}
	}
	
	
	protected void reset () {

		if (this.maxTime>=0) this.maxTime=System.currentTimeMillis()+this.maxTime*1000;
		else this.maxTime=System.currentTimeMillis()+((long)Integer.MAX_VALUE)*(long)1000;
		this.startTime=System.currentTimeMillis();
		this.timeExpired=false;
		for (int i=0; i<this.times.length; i++) this.times[0] = 0;
		for (int i=0; i<this.currents.length; i++) this.currents[i] = 0;
	}
	
	
	protected void setConfParams () {
		
		/* Gets the maximum number of random additions */
		this.maxims[Globals.ADD_ENTRIES]=GeneralConfiguration.getAdditions();
		/* Gets the maximum number of random deletions */
		this.maxims[Globals.DEL_ENTRIES]=GeneralConfiguration.getDeletions();
		/* Gets the maximum number of random modifications */
		this.maxims[Globals.MODIF_ADD_ATTRS]=GeneralConfiguration.getModificationsAdd();
		/* Gets the maximum number of random modifications */
		this.maxims[Globals.MODIF_DEL_ATTRS]=GeneralConfiguration.getModificationsDel();
		/* Gets the maximum number of random modifications */
		this.maxims[Globals.MODIF_REP_ATTRS]=GeneralConfiguration.getModificationsRep();
		/* Gets the maximum amount of allowed time for the process */
		this.maxTime=GeneralConfiguration.getTime();
	}

	
	protected void initialize () {
		
		this.setConfParams();
		this.reset();
	}
	
	/**
	 * Checks if the server is down
	 * @return 'true' if the server is down
	 * 		   'false' otherwise
	 */
	protected boolean isServerDown () {
		
		for (int k=0; k<3; k++) {
			MVDSearchResults sr = Globals.ldapm.search(GeneralConfiguration.getStartingPoint(),
													   LDAPManagement.ONE_LEVEL,Globals.attr,Globals.urlfilter,
													   Globals.szLimit,Globals.tmLimit,true);
			if (sr!=null) return false;
			
			sr = Globals.ldapm.search(GeneralConfiguration.getStartingPoint(),
									  LDAPManagement.BASE,Globals.attr,Globals.urlfilter,
									  Globals.szLimit,Globals.tmLimit,true);
			if (sr!=null) return false;
		}
		return true;
	}
	
	
	/**
	 * Checks if the maximum execution time for the current process has been reached
	 * @return 'true' if the maximum execution time has not been reached
	 * 		   'false' otherwise
	 */		   
	protected boolean timeCondition () {
		
		if (this.maxTime<0) return true;
		if (System.currentTimeMillis()<this.maxTime) return true;
		this.timeExpired=true;
		return false;
	}
	
	
	protected Entry existsEntry (String dn) {
		
		return existsEntryInSystem(dn);
	}
	
	
	static Entry existsEntryInSystem (String dn) {
		
		MVDSearchResults base_sr =  Globals.ldapm.search(dn,LDAPManagement.BASE,Globals.attr,Globals.urlfilter,
				 										 Globals.szLimit,Globals.tmLimit,false);
		if (base_sr==null || base_sr.size()==0) return null;
		
		Entry res = new Entry(dn,new Vector());
		res.setAttributes(base_sr);
		
		return res;
	}
	
	
	protected EntrySet initUnderSp (String sp, boolean fillAtts) {
		
		MVDSearchResults sr = Globals.ldapm.search(sp,LDAPManagement.ONE_LEVEL,Globals.attr,
												   Globals.urlfilter,Globals.szLimit,Globals.tmLimit,true);
		
		if (sr==null) return null;
		
		Loggin.Log(Globals.indent()+"Number of entries found under this starting point: "+sr.size());
		/* Creates the entry set */
		EntrySet modified = new EntrySet();
		modified.setEntries(sr);
		if (fillAtts) {
			Loggin.Log(Globals.indent()+"Making base search for each one of the entries found under this starting point");
			/* Gets attributes of each entry */
			for (modified.startIterator(); modified.hasNext(); ) {
				Entry e = modified.next();
				MVDSearchResults base_sr = Globals.ldapm.search(e.getDn(),LDAPManagement.BASE,Globals.attr,Globals.urlfilter,
																Globals.szLimit,Globals.tmLimit,true);
				/* Creates the attribute set for each entry */
				e.setAttributes(base_sr);
			}
		}
		
		return modified;
	}
	
	
	protected void setAllowed (boolean []allowed, boolean newVals, int[] indexes) {
		
		for (int i=0; i<indexes.length; i++) {
			allowed[indexes[i]]=newVals;
		}
	}
	
	
	protected int sumList (int[] list) {
		
		int res = 0;
		
		for (int i=0; i<list.length; i++) res+=list[i];
		
		return res;
	}
	
	
	int[] createDefCands (int[] cands, Object[] forCase) {
		
		Vector provCands = new Vector();
		
		for (int i=0; i<cands.length; i++) {
			if (forCase[cands[i]]!=null) provCands.add(new Integer(cands[i]));
		}
		
		int defCands[] = new int[provCands.size()];
		for (int i=0; i<provCands.size(); i++) defCands[i] = ((Integer)provCands.elementAt(i)).intValue();
		
		return defCands;
	}
	
	
	protected boolean launchOper (boolean[] allowed, int[] numbOfOpers, EntrySet modified, String sp, Entry preSelectedEnt, MyAttribute preSelectedAtt, EntrySet newEnts, boolean justExecute,  Entry[] entForCase, MyAttribute[] attForCase) {
		
		boolean addForCase = ((Globals.randGen.nextInt(100)<15) && entForCase!=null);
		
		Entry ent = preSelectedEnt;
		if (ent==null) {
			ent = modified.pickUpEntRandomly();
			int defCands[] = null;
			if (ent==null) {
				if (entForCase!=null && addForCase) {
					int cands[] = new int[]{Globals.DEL_ENTRIES,Globals.MODIF_ADD_ATTRS,Globals.MODIF_DEL_ATTRS,Globals.MODIF_REP_ATTRS};
					defCands = this.createDefCands(cands,entForCase);
				}
				else {
					defCands = new int[]{Globals.DEL_ENTRIES,Globals.MODIF_ADD_ATTRS,Globals.MODIF_DEL_ATTRS,Globals.MODIF_REP_ATTRS};
				}
				this.setAllowed(allowed,false,defCands);
			}
		}
		
		MyAttribute att = preSelectedAtt;
		if (att==null && ent!=null) {
			att = ent.pickUpAttRandomly();
			if (att==null){
				int defCands[] = null;
				if (attForCase!=null && addForCase) {
					int cands[] = new int[]{Globals.MODIF_ADD_ATTRS,Globals.MODIF_DEL_ATTRS,Globals.MODIF_REP_ATTRS};
					defCands = this.createDefCands(cands,entForCase);
				}
				else {
					defCands = new int[]{Globals.MODIF_ADD_ATTRS,Globals.MODIF_DEL_ATTRS,Globals.MODIF_REP_ATTRS};
				}
				this.setAllowed(allowed,false,defCands);
			}
		}
		
		Entry entToAdd = null;
		if (allowed[Globals.ADD_ENTRIES]) entToAdd = TestCase.createEntry((new Entry(sp,new Vector())).getRdnId(),sp,modified);
		if (allowed[Globals.ADD_ENTRIES] && entToAdd==null) this.setAllowed(allowed,false,new int[]{Globals.ADD_ENTRIES});
		MyAttribute attForEntToAdd = null;
		if (entToAdd!=null) attForEntToAdd = entToAdd.pickUpAttRandomly();
		
		Entry[] entList = new Entry[Globals.NUMB_OF_OPERS];
		
		entList[Globals.MODIF_ADD_ATTRS] = (addForCase?entForCase[Globals.MODIF_ADD_ATTRS]:ent);
		entList[Globals.MODIF_DEL_ATTRS] = (addForCase?entForCase[Globals.MODIF_DEL_ATTRS]:ent);
		entList[Globals.MODIF_REP_ATTRS] = (addForCase?entForCase[Globals.MODIF_REP_ATTRS]:ent);
		entList[Globals.ADD_ENTRIES] = (addForCase?entForCase[Globals.ADD_ENTRIES]:entToAdd);
		entList[Globals.DEL_ENTRIES] = (addForCase?entForCase[Globals.DEL_ENTRIES]:ent);
		
		MyAttribute[] attList = new MyAttribute[Globals.NUMB_OF_OPERS];
		attList[Globals.MODIF_ADD_ATTRS] = (addForCase?attForCase[Globals.MODIF_ADD_ATTRS]:att);
		attList[Globals.MODIF_DEL_ATTRS] = (addForCase?attForCase[Globals.MODIF_DEL_ATTRS]:att);
		attList[Globals.MODIF_REP_ATTRS] = (addForCase?attForCase[Globals.MODIF_REP_ATTRS]:att);
		attList[Globals.ADD_ENTRIES] = (addForCase?attForCase[Globals.ADD_ENTRIES]:attForEntToAdd);
		attList[Globals.DEL_ENTRIES] = (addForCase?attForCase[Globals.DEL_ENTRIES]:att);
		if (Certification.DEBUGGING_INFO) Loggin.Log("Operations ... Launch ...: "+bl(allowed)+"----"+il(numbOfOpers));
		int totNumbOfOpers = sumList(numbOfOpers);
		int sums[]=new int[Globals.NUMB_OF_TEST_CASES], operCodes[]=new int[Globals.NUMB_OF_TEST_CASES], nTC=0;
		TestCase tCList[] = new TestCase[Globals.NUMB_OF_TEST_CASES];
		for (int i=0; i<Globals.NUMB_OF_OPERS; i++) {
			if (allowed[i]==false) continue;
			Entry currEnt = entList[i];
			if (currEnt==null) continue;
			MyAttribute currAtt = attList[i];
			int percentOper = Math.max(0,((numbOfOpers[i]*100)/Math.max(1,totNumbOfOpers))+1);
			for (Iterator it=Globals.TEST_CASES_GROUPS[i].keySet().iterator(); it.hasNext(); ) {
				String key = (String)it.next();
				Class tcClass = (Class)Globals.TEST_CASES_GROUPS[i].get(key);
				TestCase tc = null;
				try {
					Constructor constru = tcClass.getConstructor(new Class[]{MyAttribute.class,Entry.class,EntrySet.class});
					tc = (TestCase)constru.newInstance(new Object[]{null,null,null});
				}
				catch (Exception exc) {
					if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in Testing.launchOper");
				}
				String tcId = tc.getTestCaseId();
				if (Globals.hasTestCaseByRdnId(currEnt.getRdnId(),(currAtt==null?null:currAtt.getName()),tcId)==false) continue;
				boolean hasProp = true;
				MyHashMap propsSet = tc.getProps();
				for (Iterator itProp=propsSet.keySet().iterator(); itProp.hasNext(); ) {
					String propId = (String)itProp.next();
					String yesNo = (String)propsSet.get(propId);
					try {
						if ((yesNo.equalsIgnoreCase("yes") && Globals.hasPropertyByRdnId(currEnt.getRdnId(),currAtt.getName(),propId)==false) ||
							(yesNo.equalsIgnoreCase("no") && Globals.hasPropertyByRdnId(currEnt.getRdnId(),currAtt.getName(),propId)==true)) {
							hasProp = false;
							break;
						}
					}
					catch (Exception exc) {
						if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in Testing.launchOper");
					}
				}
				if (hasProp==false) continue;
				tc.setParams(currAtt,currEnt,modified);
				tCList[nTC]=tc;
				operCodes[nTC]=i;
				int x = Math.max(1,(tc.getPriority() * percentOper)+1);
				sums[nTC]=(nTC==0?x:sums[nTC-1]+x);
				nTC++;
			}
		}
		if (nTC==0) return true;
		int pickedVal = Globals.randGen.nextInt(sums[nTC-1]);
		int pickedTC = 0;
		for (; sums[pickedTC]<pickedVal; pickedTC++);
		this.currents[operCodes[pickedTC]]++;
		numbOfOpers[operCodes[pickedTC]]--;
		TestCase tc = tCList[pickedTC];
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"Launching test case: "+tc.getTestCaseId()+" -> "+tc.writePreData());
		if (justExecute) {
			tc.justExecute();
			return true;
		}
		else {
			boolean res = tc.test();
			if (res==false) Loggin.Log(Globals.indent()+"ERROR: Test case failed");
			if (operCodes[pickedTC]==Globals.ADD_ENTRIES && tc.getTestCaseId().equalsIgnoreCase(Globals.TC_A_LEGAL_DN)) {
				if (TestCase.createEntry((new Entry(entToAdd.getDn(),new Vector())).getRdnId(),entToAdd.getDn(),modified)!=null) this.totalEntriesWhereAdding++;
				this.totalEntries++;
				newEnts.addEntry(entToAdd);
			}
			else if (operCodes[pickedTC]==Globals.DEL_ENTRIES && tc.getTestCaseId().equalsIgnoreCase(Globals.TC_D_EXISTING_ENTRY)) {
				if (modified.containsEntry(ent)==false) {
					if (TestCase.createEntry((new Entry(ent.getDn(),new Vector())).getRdnId(),ent.getDn(),modified)!=null) this.totalEntriesWhereAdding--;
					this.totalEntries--;
					newEnts.removeEntry(ent);
					this.totalEntries = Math.max(1,this.totalEntries);
					this.totalEntriesWhereAdding = Math.max(1,this.totalEntriesWhereAdding);
				}
			}
			return res;
		}
	}
	
	
	/**
	 * Checks if the maximum number of entry additions has been reached
	 * @return 'true' if the maximum number of entry additions has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean addsCondition () {
		
		return this.currents[Globals.ADD_ENTRIES]<this.maxims[Globals.ADD_ENTRIES];
	}
	

	/**
	 * Checks if the maximum number of entry deletions has been reached
	 * @return 'true' if the maximum number of entry deletions has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean delsCondition () {
	
		return this.currents[Globals.DEL_ENTRIES]<this.maxims[Globals.DEL_ENTRIES];
	}
	
	
	/**
	 * Checks if the maximum number of attribute modifications has been reached
	 * @return 'true' if the maximum number of attribute modifications has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean modifsAddCondition () {
		
		return this.currents[Globals.MODIF_ADD_ATTRS]<this.maxims[Globals.MODIF_ADD_ATTRS];
	}
	
	
	/**
	 * Checks if the maximum number of attribute modifications has been reached
	 * @return 'true' if the maximum number of attribute modifications has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean modifsDelCondition () {
		
		return this.currents[Globals.MODIF_DEL_ATTRS]<this.maxims[Globals.MODIF_DEL_ATTRS];
	}
	
	
	/**
	 * Checks if the maximum number of attribute modifications has been reached
	 * @return 'true' if the maximum number of attribute modifications has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean modifsRepCondition () {
		
		return this.currents[Globals.MODIF_REP_ATTRS]<this.maxims[Globals.MODIF_REP_ATTRS];
	}
	
	
	/**
	 * Checks if the maximum number of attribute modifications has been reached
	 * @return 'true' if the maximum number of attribute modifications has not been reached
	 * 		   'false' otherwise
	 */
	protected boolean modifsCondition () {
		
		return this.modifsAddCondition() || this.modifsDelCondition() || this.modifsRepCondition();
	}
	
	
	protected boolean condition () {
		
		if (this.timeCondition()==false) return false;
		if (this.addsCondition()==false &&
			this.delsCondition()==false &&
			this.modifsCondition()==false) return false;
		return true;
	}
	
	
	protected boolean allOperDone () {
		
		return (this.addsCondition()==false && this.delsCondition()==false && this.modifsCondition()==false);
	}

	
	protected boolean allFalse (boolean []arr) {
		
		if (arr==null) return true;
		for (int i=0; i<arr.length; i++) {
			if (arr[i]) return false;
		}
		return true;
	}
	
	
	protected int countNumbEntsWhereAdding (EntrySet entSet) {
		
		int res = 0;
		EntrySet emptySet = new EntrySet();
		
		for (entSet.startIterator(); entSet.hasNext(); ) {
			Entry ent = entSet.next();
			if (TestCase.createEntry((new Entry(ent.getDn(),new Vector())).getRdnId(),ent.getDn(),emptySet)!=null) res++;
		}
		
		return res;
	}

	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	static protected String bl (boolean []l) {
		
		String res = "{";
		for (int i=0; i<l.length; i++) {
			if (res.length()>1) res+=",";
			res+=(l[i]?"t":"f");
		}
		return res+"}";
	}
	
	
	static protected String il (int []l) {
		
		String res = "{";
		for (int i=0; i<l.length; i++) {
			if (res.length()>1) res+=",";
			res+=l[i];
		}
		return res+"}";
	}
}
