import java.util.Vector;


public class TestCase_MA_MULTIVALUE extends TestCase_MA {
	
	
	final private String TEST_CASE_ID = Globals.TC_MA_MULTIVALUE;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 100;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
		put(Globals.PROP_MULTIVALUE,"no");
		put(Globals.PROP_APPENDABLE,"no");
		put(Globals.PROP_MODIFIABLE,"yes");
	}};
	MyHashMap getProps () {return this.PROPS;}
	
	
	public TestCase_MA_MULTIVALUE (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
	}
	
	void calculateVals () {
		super.calculateVals();
		try {
			boolean admitDupVals = Globals.hasPropertyByRdnId(this.ent.getRdnId(),this.att.getName(),Globals.PROP_ALLOWS_DUPLICATE) &&
									Globals.hasTestCaseByRdnId(this.ent.getRdnId(),this.att.getName(),Globals.TC_MA_DUPLICATE_VALUES);
			this.vals = (Vector)this.att.getValues().clone();
			if (this.att.getNumbOfValues()>0) {
				int nVals = Globals.randGen.nextInt(this.MAX_NUMB_VALS_FOR_MA);
				for (int i=0; i<nVals; i++) {
					String val = Globals.getLegalValue(this.ent.getRdnId(),att.getName());
					if (admitDupVals && Globals.randGen.nextInt(100)<33 && this.att.getNumbOfValues()>0) {
						val = this.att.getValueAt(Globals.randGen.nextInt(this.att.getNumbOfValues()));
					}
					this.vals.add(val);
				}
			}
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in TestCase_MA_MULTIVALUE.calculateVals");
		}
	}
	
	void calculateExpected () {}
}
