import java.util.Iterator;
import java.util.Vector;


public class TestCase_MAA_REPLACE extends TestCase_M {

	final private String TEST_CASE_ID = Globals.TC_MAA_REPLACE;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 500;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
	}};
	MyHashMap getProps () {return this.PROPS;}

	private Vector valsToRep = null;
	
	
	public TestCase_MAA_REPLACE (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_REP_ATTRS;
	}
	
	
	public TestCase_MAA_REPLACE (MyAttribute att, Entry ent, EntrySet modified, Vector aVals) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_REP_ATTRS;
		this.valsToRep = aVals;
	}
	
	
	void calculateVals () {
		super.calculateVals();
		
		try {
			
			if (this.valsToRep==null) {
				
				MyHashMap attList = Globals.getAttListByRdnId(this.ent.getRdnId());
				Vector possAtts = new Vector();
				
				for (Iterator it=attList.keySet().iterator(); it.hasNext(); ) {
					String attName = (String)it.next();
					if (Globals.hasPropertyByRdnId(this.ent.getRdnId(),attName,Globals.PROP_MAY) && 
						this.ent.containsAttributeByName(attName)==null) {
						possAtts.add(attName);
					}
				}
				
				String pickedAttName = null;
				if (possAtts.size()>0) pickedAttName = (String)possAtts.elementAt(Globals.randGen.nextInt(possAtts.size()));
				
				this.att = (pickedAttName==null?null:this.createLegalAtt(this.ent,this.ent.getRdnId(),pickedAttName,1));
				if (this.att!=null) this.vals = this.att.getValues();
			}
			else {
				this.vals = this.valsToRep;
			}
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in TestCase_MAA_REPLACE.calculateVals");
		}
	}
	
	
	void calculateExpected () {
		this.ent.addAttribute(this.att);
	}
	
	
	boolean checkEquality () {
		if (this.att==null) return true;
		return (this.checkEqOfEntry() && super.checkEquality());
	}
}
