import java.util.Vector;

import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;


abstract public class TestCase_M extends TestCase {
	
	protected Vector vals = new Vector();
	protected int modif_opt = -1;
	
	public TestCase_M (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
		
	}
	
	void calculateVals () {
		if (this.ent!=null && this.att!=null) {
			try {
				if (Globals.hasPropertyByRdnId(this.ent.getRdnId(),this.att.getName(),Globals.PROP_AUTOMATIC_MAY) ||
					Globals.hasPropertyByRdnId(this.ent.getRdnId(),this.att.getName(),Globals.PROP_AUTOMATIC_MUST)) {
					
					MyAttribute ma = this.pickUpAttribute(this.ent.getDn(),this.att.getName());
					this.att = ma;
					this.ent.setAttribute(this.att);
				}
			}
			catch (Exception exc) {}
		}
	}
	
	
	MVDOperationResult executeCase () {
		if (this.att==null) return new MVDOperationResult();
		Vector modAtt = this.createModifAtt(this.att.getName(),this.vals,this.modif_opt);
		return Globals.ldapm.modify(this.ent.getDn(),modAtt);
	}
	
	
	boolean checkEquality () {
		
		if (this.att==null) return true;
		MyAttribute modAtt = this.pickUpAttribute(this.ent.getDn(),this.att.getName());
		if (modAtt==null) {
			Error.internalUnexpected(this.ent.getDn());
			return false;
		}
		
		Loggin.Log(Globals.indent()+"Expected value for attribute \""+att.getName()+"\"->"+(this.att.getNumbOfValues()>0?this.att.getValues():new Vector()));
		Loggin.Log(Globals.indent()+"Real value according to VDS for attribute \""+att.getName()+"\"->"+(modAtt.getValues()!=null?modAtt.getValues():new Vector()));
		
		/* Compares if the expected value matches with the current one in VDS */
		if (this.att.equals(modAtt)==false) return false;
		
		return true;
	}
	
	
	protected boolean checkEqOfEntry () {
		
		/* Gets the current entry in VDS */
		Entry modEnt = this.pickUpEntry(this.ent.getDn());
		/* Compares the entries */
		return this.ent.equalsOnlyDefinitionAndNotAutomatic(modEnt);
	}
}
