import com.sap.idm.vds.MVDSearchResults;


public class TestCase_D_EXISTING_ENTRY extends TestCase_D {

	
	final private String TEST_CASE_ID = Globals.TC_D_EXISTING_ENTRY;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 1000;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
	}};
	MyHashMap getProps () {return this.PROPS;}
	
	private boolean hasChildren = true;
	
	public TestCase_D_EXISTING_ENTRY (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
	}
	
	
	void calculateVals () {
		
		this.entryToDelete = this.ent;
	}
	
	
	void calculateExpected () {
		if (this.entryToDelete==null) return;
		MVDSearchResults searchRes = Globals.ldapm.search(this.entryToDelete.getDn(),LDAPManagement.ONE_LEVEL,Globals.attr,Globals.urlfilter,Globals.szLimit,Globals.tmLimit,true);
		if (searchRes!=null && searchRes.size()>0) return;
		this.hasChildren=false;
		if (this.modified!=null) this.modified.removeEntry(this.entryToDelete);
	}
	
	
	boolean checkEquality () {
		
		return this.checkAddAndDeleteEntryResult(this.modified,this.entryToDelete.getSP(),this.entryToDelete.getDn(),(this.hasChildren?this.FIND:this.NOT_FIND));
	}
}
