import java.util.Collections;
import java.util.Vector;


/**
 * This class represents an attribute
 * 
 * @author I054742
 *
 */
class MyAttribute implements Cloneable {
	
	static final String ATT_VALS_SEP = "|";
	
	/* Attribute name */
	private String name = null;
	/* Set of values of the attribute */
	private Vector values = null;
	
	private Entry relatedEntry = null;
	
	/* Indicates if the set of attributes is sorted */
	private boolean isSorted = false;
	
	
	
	/**
	 * Constructor
	 * @param aName Attribute name
	 * @param aValues Initial values
	 */
	MyAttribute (String aName, Vector aValues, Entry relEnt) {
		
		this.name=aName;
		GenericMethods.cleanTALSpaces(aValues);
		this.values=aValues;
		this.relatedEntry=relEnt;
	}
	
	
	String writeData () {
		return this.name+"->"+this.values;
	}
	
	
	/**
	 * Constructor
	 * @param aName Attribute name
	 * @param aValues Initial values
	 */
	/*MyAttribute (String aName, Vector aValues) {
		
		this.name=aName;
		this.values=aValues;
	}*/
	
	
	/**
	 * Gives the set of values of the attribute
	 * @return The set of values
	 */
	Vector getValues () {
		
		return this.values;
	}
	
	
	/**
	 * Gives the attribute name
	 * @return The attribute name
	 */
	String getName () {
		
		return this.name;
	}
	
	
	Entry getRelatedEntry () {
		
		return this.relatedEntry;
	}
	
	
	void setRelatedEntry (Entry relEnt) {
		
		this.relatedEntry = relEnt;
	}
	
	
	
	/**
	 * Indicates if the set of values is sorted
	 * @return 'true' if it sorted
	 * 		   'false' otherwise
	 */
	boolean isSorted () {
		
		return this.isSorted;
	}
	
	
	/**
	 * Gives the number of values
	 * @return The number of values
	 */
	int getNumbOfValues () {
		
		return this.values.size();
	}
	
	
	boolean isBlank () {
		
		if (this.values.size()==0) return true;
		for (int i=0; i<this.values.size(); i++) {
			if (((String)this.values.elementAt(i)).length()>0) return false;
		}
		return true;
	}
	
	
	/**
	 * Adds the values in 'v' to the current values
	 * @param v The values to be added
	 */
	public void addValue (Vector v) {
		
		boolean appendable = false;
		try  {appendable = Globals.hasPropertyByRdnId(this.relatedEntry.getRdnId(),this.name,Globals.PROP_APPENDABLE);}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in MyAttribute.addValue");
			Loggin.Log(Globals.indent()+"ERROR: Internal error");
			return;
		}
		GenericMethods.cleanTALSpaces(v);
		if (!appendable) {
			for (int i=0; i<v.size(); i++) this.values.add(v.elementAt(i));
		}
		else {
			for (int i=0; i<v.size(); i++) {
				if (this.values.size()==0) this.values.add("");
				this.values.setElementAt(((String)this.values.elementAt(0))+(String)v.elementAt(i),0);
			}
		}
		this.isSorted=false;
	}
	
	
	/**
	 * Removes from the values of this attribute that are the same that the values that we find in 'v'.
	 * It is considered that 'v' only will contain one value
	 * @param v The set of values to be deleted
	 * @return 'true' if we can find the value of 'v' among the values of this attribute
	 * 		   'false' otherwise
	 */
	public boolean removeValue (Vector v) {
		
		GenericMethods.cleanTALSpaces(v);
		String s = (String)v.elementAt(0);
		for (int i=0; i<this.values.size(); i++) {
			if (s.equalsIgnoreCase((String)this.values.elementAt(i))==true) {
				this.values.remove(i);
				return true;
			}
		}
		return false;
	}
	
	
	public void removeValues (Vector v) {
		
		GenericMethods.cleanTALSpaces(v);
		for (int k=0; k<v.size(); k++) {
			String s = (String)v.elementAt(k);
			for (int i=0; i<this.values.size(); i++) {
				if (s.equalsIgnoreCase((String)this.values.elementAt(i))==true) {
					this.values.remove(i);
				}
			}
		}
	}
	
	
	/**
	 * Removes all the values
	 */
	void removeAllValues (boolean leaveBlank) {
		
		this.values.removeAllElements();
		if (leaveBlank) this.values.add("");
	}
	
	
	/**
	 * Replaces all the values of this attribute by the one that we find in 'v'
	 * @param v Here is the value used for replacing
	 */
	void replaceValue (Vector v) {
		
		GenericMethods.cleanTALSpaces(v);
		this.values.removeAllElements();
		this.values.add(v.elementAt(0));
		this.isSorted=true;
	}
	
	
	
	
	
	/**
	 * Checks if the the value 's' is a value of this attribute
	 * @param s The value
	 * @return 'true' if 's' is a value of this attribute
	 * 		   'false' otherwise
	 */
	boolean containsValue (String s) {
		
		s = GenericMethods.cleanTrailingAndLeadingSpaces(s);
		for (int i=0; i<this.values.size(); i++) {
			if (s.equalsIgnoreCase((String)this.values.elementAt(i))==true) {
				return true;
			}
		}
		return false;
	}
	
	
	
	boolean containsAllValues (Vector vals) {
		
		for (int i=0; i<vals.size(); i++) {
			if (this.containsValue((String)vals.elementAt(i))==false) return false;
		}
		return true;
	}
	
	
	/**
	 * Gives the value that is in position 'index'
	 * @param index The position
	 * @return The value
	 */
	String getValueAt (int index) {
		
		return (String)this.values.elementAt(index);
	}
	
	
	/**
	 * Sorts the set of values of this attribute
	 */
	void sort () {
		try {
			Collections.sort(this.values);
		}
		catch (ClassCastException exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in MyAttribute.sort");
		}
	}
	
	
	/**
	 * Creates a clone of this attribute
	 */
	public Object clone () {
		
		return new MyAttribute(this.name,GenericMethods.cloneVector(this.values),this.relatedEntry);
	}
	
	
	void setValues (Vector newVals) {
		
		this.values = (Vector)newVals.clone();
	}
	
	
	/**
	 * Checks if two attribute are equals (by name and values)
	 * @param a The attribute to be compared with this
	 * @return 'true' if they are equals
	 * 		   'false' otherwise
	 */
	boolean equals (MyAttribute attSystem) {
		
		if (attSystem.getName().equalsIgnoreCase(this.name)==false) {
			Error.diffAttributes(this,attSystem);
			return false;
		}
		if (this.values.size()!=attSystem.getNumbOfValues()) {
			Error.diffAttributes(this,attSystem);
			return false;
		}
		if (this.isSorted==false) this.sort();
		if (attSystem.isSorted()==false) attSystem.sort();
		for (int i=0; i<this.values.size(); i++) {
			try {
				String s1 = attSystem.getValueAt(i);
				String s2 = this.getValueAt(i);
				if (s1.equalsIgnoreCase(s2)==false) {
					Error.diffAttributes(this,attSystem);
					return false;
				}
			}
			catch (ClassCastException exc) {
				if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in MyAttribute.equals");
			}
		}
		return true;
	}
}
