import java.io.*;
import java.util.*;


/**
 * Reads the Instructions file
 * 
 * @author I054742
 *
 */
public class InstructionsFile extends FileParsingMethods {

	
	static Vector insts = null;
	static Vector getInsts () {return insts;}
	
	/* Configuration file */
	static private String INSTRUCTION_FILE = ".\\instr\\Instructions.instr";
	
	/**
	 * Parses the instructions file 'Instructions.instr'
	 * @return
	 */
	static Vector readFile () throws Exception {
		
		Loggin.Log(Globals.indent()+"Reading instructions file...");
		Globals.incIndent();
		
		try {
			File file = new File(INSTRUCTION_FILE);
			if (file.exists()==false || file.isDirectory()) {
				
				Loggin.Log(Globals.indent()+"ERROR: The instruction file "+INSTRUCTION_FILE+" does not exist");
				throw new Exception();
			}
			
			RandomAccessFile raf = new RandomAccessFile(INSTRUCTION_FILE,"rw");
			nLine = 0;
			insts = new Vector();
			String line = null;
			while ((line=readLine(raf,0))!=null) {
				line = GenericMethods.cleanTrailingAndLeadingSpaces(line);
				Instruction inst = Instruction.makeInstruction(line,nLine,true);
				if (inst==null) {
					inst = null;
					throw new Exception();
				}
				if (inst.getDn().endsWith(GeneralConfiguration.getStartingPoint())==false) {
					Loggin.Log(Globals.indent()+"WARNING: The instruction: \""+line+"\" in line: "+nLine+" will be discarded since its DN does not match with the initial starting point held into the general configuration file");
				}
				else insts.add(inst);
			}
			raf.close();
			Loggin.Log(Globals.indent()+"Instruction file read successfully");
			
			return insts;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in InstructionsFile.readFile");
			Loggin.Log(Globals.indent()+"ERROR: Error while reading instructions file");
			insts = null;
			throw new Exception();
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Instructions file reading finished");
		}
	}
}
