import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;


/**
 * Reads the InstructionsAndExpecteds file
 * 
 * @author I054742
 *
 */
public class InstructionsAndExpectedsFile extends FileParsingMethods {

	static Vector instsAndExpects = null;
	static Vector getInstsAndExpects () {return instsAndExpects;}
	
	/* Configuration file */
	static private String INSTRUCTION_FILE = ".\\instr\\InstructionsAndExpecteds.instr";
	
	
	/**
	 * Parses the instructions file 'InstructionsAndExpecteds.instr'
	 * @return
	 */
	static void readFile () throws Exception {
		
		Loggin.Log(Globals.indent()+"Reading instructions and expecteds file...");
		Globals.incIndent();
		
		try {
			File file = new File(INSTRUCTION_FILE);
			if (file.exists()==false || file.isDirectory()) {
				
				Loggin.Log(Globals.indent()+"ERROR: The instruction file "+INSTRUCTION_FILE+" does not exist");
				throw new Exception();
			}
			
			RandomAccessFile raf = new RandomAccessFile(INSTRUCTION_FILE,"rw");
			nLine = 0;
			instsAndExpects = new Vector();
			String line = null;
			while ((line=readLine(raf,0))!=null) {
				line = GenericMethods.cleanTrailingAndLeadingSpaces(line);
				Instruction inst = Instruction.makeInstruction(line,nLine,false);
				if (inst!=null) {
					instsAndExpects.add(inst);
					continue;
				}
				
				Expected expect = Expected.makeExpected(line,nLine);
				if (expect==null) {
					Loggin.Log(Globals.indent()+"ERROR: The instruction in line: "+line+" is illegal");
					throw new Exception();
				}
				else instsAndExpects.add(expect);
				
			}
			raf.close();
			Loggin.Log(Globals.indent()+"Instruction and expecteds file read successfully");
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in InstructionsFile.readFile");
			Loggin.Log(Globals.indent()+"ERROR: Error while reading instructions and expecteds file");
			instsAndExpects = null;
			throw new Exception();
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Instructions and expecteds file reading finished");
		}
	}
}
