import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;


/**
 * This class contains a set of methods of common use
 * 
 * @author I054742
 *
 */
class GenericMethods {

	
	/**
	 * Transforms any String Collection object to an array
	 * @param co The String Collection object
	 * @return The String array
	 */
	static String[] fromCollectionToArray (Collection co) {
		
		String res[] = new String[co.size()];
		int i=0;
		for (Iterator it=co.iterator(); it.hasNext(); ) {
			res[i++]=(String)it.next();
		}
		return res;
	}
	
	/**
     * Removes the trailing and leading spaces of a string
     * @param str -> The string to be treated
     * @return -> 'str' without trailing and leading spaces
     */
    static String cleanTrailingAndLeadingSpaces (String str) {
    	
    	/* If the string is null or has no chars then the result is the same string */
    	if (str==null) return null;
    	if (str.length()==0) return str;
    	int i=0, j=str.length()-1;
    	/* Removes the trailing and leading spaces */
    	while (i<str.length() && (str.charAt(i)==' ' || str.charAt(i)=='\t')) i++;
    	while (j>i && (str.charAt(j)==' ' || str.charAt(j)=='\t')) j--;
    	return str.substring(i,j+1);
    }
    
    
    /**
     * Collects a set of strings separated by commas
     * @param str The string where the set of string is
     * @return An array of String with the collected strings
     */
    static String[] collectStrings (String str, char open, char close, String separator) {
    	
    	str = GenericMethods.cleanTrailingAndLeadingSpaces(str);
    	str = GenericMethods.cleanBrackets(str,open,close);
    	str = GenericMethods.cleanTrailingAndLeadingSpaces(str);
    	if (str.length()==0) {
    		return new String[0];
    	}
    	Vector v = new Vector();
    	int index;
    	
    	while ((index=str.indexOf(separator))>=0) {
    		
    		String s = GenericMethods.cleanTrailingAndLeadingSpaces(str.substring(0,index));
    		if (s.length()>0) v.add(s);
    		str=str.substring(index+1,str.length());
    	}
    	v.add(GenericMethods.cleanTrailingAndLeadingSpaces(str));
    	String res[] = new String[v.size()];
    	for (int i=0; i<v.size(); i++) res[i] = (String)v.elementAt(i);
    	
    	return res;
    }
    
    
    static Vector fromArrStringToVector (String []arr) {
    	
    	Vector v = new Vector(arr.length);
    	
    	for (int i=0; i<arr.length; i++) v.add(arr[i]);
    	
    	return v;
    }
    
    
    /**
     * Transforms an String array to MyHashMap
     * @param arr The String array
     * @return The result 
     */
    static MyHashMap fromArrStringToMyHashMap (String []arr) {
    	
    	MyHashMap res = new MyHashMap();
    	
    	for (int i=0; i<arr.length; i++) {
    		res.put(arr[i],null);
    	}

    	return res;
    }
    
    
    /**
     * Removes parenthesis in the beginning and end of a String
     * @param str -> The string to be treated
     * @return -> 'str' without trailing and leading spaces
     */
    static String cleanBrackets (String str, char open, char close) {
    	
    	/* If the string is null or has no chars then the result is the same string */
    	if (str==null) return null;
    	if (str.length()==0) return str;
    	/* Removes the parenthesis */
    	if (str.charAt(0)==open) str=str.substring(1);
    	if (str.length()==0) return str;
    	if (str.charAt(str.length()-1)==close) str=str.substring(0, str.length()-1);
    	return str;
    }
    
    
    /**
     * Gives a String object with the time 'milisecs' expressed in days, hours, minutes, seconds and miliseconds.
     * 'milisecs' is an amount the time in miliseconds
     * @param milisecs The amount of time in miliseconds
     * @return The time expressed as is required
     */
    static String expressProperlyTime (long milisecs) {
		
		long mils = milisecs%1000;
		long secs = (milisecs/1000)%60;
		long mins = (milisecs/(1000*60))%60;
		long hours = (milisecs/(1000*60*60))%24;
		long days = milisecs/(1000*60*60*24);
		String res= new String();
		boolean include = false;
		
		if (days>0) {res+=days+" days";include=true;}
		if (hours>0) {res+=(include?", ":"")+hours+" hours";include=true;}
		if (mins>0) {res+=(include?", ":"")+mins+" mins";include=true;}
		if (secs>0) {res+=(include?", ":"")+secs+" secs";include=true;}
		res+=(include?", ":"")+mils+" milisecs";
		
		return res;
	}
    
    
    /**
     * Cleans every space of 'str'
     * @param str The String to be cleaned
     * @return The cleaned String
     */
    static String cleanSpaces (String str) {
    	
    	String res = new String();
    	
    	for (int i=0; i<str.length(); i++) {
    		
    		char c = str.charAt(i);
    		if (c!=' ' && c!='\t') res+=c;
    	}
    	
    	return res;
    }
    
    
    /**
     * Clones the vector 'v'
     * @param v The vector
     * @return The new clone
     */
    static Vector cloneVector (Vector v) {
    	
    	if (v==null) return null;
    	Vector res = new Vector();
    	for (int i=0, len=v.size(); i<len; i++) res.add(v.elementAt(i));
    	return res;
    }
    
    
    /**
     * Transforms a Vector in a HashMap
     * @param attrs The Vector
     * @return The HashMap
     */
    static HashMap fromAttVectorToHashMap (Vector attrs) {
    	
    	HashMap res = new HashMap();
    	
    	for (int i=0; i<attrs.size(); i++) {
    		
    		MyAttribute ma = (MyAttribute)attrs.elementAt(i);
    		res.put(ma.getName(),ma.getValues());
    	}
    	
    	return res;
    }
    
    
    static boolean vectorContainsString (Vector v, String s, boolean ignoreCase) {
    	
    	for (int i=0; i<v.size(); i++) {
    		String vs = (String)v.elementAt(i);
    		if (ignoreCase) {
    			if (vs.equalsIgnoreCase(s)) return true;
    		}
    		else {
    			if (vs.equals(s)) return true;
    		}
    	}
    	
    	return false;
    }
    
    
    static String[] vectorToArrayString (Vector v) {
    	
    	String []res = new String[v.size()];
    	
    	for (int i=0; i<v.size(); i++) {
    		res[i] = (String)v.elementAt(i);
    	}
    	
    	return res;
    }
    
    
    static boolean vectorContainsDuplicates (Vector v, boolean ignoreCase) {
    	
    	HashMap elems = new HashMap();
    	
    	for (int i=0; i<v.size(); i++) {
    		
    		String e = (String)v.elementAt(i);
    		if (ignoreCase) e = e.toLowerCase();
    		if (elems.containsKey(e)) return true;
    		elems.put(e,"");
    	}
    	
    	return false;
    }
    
    
    static void cleanTALSpaces (Vector list) {
    	
    	if (list==null) return;
    	for (int i=0; i<list.size(); i++) {
    		list.setElementAt(cleanTrailingAndLeadingSpaces((String)list.elementAt(i)),i);
    	}
    }
    
    
    static MyHashMap fromVectorToMyHashMap(Vector vParts, String value) {
    	
    	MyHashMap res = new MyHashMap();
    	
    	for (int i=0; i<vParts.size(); i++) res.put(vParts.elementAt(i),value);
    	
    	return res;
    }
}
