import java.util.*;

import com.sap.idm.vds.*;
import java.lang.reflect.*;


/**
 * Common methods for any of the functionality testings
 * 
 * @author I054742
 *
 */
abstract public class FunctionalityTesting extends Testing {

	protected final int MAX_NUMBER_MODIFICATIONS_PER_ATTRIBUTE = 4;
	protected int MAX_NUMBER_OF_CALLS_TO_SP = 64;
	
	/* Set of entries where is possible to add new entries */
	protected TreeSet entriesWhereAdding = new TreeSet();
	
	protected int maximum;
	protected int callsToInitialSP = 0;
	
	abstract protected boolean tester (String startingPoint, int deepness);
	
	
	void writeReport () {
		
		this.writeHeader();
		
		Loggin.Log(Globals.indent()+this.testName+" "+(this.success?"test was executed successfully":"test stops when the next error was found: "+Globals.errorMessage));
		Loggin.Log("");
		if (this.success && this.timeExpired) {
			Loggin.Log(Globals.indent()+"Time for the execution expired before all the cases were done");
			Loggin.Log("");
		}
		boolean complete = this.allOperDone();
		if (this.success && !complete) {
			Loggin.Log(Globals.indent()+"Not all the desired operation could be done");
			Loggin.Log("");
		}
		Loggin.Log(Globals.indent()+this.currents[Globals.MODIF_ADD_ATTRS]+" attribute MODIFICATIONS with ADD option were tried out of "+this.maxims[Globals.MODIF_ADD_ATTRS]);
		Loggin.Log(Globals.indent()+this.currents[Globals.MODIF_DEL_ATTRS]+" attribute MODIFICATIONS with DELETE optionwere tried out of "+this.maxims[Globals.MODIF_DEL_ATTRS]);
		Loggin.Log(Globals.indent()+this.currents[Globals.MODIF_REP_ATTRS]+" attribute MODIFICATIONS with REPLACE optionwere tried out of "+this.maxims[Globals.MODIF_REP_ATTRS]);
		Loggin.Log(Globals.indent()+this.currents[Globals.ADD_ENTRIES]+" entry ADDITIONS were tried out of "+this.maxims[Globals.ADD_ENTRIES]);
		Loggin.Log(Globals.indent()+this.currents[Globals.DEL_ENTRIES]+" entry DELETIONS were tried out of "+this.maxims[Globals.DEL_ENTRIES]);
		
		Loggin.Log("");
		this.writeNumbOfTC();
		
		Loggin.Log("");
		Globals.ldapm.writeReport();
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"Execution time: "+GenericMethods.expressProperlyTime(this.endTime-this.startTime));
	}

	
	/**
	 * Makes the initial parsing for operation distribution
	 * @param sp
	 */
	protected void initialEntryCounting (String sp) {
		
		MVDSearchResults sr = Globals.ldapm.search(sp,LDAPManagement.ONE_LEVEL,Globals.attr,
												   Globals.urlfilter,Globals.szLimit,Globals.tmLimit,false);
		if (sr==null) return;
		this.entriesWhereAdding.add(sp);
		this.totalEntriesWhereAdding++;
		this.totalEntries+=sr.size();
		for (int i=0; i<sr.size(); i++) {
			MVDSearchResultEntry me = (MVDSearchResultEntry)sr.elementAt(i);
			this.initialEntryCounting(me.getDn());
		}
	}
	
	
	private boolean hasTestCase (String rDnId, String attName, MyHashMap testCasesSet) {
		
		for (Iterator it=testCasesSet.keySet().iterator(); it.hasNext(); ) {
			
			String testCaseId = (String)it.next();
			if (Globals.hasTestCaseByRdnId(rDnId,attName,testCaseId)) return true;
		}
		return false;
	}
	
	
	protected boolean hasModifyAddTestCase (String rDnId, String attName) {
		
		return this.hasTestCase(rDnId,attName,Globals.MODIFY_ADD_TEST_CASES);
	}
	
	
	protected boolean hasModifyDelTestCase (String rDnId, String attName) {
		
		return this.hasTestCase(rDnId,attName,Globals.MODIFY_DEL_TEST_CASES);
	}
	
	
	protected boolean hasModifyRepTestCase (String rDnId, String attName) {
		
		return this.hasTestCase(rDnId,attName,Globals.MODIFY_DEL_TEST_CASES);
	}
	
	
	protected boolean hasModifyTestCase (String rDnId, String attName) {
		
		if (this.hasModifyAddTestCase(rDnId,attName)) return true;
		if (this.hasModifyDelTestCase(rDnId,attName)) return true;
		if (this.hasModifyRepTestCase(rDnId,attName)) return true;
		return false;
	}
	
	
	protected boolean possibleToAdd (String sp, EntrySet modified, Entry[] entForCase, MyAttribute[] attForCase) {
		
		if (this.addsCondition()==false) return false;
		Entry ent = TestCase.createEntry((new Entry(sp,new Vector())).getRdnId(),sp,modified);
		if (ent==null) return false;
		if (this.existsSomeTestCase(Globals.ADD_ENTRIES,ent,ent.pickUpAttRandomly(),entForCase,attForCase)==false) return false;
		
		return true;
	}
	

	protected boolean possibleToModify (int opt, EntrySet modified, Entry[] entForCase, MyAttribute[] attForCase) {
		
		int current=this.currents[opt], maxim=this.maxims[opt];
		
		if (current>=maxim) return false;
		
		for (modified.startIterator(); modified.hasNext(); ) {
			Entry ent = modified.next();
			for (int i=0; i<ent.getNumbOfAttrs(); i++) {
				MyAttribute att = ent.getAttributeAt(i);
				if (this.existsSomeTestCase(opt,ent,att,entForCase,attForCase)) return true;
			}
		}
		return false;
	}
	
	
	protected boolean possibleToDelete (EntrySet modified, Entry[] entForCase, MyAttribute[] attForCase) {
		
		for (modified.startIterator(); modified.hasNext(); ) {
			Entry ent = modified.next();
			if (this.existsSomeTestCase(Globals.DEL_ENTRIES,ent,ent.pickUpAttRandomly(),entForCase,attForCase)) return true;
		}
		return false;
	}
	
	protected boolean existsSomeTestCase (int group, Entry currEnt, MyAttribute currAtt, Entry[] entForCase, MyAttribute[] attForCase) {
		
		for (Iterator it=Globals.TEST_CASES_GROUPS[group].keySet().iterator(); it.hasNext(); ) {
			String key = (String)it.next();
			Class tcClass = (Class)Globals.TEST_CASES_GROUPS[group].get(key);
			TestCase tc = null;
			try {
				Constructor constru = tcClass.getConstructor(new Class[]{MyAttribute.class,Entry.class,EntrySet.class});
				tc = (TestCase)constru.newInstance(new Object[]{null,null,null});
			}
			catch (Exception exc) {
				if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in FunctionalityTesting.existsSomeTestCase");
			}
			String tcId = tc.getTestCaseId();
			if (Globals.hasTestCaseByRdnId(currEnt.getRdnId(),currAtt.getName(),tcId)==false) continue;
			boolean hasProp = true;
			MyHashMap propsSet = tc.getProps();
			for (Iterator itProp=propsSet.keySet().iterator(); itProp.hasNext(); ) {
				String propId = (String)itProp.next();
				String yesNo = (String)propsSet.get(propId);
				try {
					if ((yesNo.equalsIgnoreCase("yes") && Globals.hasPropertyByRdnId(currEnt.getRdnId(),currAtt.getName(),propId)==false) ||
						(yesNo.equalsIgnoreCase("no") && Globals.hasPropertyByRdnId(currEnt.getRdnId(),currAtt.getName(),propId)==true)) {
						hasProp = false;
						break;
					}
				}
				catch (Exception exc) {
					if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in FunctionalityTesting.existsSomeTestCase");
				}
			}
			if (hasProp==false) continue;
			entForCase[group] = currEnt;
			attForCase[group] = currAtt;
			return true;
		}
		return false;
	}
	
	
	protected int repeatOpers (boolean []allow, int[] nOfOpers) {
		
		if (Globals.randGen.nextInt(100)<80) return 0;
		int oper = Globals.randGen.nextInt(Globals.NUMB_OF_OPERS);
		if (allow[oper]==false || nOfOpers[oper]==0) return 0;
		for (int i=0; i<allow.length; i++) allow[oper] = (i==oper);
		
		return Globals.randGen.nextInt(nOfOpers[oper])/(Globals.randGen.nextInt(4)+1);
	}
	
	
	protected boolean localCondition (int[] numbOfOpers) {
		
		if (this.condition()==false) return false;
		for (int i=0; i<Globals.NUMB_OF_OPERS; i++) {
			if (numbOfOpers[i]>0) return true;
		}
		return false;
	}
	

	int[] calcNumbOfOps (int localNumbOfEnts) {
		
		int res[] = new int[Globals.NUMB_OF_OPERS];
		
		int attsToModAdd = (((this.maxims[Globals.MODIF_ADD_ATTRS]*((localNumbOfEnts*100)/this.totalEntries))/100)/(Globals.randGen.nextInt(16)+1))+Globals.randGen.nextInt(2);
		int attsToModDel = (((this.maxims[Globals.MODIF_DEL_ATTRS]*((localNumbOfEnts*100)/this.totalEntries))/100)/(Globals.randGen.nextInt(16)+1))+Globals.randGen.nextInt(2);
		int attsToModRep = (((this.maxims[Globals.MODIF_REP_ATTRS]*((localNumbOfEnts*100)/this.totalEntries))/100)/(Globals.randGen.nextInt(16)+1))+Globals.randGen.nextInt(2);
		int entsToAdd = (((this.maxims[Globals.ADD_ENTRIES]/this.totalEntriesWhereAdding))/(Globals.randGen.nextInt(16)+1))+Globals.randGen.nextInt(2);
		int entsToDel = (((this.maxims[Globals.DEL_ENTRIES]*((localNumbOfEnts*100)/this.totalEntries))/100)/(Globals.randGen.nextInt(16)+1))+Globals.randGen.nextInt(2);
		
		if (attsToModAdd>this.maxims[Globals.MODIF_ADD_ATTRS]-this.currents[Globals.MODIF_ADD_ATTRS]) attsToModAdd = this.maxims[Globals.MODIF_ADD_ATTRS]-this.currents[Globals.MODIF_ADD_ATTRS];
		if (attsToModDel>this.maxims[Globals.MODIF_DEL_ATTRS]-this.currents[Globals.MODIF_DEL_ATTRS]) attsToModDel = this.maxims[Globals.MODIF_DEL_ATTRS]-this.currents[Globals.MODIF_DEL_ATTRS];
		if (attsToModRep>this.maxims[Globals.MODIF_REP_ATTRS]-this.currents[Globals.MODIF_REP_ATTRS]) attsToModRep = this.maxims[Globals.MODIF_REP_ATTRS]-this.currents[Globals.MODIF_REP_ATTRS];
		if (entsToAdd>this.maxims[Globals.ADD_ENTRIES]-this.currents[Globals.ADD_ENTRIES]) entsToAdd = this.maxims[Globals.ADD_ENTRIES]-this.currents[Globals.ADD_ENTRIES];
		if (entsToDel>this.maxims[Globals.DEL_ENTRIES]-this.currents[Globals.DEL_ENTRIES]) entsToDel = this.maxims[Globals.DEL_ENTRIES]-this.currents[Globals.DEL_ENTRIES];
		
		res[Globals.MODIF_ADD_ATTRS]=attsToModAdd;
		res[Globals.MODIF_DEL_ATTRS] = attsToModDel;
		res[Globals.MODIF_REP_ATTRS] = attsToModRep;
		res[Globals.ADD_ENTRIES] = entsToAdd;
		res[Globals.DEL_ENTRIES] = entsToDel;
		
		return res;
	}
	
	
	protected void setAllowed (boolean[] allowed, int[] numbOfOps) {
		
		for (int i=0; i<Globals.NUMB_OF_OPERS; i++) {
			if (numbOfOps[i]<=0) allowed[i]=false;
		}
		allowed[Globals.MODIF_ADD_ATTRS] &= this.modifsAddCondition();
		allowed[Globals.MODIF_DEL_ATTRS] &= this.modifsDelCondition();
		allowed[Globals.MODIF_REP_ATTRS] &= this.modifsRepCondition();
		allowed[Globals.ADD_ENTRIES] &= this.addsCondition();
		allowed[Globals.DEL_ENTRIES] &= this.delsCondition();
	}
	

	protected void setAllowed (boolean[] allowed, int[] numbOfOpers, String sp, EntrySet modified, Entry[] entForCase, MyAttribute[] attForCase) {
		
		for (int i=0; i<entForCase.length; i++) {
			entForCase[i] = null; 
			attForCase[i] = null;
		}
		this.setAllowed(allowed,numbOfOpers);
		
		if (numbOfOpers[Globals.ADD_ENTRIES]==0 || this.currents[Globals.ADD_ENTRIES]>=this.maxims[Globals.ADD_ENTRIES] || this.possibleToAdd(sp,modified,entForCase,attForCase)==false) {
			numbOfOpers[Globals.ADD_ENTRIES] = 0;
			this.setAllowed(allowed,false,new int[]{Globals.ADD_ENTRIES});
		}
		int modOpts[] = new int[]{Globals.MODIF_ADD_ATTRS,Globals.MODIF_DEL_ATTRS,Globals.MODIF_REP_ATTRS};
		for (int i=0; i<modOpts.length; i++) {
			int opt = modOpts[i];
			if (numbOfOpers[opt]==0 || this.currents[opt]>=this.maxims[opt] || this.possibleToModify(opt,modified,entForCase,attForCase)==false) {
				numbOfOpers[opt] = 0;
				this.setAllowed(allowed,false,new int[]{opt});
			}
		}
		if (numbOfOpers[Globals.DEL_ENTRIES]==0 || this.currents[Globals.DEL_ENTRIES]>=this.maxims[Globals.DEL_ENTRIES] || this.possibleToDelete(modified,entForCase,attForCase)==false) {
			numbOfOpers[Globals.DEL_ENTRIES] = 0;
			this.setAllowed(allowed,false,new int[]{Globals.DEL_ENTRIES});
		}
	}
	
	
	protected int calcMaximum (int []arrInt) {
		
		int res = -999999999;
		for (int i=0; i<arrInt.length; i++) res=Math.max(res,arrInt[i]); 
		return res;
	} 
}
